/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.util.perf;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GLCapabilities;

public final class Perf {
    private static final Map<String, Sample> current = new ConcurrentHashMap<String, Sample>();
    private static final Map<String, double[]> ema = new ConcurrentHashMap<String, double[]>();
    private static long lastPublishMs = 0L;
    private static long lastBeginMs = 0L;
    private static boolean checkedCaps = false;
    private static boolean GPU_SUPPORTED = false;

    private Perf() {
    }

    private static void ensureCaps() {
        if (checkedCaps) {
            return;
        }
        checkedCaps = true;
        try {
            GLCapabilities caps = GL.getCapabilities();
            GPU_SUPPORTED = caps != null && caps.OpenGL33;
        }
        catch (Throwable t) {
            GPU_SUPPORTED = false;
        }
    }

    public static void beginFrame() {
        Perf.ensureCaps();
        current.values().forEach(s -> {
            s.cpuNs = 0L;
            s.gpuNs = 0L;
        });
    }

    public static void tryBeginFrame() {
        long now = System.currentTimeMillis();
        if (now - lastBeginMs >= 5L) {
            Perf.beginFrame();
            lastBeginMs = now;
        }
    }

    /*
     * Exception decompiling
     */
    public static void endFrame() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void startCpu(String name) {
        current.computeIfAbsent(name, Sample::new).startCpu();
    }

    public static void endCpu(String name) {
        Sample s = current.get(name);
        if (s != null) {
            s.endCpu();
        }
    }

    public static void startGpu(String name) {
        Perf.ensureCaps();
        if (!GPU_SUPPORTED) {
            return;
        }
        current.computeIfAbsent(name, Sample::new).startGpu();
    }

    public static void endGpu(String name) {
        Sample s = current.get(name);
        if (s != null) {
            s.endGpu();
        }
    }

    public static CpuScope scopeCpu(String name) {
        return new CpuScope(name);
    }

    public static GpuScope scopeGpu(String name) {
        return new GpuScope(name);
    }

    public static List<Row> snapshot() {
        double totalCpu = 0.0;
        double totalGpu = 0.0;
        for (Map.Entry<String, Sample> e : current.entrySet()) {
            Sample s = e.getValue();
            double[] m = ema.get(e.getKey());
            double cpuMs = m == null ? (double)s.cpuNs / 1000000.0 : m[0];
            double gpuMs = m == null ? (double)s.gpuNs / 1000000.0 : m[1];
            totalCpu += cpuMs;
            totalGpu += gpuMs;
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Map.Entry<String, Sample> e : current.entrySet()) {
            Sample s = e.getValue();
            double[] m = ema.get(e.getKey());
            double cpuMs = m == null ? (double)s.cpuNs / 1000000.0 : m[0];
            double gpuMs = m == null ? (double)s.gpuNs / 1000000.0 : m[1];
            double cpuPct = totalCpu > 0.0 ? cpuMs / totalCpu * 100.0 : 0.0;
            double gpuPct = totalGpu > 0.0 ? gpuMs / totalGpu * 100.0 : 0.0;
            rows.add(new Row(e.getKey(), cpuMs, cpuPct, gpuMs, gpuPct));
        }
        rows.sort(Comparator.comparingDouble(r -> -(r.cpuMs + r.gpuMs)));
        return rows;
    }

    public static final class Sample {
        public final String name;
        public long cpuNs;
        public long gpuNs;
        private long cpuStart;
        private int gpuQueryId;
        private boolean gpuActive;

        Sample(String name) {
            this.name = name;
        }

        void startCpu() {
            this.cpuStart = System.nanoTime();
        }

        void endCpu() {
            this.cpuNs += Math.max(0L, System.nanoTime() - this.cpuStart);
        }

        void startGpu() {
            if (!GPU_SUPPORTED) {
                return;
            }
            if (this.gpuActive) {
                return;
            }
            if (this.gpuQueryId == 0) {
                this.gpuQueryId = GL15.glGenQueries();
            }
            GL15.glBeginQuery((int)35007, (int)this.gpuQueryId);
            this.gpuActive = true;
        }

        void endGpu() {
            if (!GPU_SUPPORTED || !this.gpuActive) {
                return;
            }
            GL15.glEndQuery((int)35007);
            long[] tmp = new long[1];
            GL33.glGetQueryObjecti64v((int)this.gpuQueryId, (int)34918, (long[])tmp);
            long elapsed = tmp[0];
            this.gpuNs += Math.max(0L, elapsed);
            this.gpuActive = false;
        }
    }

    public static final class CpuScope
    implements AutoCloseable {
        private final String name;

        public CpuScope(String name) {
            this.name = name;
            Perf.startCpu(name);
        }

        @Override
        public void close() {
            Perf.endCpu(this.name);
        }
    }

    public static final class GpuScope
    implements AutoCloseable {
        private final String name;

        public GpuScope(String name) {
            this.name = name;
            Perf.startGpu(name);
        }

        @Override
        public void close() {
            Perf.endGpu(this.name);
        }
    }

    public static final class Row {
        public final String name;
        public final double cpuMs;
        public final double cpuPct;
        public final double gpuMs;
        public final double gpuPct;

        public Row(String name, double cpuMs, double cpuPct, double gpuMs, double gpuPct) {
            this.name = name;
            this.cpuMs = cpuMs;
            this.cpuPct = cpuPct;
            this.gpuMs = gpuMs;
            this.gpuPct = gpuPct;
        }
    }
}

