/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.util.render;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL20;

public class Shader {
    private static final int VERTEX_SHADER = GL20.glCreateShader((int)35633);
    private final int programId = GL20.glCreateProgram();

    public Shader(String fragmentShaderName) {
        int fragmentShader = GL20.glCreateShader((int)35632);
        GL20.glShaderSource((int)fragmentShader, (CharSequence)Shader.getShaderSource(fragmentShaderName));
        GL20.glCompileShader((int)fragmentShader);
        if (GL20.glGetShaderi((int)fragmentShader, (int)35713) == 0) {
            System.err.println("Fragment shader compilation failed:\n" + GL20.glGetShaderInfoLog((int)fragmentShader));
            GL20.glDeleteShader((int)fragmentShader);
        }
        GL20.glAttachShader((int)this.programId, (int)VERTEX_SHADER);
        GL20.glAttachShader((int)this.programId, (int)fragmentShader);
        GL20.glLinkProgram((int)this.programId);
        if (GL20.glGetProgrami((int)this.programId, (int)35714) == 0) {
            System.err.println("Shader program linking failed:\n" + GL20.glGetProgramInfoLog((int)this.programId));
        }
        GL20.glDeleteShader((int)fragmentShader);
    }

    public void load() {
        GL20.glUseProgram((int)this.programId);
    }

    public void unload() {
        GL20.glUseProgram((int)0);
    }

    public int getUniform(String name) {
        return GL20.glGetUniformLocation((int)this.programId, (CharSequence)name);
    }

    public void setUniformf(String name, float ... args2) {
        int loc = this.getUniform(name);
        if (loc == -1) {
            return;
        }
        switch (args2.length) {
            case 1: {
                GL20.glUniform1f((int)loc, (float)args2[0]);
                break;
            }
            case 2: {
                GL20.glUniform2f((int)loc, (float)args2[0], (float)args2[1]);
                break;
            }
            case 3: {
                GL20.glUniform3f((int)loc, (float)args2[0], (float)args2[1], (float)args2[2]);
                break;
            }
            case 4: {
                GL20.glUniform4f((int)loc, (float)args2[0], (float)args2[1], (float)args2[2], (float)args2[3]);
            }
        }
    }

    public void setUniformi(String name, int ... args2) {
        int loc = this.getUniform(name);
        if (loc == -1) {
            return;
        }
        switch (args2.length) {
            case 1: {
                GL20.glUniform1i((int)loc, (int)args2[0]);
                break;
            }
            case 2: {
                GL20.glUniform2i((int)loc, (int)args2[0], (int)args2[1]);
                break;
            }
            case 3: {
                GL20.glUniform3i((int)loc, (int)args2[0], (int)args2[1], (int)args2[2]);
                break;
            }
            case 4: {
                GL20.glUniform4i((int)loc, (int)args2[0], (int)args2[1], (int)args2[2], (int)args2[3]);
            }
        }
    }

    public void setUniformfb(String name, FloatBuffer buffer) {
        int loc = this.getUniform(name);
        if (loc != -1) {
            GL20.glUniform1fv((int)loc, (FloatBuffer)buffer);
        }
    }

    public static void draw(class_4587 stack, float x, float y, float width, float height) {
        Matrix4f matrix = stack.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, x, y, 0.0f).method_22913(0.0f, 0.0f);
        bufferBuilder.method_22918(matrix, x, y + height, 0.0f).method_22913(0.0f, 1.0f);
        bufferBuilder.method_22918(matrix, x + width, y + height, 0.0f).method_22913(1.0f, 1.0f);
        bufferBuilder.method_22918(matrix, x + width, y, 0.0f).method_22913(1.0f, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    private static String getShaderSource(String fileName) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(Shader.class.getResourceAsStream("/assets/renderutil/shaders/" + fileName))));
        try {
            string = reader.lines().filter(line -> !line.trim().isEmpty()).map(line -> line.replace("\t", "")).collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return "";
            }
        }
        reader.close();
        return string;
    }

    static {
        GL20.glShaderSource((int)VERTEX_SHADER, (CharSequence)Shader.getShaderSource("vertex.vert"));
        GL20.glCompileShader((int)VERTEX_SHADER);
        if (GL20.glGetShaderi((int)VERTEX_SHADER, (int)35713) == 0) {
            System.err.println("Vertex shader compilation failed:\n" + GL20.glGetShaderInfoLog((int)VERTEX_SHADER));
        }
    }
}

