/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.util.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.phantomvisuals.client.render.builders.Builder;
import dev.phantomvisuals.client.render.builders.states.QuadColorState;
import dev.phantomvisuals.client.render.builders.states.QuadRadiusState;
import dev.phantomvisuals.client.render.builders.states.SizeState;
import dev.phantomvisuals.client.render.renderers.impl.BuiltBlur;
import dev.phantomvisuals.client.render.renderers.impl.BuiltBorder;
import dev.phantomvisuals.client.render.renderers.impl.BuiltRectangle;
import dev.phantomvisuals.client.render.renderers.impl.BuiltText;
import dev.phantomvisuals.client.render.renderers.impl.BuiltTexture;
import dev.phantomvisuals.client.render.renderers.impl.RockstarBuiltBlur;
import dev.phantomvisuals.client.render.renderers.impl.RockstarBuiltRectangle;
import dev.phantomvisuals.client.util.Wrapper;
import dev.phantomvisuals.client.util.renderer.fonts.Instance;
import java.awt.Color;
import java.awt.image.BufferedImage;
import lombok.Generated;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public final class Render2D
implements Wrapper {
    public static void drawRoundedRect(class_4587 stack, float x, float y, float width, float height, float radius, Color color) {
        BuiltRectangle built = (BuiltRectangle)Builder.rectangle().size(new SizeState(width, height)).radius(new QuadRadiusState(radius)).color(new QuadColorState(color)).build();
        built.render(stack.method_23760().method_23761(), x, y);
    }

    public static void drawRoundedGradientRect(class_4587 stack, float x, float y, float width, float height, float radius, Color c1, Color c2, Color c3, Color c4) {
        BuiltRectangle built = (BuiltRectangle)Builder.rectangle().size(new SizeState(width, height)).radius(new QuadRadiusState(radius)).color(new QuadColorState(c1, c2, c3, c4)).build();
        built.render(stack.method_23760().method_23761(), x, y);
    }

    public static void drawRockstarRoundedRect(class_4587 stack, float x, float y, float width, float height, float radius, Color color) {
        RockstarBuiltRectangle built = (RockstarBuiltRectangle)Builder.rockstarRectangle().size(new SizeState(width, height)).radius(new QuadRadiusState(radius)).color(new QuadColorState(color)).build();
        built.render(stack.method_23760().method_23761(), x, y);
    }

    public static void drawBlurredRect(class_4587 stack, float x, float y, float width, float height, float radius, float blurRadius, Color color) {
        int layers = 3;
        float baseAlpha = color.getAlpha();
        for (int i = 0; i < layers; ++i) {
            float t = (float)(i + 1) / (float)layers;
            float falloff = 1.0f - t;
            int a = Math.max(0, Math.min(255, (int)(baseAlpha * (0.6f * falloff + 0.2f))));
            float spread = Math.max(1.0f, Math.min(12.0f, blurRadius * 0.5f)) * (float)(i + 1) * 0.5f;
            float rad = radius + (float)i * 0.6f;
            Render2D.drawRoundedRect(stack, x - spread, y - spread, width + spread * 2.0f, height + spread * 2.0f, rad, new Color(color.getRed(), color.getGreen(), color.getBlue(), a));
        }
    }

    public static void drawRockstarBlurredRect(class_4587 stack, float x, float y, float width, float height, float radius, float blurRadius, Color color) {
        RockstarBuiltBlur built = (RockstarBuiltBlur)Builder.rockstarBlur().size(new SizeState(width, height)).radius(new QuadRadiusState(radius)).color(new QuadColorState(color)).build();
        built.render(stack.method_23760().method_23761(), x, y);
        Render2D.drawRockstarRoundedRect(stack, x, y, width, height, radius, new Color(color.getRed(), color.getGreen(), color.getBlue(), 60));
    }

    public static void drawShaderBlurRect(class_4587 stack, float x, float y, float width, float height, float radius, float blurRadius, Color color) {
        BuiltBlur built = (BuiltBlur)Builder.blur().size(new SizeState(width, height)).radius(new QuadRadiusState(radius)).blurRadius(blurRadius).color(new QuadColorState(color)).build();
        built.render(stack.method_23760().method_23761(), x, y);
    }

    public static void drawBorder(class_4587 stack, float x, float y, float width, float height, float radius, float internalSmoothness, float externalSmoothness, Color color) {
        BuiltBorder built = (BuiltBorder)Builder.border().size(new SizeState(width, height)).radius(new QuadRadiusState(radius)).smoothness(internalSmoothness, externalSmoothness).color(new QuadColorState(color)).build();
        built.render(stack.method_23760().method_23761(), x, y);
    }

    public static void drawRoundedRect2(class_4587 stack, float x, float y, float width, float height, float radius1, float radius2, float radius3, float radius4, Color color) {
        BuiltRectangle built = (BuiltRectangle)Builder.rectangle().size(new SizeState(width, height)).radius(new QuadRadiusState(radius1, radius2, radius3, radius4)).color(new QuadColorState(color)).build();
        built.render(stack.method_23760().method_23761(), x, y);
    }

    public static void drawStyledRect(class_4587 stack, float x, float y, float width, float height, float radius, Color color, int blurAlpha) {
        Render2D.drawBlurredRect(stack, x, y, width, height, radius, 10.0f, new Color(255, 255, 255, blurAlpha));
        Render2D.drawRoundedRect(stack, x, y, width, height, radius, color);
    }

    public static void drawRect(class_4587 stack, float x, float y, float width, float height, Color color) {
        BuiltRectangle built = (BuiltRectangle)Builder.rectangle().size(new SizeState(width, height)).radius(new QuadRadiusState(0.0f)).color(new QuadColorState(color)).build();
        built.render(stack.method_23760().method_23761(), x, y);
    }

    public static void drawGradientRect(class_4587 stack, float x, float y, float width, float height, Color start, Color end, boolean horizontal) {
        QuadColorState quad = horizontal ? new QuadColorState(start, end, end, start) : new QuadColorState(start, start, end, end);
        BuiltRectangle built = (BuiltRectangle)Builder.rectangle().size(new SizeState(width, height)).radius(new QuadRadiusState(0.0f)).color(quad).build();
        built.render(stack.method_23760().method_23761(), x, y);
    }

    public static void drawFont(class_4587 stack, Instance instance, String text, float x, float y, Color color) {
        if (text == null || text.isEmpty() || instance == null) {
            return;
        }
        try {
            BuiltText built = (BuiltText)Builder.text().size(instance.size()).font(instance.font()).text(text).thickness(0.05f).color(color).build();
            if (built != null) {
                built.render(stack.method_23760().method_23761(), x, y);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to render text: " + text);
        }
    }

    public static void drawTexture(class_4587 stack, float x, float y, float width, float height, float radius, class_2960 texture, Color color) {
        Render2D.drawTexture(stack, x, y, width, height, radius, mc.method_1531().method_4619(texture), color);
    }

    public static void drawTexture(class_4587 stack, float x, float y, float width, float height, float radius, class_1044 texture, Color color) {
        BuiltTexture built = (BuiltTexture)Builder.texture().size(new SizeState(width, height)).radius(new QuadRadiusState(radius)).texture(1.0f, 1.0f, 1.0f, 1.0f, texture).color(new QuadColorState(color)).build();
        built.render(stack.method_23760().method_23761(), x, y);
    }

    public static void drawTexture(class_4587 stack, float x, float y, float width, float height, float radius, float u, float v, float textWidth, float texHeight, class_2960 texture, Color color) {
        BuiltTexture built = (BuiltTexture)Builder.texture().size(new SizeState(width, height)).radius(new QuadRadiusState(radius)).texture(u, v, textWidth, texHeight, mc.method_1531().method_4619(texture)).color(new QuadColorState(color)).build();
        built.render(stack.method_23760().method_23761(), x, y);
    }

    public static void startScissor(class_332 context, float x, float y, float width, float height) {
        context.method_44379((int)x, (int)y, (int)(x + width), (int)(y + height));
    }

    public static void stopScissor(class_332 context) {
        context.method_44380();
    }

    public static class_1044 convert(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        class_1011 img = new class_1011(width, height, false);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                img.method_61941(x, y, image.getRGB(x, y));
            }
        }
        return new class_1043(img);
    }

    public static void drawLine(class_4587 stack, float x1, float y1, float x2, float y2, float width, Color color) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float length = (float)Math.sqrt(dx * dx + dy * dy);
        if (length <= 0.5f) {
            return;
        }
        float angle = (float)Math.atan2(dy, dx);
        BuiltRectangle built = (BuiltRectangle)Builder.rectangle().size(new SizeState(length, width)).radius(new QuadRadiusState(0.0f)).color(new QuadColorState(color)).build();
        stack.method_22903();
        stack.method_46416(x1, y1, 0.0f);
        stack.method_22907(class_7833.field_40718.rotation(angle));
        built.render(stack.method_23760().method_23761(), 0.0f, -width / 2.0f);
        stack.method_22909();
    }

    public static void drawGlow(class_4587 stack, float x, float y, float width, float height, float radius, Color color, float intensity, int layers) {
        float step = intensity / (float)layers;
        float blurStep = radius / (float)layers;
        for (int i = 0; i < layers; ++i) {
            float alpha = step * (float)(i + 1);
            float layerRadius = radius + blurStep * (float)i;
            float offset = i * 2;
            Render2D.drawBlurredRect(stack, x - offset, y - offset, width + offset * 2.0f, height + offset * 2.0f, layerRadius, layerRadius, new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)alpha));
        }
    }

    public static void drawTextGlow(class_4587 stack, float x, float y, float width, float height, float radius, Color color, int glowAlpha, int layers) {
        for (int i = layers; i > 0; --i) {
            float factor = (float)i / (float)layers;
            float offset = (float)i * 1.5f;
            int alpha = (int)((float)glowAlpha * factor);
            Render2D.drawBlurredRect(stack, x - offset, y - offset, width + offset * 2.0f, height + offset * 2.0f, radius + offset / 2.0f, radius + offset / 2.0f, new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha));
        }
    }

    public static void drawGlowOutline(class_4587 stack, float x, float y, float width, float height, float radius, Color glowColor, int intensity, float glowRadius) {
        int layers = 5;
        for (int i = 0; i < layers; ++i) {
            float pct = (float)(i + 1) / (float)layers;
            float spread = glowRadius * pct;
            int alpha = (int)((float)intensity * (1.0f - pct * 0.8f));
            Render2D.drawRoundedRect(stack, x - spread, y - spread, width + spread * 2.0f, height + spread * 2.0f, radius + spread, new Color(glowColor.getRed(), glowColor.getGreen(), glowColor.getBlue(), alpha));
        }
    }

    public static void drawCornerOutline(class_4587 stack, float x, float y, float width, float height, float cornerSize, Color color) {
        float thickness = 2.0f;
        Render2D.drawRect(stack, x, y, cornerSize, thickness, color);
        Render2D.drawRect(stack, x, y, thickness, cornerSize, color);
        Render2D.drawRect(stack, x + width - cornerSize, y, cornerSize, thickness, color);
        Render2D.drawRect(stack, x + width - thickness, y, thickness, cornerSize, color);
        Render2D.drawRect(stack, x, y + height - thickness, cornerSize, thickness, color);
        Render2D.drawRect(stack, x, y + height - cornerSize, thickness, cornerSize, color);
        Render2D.drawRect(stack, x + width - cornerSize, y + height - thickness, cornerSize, thickness, color);
        Render2D.drawRect(stack, x + width - thickness, y + height - cornerSize, thickness, cornerSize, color);
    }

    public static void drawRoundedCorner(class_4587 stack, float x, float y, float width, float height, float cornerSize, Color cornerColor, float thickness) {
        if (cornerColor.getAlpha() <= 0) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)((float)cornerColor.getRed() / 255.0f), (float)((float)cornerColor.getGreen() / 255.0f), (float)((float)cornerColor.getBlue() / 255.0f), (float)((float)cornerColor.getAlpha() / 255.0f));
        Matrix4f matrix = stack.method_23760().method_23761();
        Render2D.drawCornerElement(matrix, x, y, cornerSize, thickness, true, true);
        Render2D.drawCornerElement(matrix, x + width - cornerSize, y, cornerSize, thickness, false, true);
        Render2D.drawCornerElement(matrix, x, y + height - cornerSize, cornerSize, thickness, true, false);
        Render2D.drawCornerElement(matrix, x + width - cornerSize, y + height - cornerSize, cornerSize, thickness, false, false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void drawCornerElement(Matrix4f matrix, float x, float y, float size, float thickness, boolean left, boolean top) {
        float hX = left ? x : x + size - thickness;
        float hY = top ? y : y + size - thickness;
        float hWidth = left ? size : thickness;
        float hHeight = thickness;
        Render2D.drawQuad(matrix, hX, hY, hWidth, hHeight);
        float vX = left ? x : x + size - thickness;
        float vY = top ? y : y + size - thickness;
        float vWidth = thickness;
        float vHeight = left ? thickness : size;
        Render2D.drawQuad(matrix, vX, vY, vWidth, vHeight);
    }

    private static void drawQuad(Matrix4f matrix, float x, float y, float width, float height) {
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix, x, y, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        bufferBuilder.method_22918(matrix, x + width, y, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        bufferBuilder.method_22918(matrix, x + width, y + height, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        bufferBuilder.method_22918(matrix, x, y + height, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    public static void drawRoundedCorner(class_4587 stack, float x, float y, float width, float height, float cornerSize, Color cornerColor) {
        Render2D.drawRoundedCorner(stack, x, y, width, height, cornerSize, cornerColor, 2.0f);
    }

    @Generated
    private Render2D() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

