/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.util.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.phantomvisuals.client.util.Wrapper;
import dev.phantomvisuals.mixin.accessors.IWorldRenderer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

public final class Render3D
implements Wrapper {
    public static boolean rendering = false;
    public static List<VertexCollection> QUADS = new ArrayList<VertexCollection>();
    public static List<VertexCollection> DEBUG_LINES = new ArrayList<VertexCollection>();
    public static List<VertexCollection> SHINE_QUADS = new ArrayList<VertexCollection>();
    public static List<VertexCollection> SHINE_DEBUG_LINES = new ArrayList<VertexCollection>();
    public static List<VertexCollection> OVERLAY_QUADS = new ArrayList<VertexCollection>();
    public static List<VertexCollection> OVERLAY_DEBUG_LINES = new ArrayList<VertexCollection>();
    public static List<VertexCollection> BLOCK_OVERLAY_LINES = new ArrayList<VertexCollection>();
    public static List<VertexCollection> HITBOX_LINES = new ArrayList<VertexCollection>();
    public static List<VertexCollection> CUSTOM_HITBOX_QUADS = new ArrayList<VertexCollection>();
    public static List<VertexCollection> CUSTOM_HITBOX_LINES = new ArrayList<VertexCollection>();
    public static float TICK_DELTA = 0.0f;
    public static float BLOCK_OVERLAY_LINE_WIDTH = 1.0f;
    public static float HITBOX_LINE_WIDTH = 1.0f;
    private static boolean spriteBatchActive = false;
    private static class_287 spriteBuffer = null;
    private static boolean spriteHasVertices = false;
    public static float DEBUG_LINE_WIDTH = 1.0f;

    public static void drawLine(class_243 c1, class_243 c2, Color red, float width) {
    }

    public static void setTickDelta(float tickDelta) {
        TICK_DELTA = tickDelta;
    }

    public static float getTickDelta() {
        return TICK_DELTA;
    }

    public static void setBlockOverlayLineWidth(float width) {
        BLOCK_OVERLAY_LINE_WIDTH = width;
    }

    public static void setHitboxLineWidth(float width) {
        HITBOX_LINE_WIDTH = width;
    }

    public static void drawBlockOverlayLine(class_243 start, class_243 end, int color) {
        if (!rendering) {
            return;
        }
        class_4587 matrices = new class_4587();
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_243 cam = Render3D.mc.field_1773.method_19418().method_19326();
        class_243 s = start.method_1020(cam);
        class_243 e = end.method_1020(cam);
        BLOCK_OVERLAY_LINES.add(new VertexCollection(new Vertex(matrix, (float)s.field_1352, (float)s.field_1351, (float)s.field_1350, color), new Vertex(matrix, (float)e.field_1352, (float)e.field_1351, (float)e.field_1350, color)));
    }

    public static void drawHitboxLine(class_243 start, class_243 end, int color) {
        if (!rendering) {
            return;
        }
        class_4587 matrices = new class_4587();
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_243 cam = Render3D.mc.field_1773.method_19418().method_19326();
        class_243 s = start.method_1020(cam);
        class_243 e = end.method_1020(cam);
        HITBOX_LINES.add(new VertexCollection(new Vertex(matrix, (float)s.field_1352, (float)s.field_1351, (float)s.field_1350, color), new Vertex(matrix, (float)e.field_1352, (float)e.field_1351, (float)e.field_1350, color)));
    }

    public static void drawCustomHitboxLine(class_243 start, class_243 end, int color) {
        if (!rendering) {
            return;
        }
        class_4587 matrices = new class_4587();
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_243 cam = Render3D.mc.field_1773.method_19418().method_19326();
        class_243 s = start.method_1020(cam);
        class_243 e = end.method_1020(cam);
        CUSTOM_HITBOX_LINES.add(new VertexCollection(new Vertex(matrix, (float)s.field_1352, (float)s.field_1351, (float)s.field_1350, color), new Vertex(matrix, (float)e.field_1352, (float)e.field_1351, (float)e.field_1350, color)));
    }

    public static void drawLines(List<VertexCollection> debugLines, float width) {
        if (debugLines.isEmpty()) {
            return;
        }
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        for (VertexCollection collection : debugLines) {
            collection.vertex(buffer);
        }
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    public static void drawLinesWithDepth(List<VertexCollection> debugLines, float width) {
        if (debugLines.isEmpty()) {
            return;
        }
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        for (VertexCollection collection : debugLines) {
            collection.vertex(buffer);
        }
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableBlend();
    }

    public static void drawQuadsWithDepth(List<VertexCollection> quads, boolean shine) {
        if (quads.isEmpty()) {
            return;
        }
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        if (shine) {
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        } else {
            RenderSystem.defaultBlendFunc();
        }
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (VertexCollection collection : quads) {
            collection.vertex(buffer);
        }
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        RenderSystem.disableCull();
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    public static void renderCustomHitBox() {
        if (!CUSTOM_HITBOX_QUADS.isEmpty()) {
            Render3D.drawQuadsWithDepth(CUSTOM_HITBOX_QUADS, false);
        }
        if (!CUSTOM_HITBOX_LINES.isEmpty()) {
            Render3D.drawLinesWithDepth(CUSTOM_HITBOX_LINES, HITBOX_LINE_WIDTH);
        }
    }

    public static void renderBlockOverlay() {
        if (!OVERLAY_QUADS.isEmpty()) {
            Render3D.drawIgnoringDepth(OVERLAY_QUADS, OVERLAY_DEBUG_LINES, false);
        }
        if (!BLOCK_OVERLAY_LINES.isEmpty()) {
            Render3D.drawLines(BLOCK_OVERLAY_LINES, BLOCK_OVERLAY_LINE_WIDTH);
        }
    }

    public static void clearCustomHitBoxQueues() {
        CUSTOM_HITBOX_QUADS.clear();
        CUSTOM_HITBOX_LINES.clear();
    }

    public static void clearBlockOverlayQueues() {
        OVERLAY_QUADS.clear();
        OVERLAY_DEBUG_LINES.clear();
        BLOCK_OVERLAY_LINES.clear();
    }

    public static void drawRibbonSegment(class_243 a, class_243 b, float halfWidth, Color color) {
        if (!rendering) {
            return;
        }
        class_243 cam = Render3D.mc.field_1773.method_19418().method_19326();
        class_243 pa = a.method_1020(cam);
        class_243 pb = b.method_1020(cam);
        class_243 dir = pb.method_1020(pa);
        if (dir.method_1027() == 0.0) {
            return;
        }
        class_243 mid = pa.method_1019(pb).method_1021(0.5);
        class_243 viewDir = mid.method_1029();
        class_243 normal = dir.method_1036(viewDir);
        if (normal.method_1027() == 0.0) {
            return;
        }
        normal = normal.method_1029().method_1021((double)halfWidth);
        class_243 aL = pa.method_1020(normal);
        class_243 aR = pa.method_1019(normal);
        class_243 bL = pb.method_1020(normal);
        class_243 bR = pb.method_1019(normal);
        class_4587 matrices = new class_4587();
        Matrix4f matrix = matrices.method_23760().method_23761();
        int rgba = color.getRGB();
        QUADS.add(new VertexCollection(new Vertex(matrix, (float)aL.field_1352, (float)aL.field_1351, (float)aL.field_1350, rgba), new Vertex(matrix, (float)aR.field_1352, (float)aR.field_1351, (float)aR.field_1350, rgba), new Vertex(matrix, (float)bR.field_1352, (float)bR.field_1351, (float)bR.field_1350, rgba), new Vertex(matrix, (float)bL.field_1352, (float)bL.field_1351, (float)bL.field_1350, rgba)));
    }

    public static void drawTexture(class_4587 matrices, float x0, float y0, float z0, float x1, float y1, float z1, class_2960 texture, Color color) {
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.depthMask((boolean)false);
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        buffer.method_22918(matrix, x0, y0, z0).method_22913(0.0f, 1.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, x1, y0, z0).method_22913(1.0f, 1.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, x1, y0, z1).method_22913(1.0f, 0.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, x0, y0, z1).method_22913(0.0f, 0.0f).method_22915(r, g, b, a);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public static void beginBillboardBatch(class_2960 texture) {
        if (spriteBatchActive) {
            return;
        }
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.depthMask((boolean)false);
        class_289 tess = class_289.method_1348();
        spriteBuffer = tess.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        spriteHasVertices = false;
        spriteBatchActive = true;
    }

    public static void batchBillboard(class_4587 matrices, class_243 worldPos, float size, int rgba) {
        if (!spriteBatchActive) {
            return;
        }
        class_243 cameraPos = Render3D.mc.field_1773.method_19418().method_19326();
        class_243 toCamera = cameraPos.method_1020(worldPos).method_1029();
        class_243 worldUp = new class_243(0.0, 1.0, 0.0);
        class_243 right = worldUp.method_1036(toCamera).method_1029().method_1021((double)size);
        class_243 up = toCamera.method_1036(right).method_1029().method_1021((double)size);
        class_243 topLeft = worldPos.method_1019(up).method_1020(right);
        class_243 topRight = worldPos.method_1019(up).method_1019(right);
        class_243 bottomLeft = worldPos.method_1020(up).method_1020(right);
        class_243 bottomRight = worldPos.method_1020(up).method_1019(right);
        class_243 cameraPosVec = Render3D.mc.method_1561().field_4686.method_19326();
        topLeft = topLeft.method_1020(cameraPosVec);
        topRight = topRight.method_1020(cameraPosVec);
        bottomLeft = bottomLeft.method_1020(cameraPosVec);
        bottomRight = bottomRight.method_1020(cameraPosVec);
        Matrix4f matrix = matrices.method_23760().method_23761();
        float r = (float)(rgba >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgba >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgba & 0xFF) / 255.0f;
        float a = (float)(rgba >>> 24 & 0xFF) / 255.0f;
        spriteBuffer.method_22918(matrix, (float)bottomLeft.field_1352, (float)bottomLeft.field_1351, (float)bottomLeft.field_1350).method_22913(0.0f, 1.0f).method_22915(r, g, b, a);
        spriteBuffer.method_22918(matrix, (float)bottomRight.field_1352, (float)bottomRight.field_1351, (float)bottomRight.field_1350).method_22913(1.0f, 1.0f).method_22915(r, g, b, a);
        spriteBuffer.method_22918(matrix, (float)topRight.field_1352, (float)topRight.field_1351, (float)topRight.field_1350).method_22913(1.0f, 0.0f).method_22915(r, g, b, a);
        spriteBuffer.method_22918(matrix, (float)topLeft.field_1352, (float)topLeft.field_1351, (float)topLeft.field_1350).method_22913(0.0f, 0.0f).method_22915(r, g, b, a);
        spriteHasVertices = true;
    }

    public static void endBillboardBatch() {
        if (!spriteBatchActive) {
            return;
        }
        if (spriteHasVertices) {
            class_286.method_43433((class_9801)spriteBuffer.method_60800());
        }
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        spriteBatchActive = false;
        spriteBuffer = null;
        spriteHasVertices = false;
    }

    public static void drawBillboardTexture(class_4587 matrices, class_243 worldPos, float size, class_2960 texture, Color color) {
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.depthMask((boolean)false);
        class_243 cameraPos = Render3D.mc.field_1773.method_19418().method_19326();
        class_243 toCamera = cameraPos.method_1020(worldPos).method_1029();
        class_243 worldUp = new class_243(0.0, 1.0, 0.0);
        class_243 right = worldUp.method_1036(toCamera).method_1029();
        class_243 up = toCamera.method_1036(right).method_1029();
        right = right.method_1021((double)size);
        up = up.method_1021((double)size);
        class_243 topLeft = worldPos.method_1019(up).method_1020(right);
        class_243 topRight = worldPos.method_1019(up).method_1019(right);
        class_243 bottomLeft = worldPos.method_1020(up).method_1020(right);
        class_243 bottomRight = worldPos.method_1020(up).method_1019(right);
        class_243 cameraPosVec = Render3D.mc.method_1561().field_4686.method_19326();
        topLeft = topLeft.method_1020(cameraPosVec);
        topRight = topRight.method_1020(cameraPosVec);
        bottomLeft = bottomLeft.method_1020(cameraPosVec);
        bottomRight = bottomRight.method_1020(cameraPosVec);
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        buffer.method_22918(matrix, (float)bottomLeft.field_1352, (float)bottomLeft.field_1351, (float)bottomLeft.field_1350).method_22913(0.0f, 1.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, (float)bottomRight.field_1352, (float)bottomRight.field_1351, (float)bottomRight.field_1350).method_22913(1.0f, 1.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, (float)topRight.field_1352, (float)topRight.field_1351, (float)topRight.field_1350).method_22913(1.0f, 0.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, (float)topLeft.field_1352, (float)topLeft.field_1351, (float)topLeft.field_1350).method_22913(0.0f, 0.0f).method_22915(r, g, b, a);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public static void drawFixedBillboardTexture(class_4587 matrices, class_243 worldPos, float size, class_2960 texture, Color color, float fixedRotation) {
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.depthMask((boolean)false);
        class_243 cameraPos = Render3D.mc.field_1773.method_19418().method_19326();
        class_243 toCamera = cameraPos.method_1020(worldPos).method_1029();
        class_243 worldUp = new class_243(0.0, 1.0, 0.0);
        class_243 right = worldUp.method_1036(toCamera).method_1029();
        class_243 up = toCamera.method_1036(right).method_1029();
        double radians = Math.toRadians(fixedRotation);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        class_243 rotatedRight = new class_243(right.field_1352 * cos - right.field_1350 * sin, right.field_1351, right.field_1352 * sin + right.field_1350 * cos);
        class_243 rotatedUp = new class_243(up.field_1352 * cos - up.field_1350 * sin, up.field_1351, up.field_1352 * sin + up.field_1350 * cos);
        rotatedRight = rotatedRight.method_1021((double)size);
        rotatedUp = rotatedUp.method_1021((double)size);
        class_243 topLeft = worldPos.method_1019(rotatedUp).method_1020(rotatedRight);
        class_243 topRight = worldPos.method_1019(rotatedUp).method_1019(rotatedRight);
        class_243 bottomLeft = worldPos.method_1020(rotatedUp).method_1020(rotatedRight);
        class_243 bottomRight = worldPos.method_1020(rotatedUp).method_1019(rotatedRight);
        class_243 cameraPosVec = Render3D.mc.method_1561().field_4686.method_19326();
        topLeft = topLeft.method_1020(cameraPosVec);
        topRight = topRight.method_1020(cameraPosVec);
        bottomLeft = bottomLeft.method_1020(cameraPosVec);
        bottomRight = bottomRight.method_1020(cameraPosVec);
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        buffer.method_22918(matrix, (float)bottomLeft.field_1352, (float)bottomLeft.field_1351, (float)bottomLeft.field_1350).method_22913(0.0f, 1.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, (float)bottomRight.field_1352, (float)bottomRight.field_1351, (float)bottomRight.field_1350).method_22913(1.0f, 1.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, (float)topRight.field_1352, (float)topRight.field_1351, (float)topRight.field_1350).method_22913(1.0f, 0.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, (float)topLeft.field_1352, (float)topLeft.field_1351, (float)topLeft.field_1350).method_22913(0.0f, 0.0f).method_22915(r, g, b, a);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public static void drawSimpleBillboardTexture(class_4587 matrices, float size, class_2960 texture, Color color) {
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.depthMask((boolean)false);
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        float half = size / 2.0f;
        buffer.method_22918(matrix, -half, -half, 0.0f).method_22913(0.0f, 1.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, half, -half, 0.0f).method_22913(1.0f, 1.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, half, half, 0.0f).method_22913(1.0f, 0.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, -half, half, 0.0f).method_22913(0.0f, 0.0f).method_22915(r, g, b, a);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public static void renderCube(class_4587 matrices, class_243 vec3d, double size, boolean fill, Color fillColor, boolean outline, Color outlineColor) {
        class_238 box = new class_238(vec3d.method_1031(-0.5 * size, -0.5 * size, -0.5 * size), vec3d.method_1031(0.5 * size, 0.5 * size, 0.5 * size));
        if (outline) {
            Render3D.renderBoxOutline(matrices, box, outlineColor);
        }
        if (fill) {
            Render3D.renderBox(matrices, box, fillColor);
        }
    }

    public static void renderCube(class_4587 matrices, class_238 box, boolean fill, Color fillColor, boolean outline, Color outlineColor) {
        if (outline) {
            Render3D.renderBoxOutline(matrices, box, outlineColor);
        }
        if (fill) {
            Render3D.renderBox(matrices, box, fillColor);
        }
    }

    public static void renderBox(class_4587 matrices, class_238 box, Color color) {
        Render3D.renderGradientBox(matrices, box, color, color);
    }

    public static void renderCustomHitboxBox(class_4587 matrices, class_238 box, Color color) {
        Render3D.renderGradientCustomHitboxBox(matrices, box, color, color);
    }

    public static void renderBoxOutline(class_4587 matrices, class_238 box, Color color) {
        Render3D.renderGradientBoxOutline(matrices, box, color, color);
    }

    public static void renderBoxOverlay(class_4587 matrices, class_238 box, Color color) {
        Render3D.renderGradientBoxOverlay(matrices, box, color, color);
    }

    public static void renderBoxOutlineOverlay(class_4587 matrices, class_238 box, Color color) {
        Render3D.renderGradientBoxOutlineOverlay(matrices, box, color, color);
    }

    public static void CustomHixBox(class_4587 matrices, class_238 box, Color fillColor, Color outlineColor, boolean fill, boolean outline) {
        if (outline) {
            Render3D.renderBoxOutline(matrices, box, outlineColor);
        }
        if (fill) {
            Render3D.renderBox(matrices, box, fillColor);
        }
    }

    public static void CustomHixBox(class_4587 matrices, class_238 box, Color color) {
        Render3D.CustomHixBox(matrices, box, color, color, true, true);
    }

    public static void CustomHixBox(class_4587 matrices, class_238 box, Color color, FillMode mode) {
        switch (mode.ordinal()) {
            case 0: {
                Render3D.renderBoxOutline(matrices, box, color);
                break;
            }
            case 1: {
                Render3D.renderBox(matrices, box, color);
                break;
            }
            case 2: {
                Render3D.renderBoxOutline(matrices, box, color);
                Render3D.renderBox(matrices, box, color);
            }
        }
    }

    public static void EnableCustomHixBox(class_4587 matrices, class_238 box, Color color, FillMode mode) {
        Render3D.prepare();
        Render3D.CustomHixBox(matrices, box, color, mode);
        Render3D.render();
    }

    public static void EnableCustomHixBox(class_4587 matrices, class_238 box, Color fillColor, Color outlineColor, boolean fill, boolean outline) {
        Render3D.prepare();
        Render3D.CustomHixBox(matrices, box, fillColor, outlineColor, fill, outline);
        Render3D.render();
    }

    public static void renderGradientBox(class_4587 matrices, class_238 box, Color startColor, Color endColor) {
        if (!rendering || !Render3D.isVisible(box)) {
            return;
        }
        Matrix4f matrix = matrices.method_23760().method_23761();
        box = Render3D.cameraTransform(box);
        QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321, startColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324, startColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324, startColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
        QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324, startColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324, startColor.getRGB())));
        QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324, startColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
        QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321, startColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
        QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321, startColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324, startColor.getRGB())));
        QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324, endColor.getRGB())));
    }

    public static void renderGradientCustomHitboxBox(class_4587 matrices, class_238 box, Color startColor, Color endColor) {
        if (!rendering || !Render3D.isVisible(box)) {
            return;
        }
        Matrix4f matrix = matrices.method_23760().method_23761();
        box = Render3D.cameraTransform(box);
        CUSTOM_HITBOX_QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321, startColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324, startColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324, startColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
        CUSTOM_HITBOX_QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324, startColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324, startColor.getRGB())));
        CUSTOM_HITBOX_QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324, startColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
        CUSTOM_HITBOX_QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321, startColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
        CUSTOM_HITBOX_QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321, startColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324, startColor.getRGB())));
        CUSTOM_HITBOX_QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324, endColor.getRGB())));
    }

    public static void renderGradientBoxOutline(class_4587 matrices, class_238 box, Color startColor, Color endColor) {
        if (!rendering || !Render3D.isVisible(box)) {
            return;
        }
        Matrix4f matrix = matrices.method_23760().method_23761();
        box = Render3D.cameraTransform(box);
        DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324, endColor.getRGB())));
        DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324, endColor.getRGB())));
        DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321, endColor.getRGB())));
        DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, endColor.getRGB())));
        DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321, startColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324, startColor.getRGB())));
        DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324, startColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324, startColor.getRGB())));
        DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324, startColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
        DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321, startColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
        DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
        DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324, startColor.getRGB())));
        DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324, startColor.getRGB())));
        DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
    }

    public static void renderGradientBoxOverlay(class_4587 matrices, class_238 box, Color startColor, Color endColor) {
        if (!rendering || !Render3D.isVisible(box)) {
            return;
        }
        Matrix4f matrix = matrices.method_23760().method_23761();
        box = Render3D.cameraTransform(box);
        OVERLAY_QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321, startColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324, startColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324, startColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
        OVERLAY_QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324, startColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324, startColor.getRGB())));
        OVERLAY_QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324, startColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
        OVERLAY_QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321, startColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
        OVERLAY_QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321, startColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324, startColor.getRGB())));
        OVERLAY_QUADS.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324, endColor.getRGB())));
    }

    public static void renderGradientBoxOutlineOverlay(class_4587 matrices, class_238 box, Color startColor, Color endColor) {
        if (!rendering || !Render3D.isVisible(box)) {
            return;
        }
        Matrix4f matrix = matrices.method_23760().method_23761();
        box = Render3D.cameraTransform(box);
        OVERLAY_DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324, endColor.getRGB())));
        OVERLAY_DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324, endColor.getRGB())));
        OVERLAY_DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321, endColor.getRGB())));
        OVERLAY_DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, endColor.getRGB())));
        OVERLAY_DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321, startColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324, startColor.getRGB())));
        OVERLAY_DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324, startColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324, startColor.getRGB())));
        OVERLAY_DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324, startColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
        OVERLAY_DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321, startColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
        OVERLAY_DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
        OVERLAY_DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1323, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1323, (float)box.field_1325, (float)box.field_1324, startColor.getRGB())));
        OVERLAY_DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1324, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324, startColor.getRGB())));
        OVERLAY_DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)box.field_1320, (float)box.field_1322, (float)box.field_1321, endColor.getRGB()), new Vertex(matrix, (float)box.field_1320, (float)box.field_1325, (float)box.field_1321, startColor.getRGB())));
    }

    public static void prepare() {
        QUADS.clear();
        DEBUG_LINES.clear();
        SHINE_QUADS.clear();
        SHINE_DEBUG_LINES.clear();
        OVERLAY_QUADS.clear();
        OVERLAY_DEBUG_LINES.clear();
        BLOCK_OVERLAY_LINES.clear();
        HITBOX_LINES.clear();
        rendering = true;
    }

    public static void render() {
        Render3D.draw(QUADS, DEBUG_LINES, false);
        Render3D.draw(SHINE_QUADS, SHINE_DEBUG_LINES, true);
        rendering = false;
    }

    public static void draw(List<VertexCollection> quads, List<VertexCollection> debugLines, boolean shine) {
        class_287 buffer;
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        if (shine) {
            RenderSystem.blendFunc((int)770, (int)32772);
        } else {
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        }
        class_289 tessellator = class_289.method_1348();
        if (!quads.isEmpty()) {
            quads.sort(Comparator.comparingDouble(VertexCollection::averageDepth).reversed());
            buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            for (VertexCollection collection : quads) {
                collection.vertex(buffer);
            }
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            RenderSystem.disableCull();
            class_286.method_43433((class_9801)buffer.method_60800());
            RenderSystem.enableCull();
        }
        if (!debugLines.isEmpty()) {
            buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
            for (VertexCollection collection : debugLines) {
                collection.vertex(buffer);
            }
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            GL11.glHint((int)3154, (int)4354);
            GL11.glEnable((int)2848);
            GL11.glLineWidth((float)DEBUG_LINE_WIDTH);
            class_286.method_43433((class_9801)buffer.method_60800());
            GL11.glDisable((int)2848);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public static void drawIgnoringDepth(List<VertexCollection> quads, List<VertexCollection> debugLines, boolean shine) {
        class_287 buffer;
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        if (shine) {
            RenderSystem.blendFunc((int)770, (int)32772);
        } else {
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        }
        class_289 tessellator = class_289.method_1348();
        if (!quads.isEmpty()) {
            buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            for (VertexCollection collection : quads) {
                collection.vertex(buffer);
            }
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            RenderSystem.disableCull();
            class_286.method_43433((class_9801)buffer.method_60800());
            RenderSystem.enableCull();
        }
        if (!debugLines.isEmpty()) {
            buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
            for (VertexCollection collection : debugLines) {
                collection.vertex(buffer);
            }
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            GL11.glHint((int)3154, (int)4354);
            GL11.glEnable((int)2848);
            GL11.glLineWidth((float)DEBUG_LINE_WIDTH);
            class_286.method_43433((class_9801)buffer.method_60800());
            GL11.glDisable((int)2848);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    private static boolean isVisible(class_238 box) {
        return ((IWorldRenderer)Render3D.mc.field_1769).getFrustum().method_23093(box);
    }

    private static class_243 cameraTransform(class_243 vec3d) {
        class_243 camera = Render3D.mc.field_1773.method_19418().method_19326();
        Vector4f vec = new Vector4f((float)(vec3d.field_1352 - camera.field_1352), (float)(vec3d.field_1351 - camera.field_1351), (float)(vec3d.field_1350 - camera.field_1350), 1.0f);
        vec.mul((Matrix4fc)new class_4587().method_23760().method_23761());
        return new class_243((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    private static class_238 cameraTransform(class_238 box) {
        class_243 min = Render3D.cameraTransform(new class_243(box.field_1323, box.field_1322, box.field_1321));
        class_243 max = Render3D.cameraTransform(new class_243(box.field_1320, box.field_1325, box.field_1324));
        return new class_238(min, max);
    }

    public static void drawLine(class_243 start, class_243 end, int color, float width) {
        if (!rendering) {
            return;
        }
        class_4587 matrices = new class_4587();
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_243 cam = Render3D.mc.field_1773.method_19418().method_19326();
        class_243 s = start.method_1020(cam);
        class_243 e = end.method_1020(cam);
        DEBUG_LINES.add(new VertexCollection(new Vertex(matrix, (float)s.field_1352, (float)s.field_1351, (float)s.field_1350, color), new Vertex(matrix, (float)e.field_1352, (float)e.field_1351, (float)e.field_1350, color)));
        GL11.glLineWidth((float)width);
    }

    public static void drawTextureVivid(class_4587 matrices, float x0, float y0, float z0, float x1, float y1, float z1, class_2960 texture, Color color, float strength) {
        Render3D.drawTextureVivid(matrices, x0, y0, z0, x1, y1, z1, texture, color, strength, VividMode.SOFT);
    }

    public static void drawTextureVivid(class_4587 matrices, float x0, float y0, float z0, float x1, float y1, float z1, class_2960 texture, Color color, float strength, VividMode mode) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        switch (mode.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
        }
        float satBoost = 0.4f + 0.3f * strength;
        switch (mode.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
        }
        float briBoost = 0.7f + 0.3f * strength;
        float h = hsb[0];
        float s = Math.min(1.0f, hsb[1] * satBoost);
        float v = Math.min(1.0f, hsb[2] * briBoost);
        int vividRgb = Color.HSBtoRGB(h, s, v);
        Color vivid = new Color(vividRgb >> 16 & 0xFF, vividRgb >> 8 & 0xFF, vividRgb & 0xFF, color.getAlpha());
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.depthMask((boolean)false);
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        float r = (float)vivid.getRed() / 255.0f;
        float g = (float)vivid.getGreen() / 255.0f;
        float b = (float)vivid.getBlue() / 255.0f;
        float a = (float)vivid.getAlpha() / 255.0f;
        buffer.method_22918(matrix, x0, y0, z0).method_22913(0.0f, 1.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, x1, y0, z0).method_22913(1.0f, 1.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, x1, y0, z1).method_22913(1.0f, 0.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, x0, y0, z1).method_22913(0.0f, 0.0f).method_22915(r, g, b, a);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    @Generated
    private Render3D() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public record VertexCollection(Vertex[] vertices) {
        public void vertex(class_287 buffer) {
            for (Vertex vertex : this.vertices) {
                buffer.method_22918(vertex.matrix, vertex.x, vertex.y, vertex.z).method_39415(vertex.color);
            }
        }

        public double averageDepth() {
            double sum = 0.0;
            int count = 0;
            for (Vertex v : this.vertices) {
                sum += (double)v.z;
                ++count;
            }
            return count == 0 ? 0.0 : sum / (double)count;
        }
    }

    public record Vertex(Matrix4f matrix, float x, float y, float z, int color) {
    }

    public static enum FillMode {
        OUTLINE,
        FILL,
        BOTH;

    }

    public static enum VividMode {
        SOFT;

    }
}

