/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.mixin;

import dev.phantomvisuals.client.events.impl.EventRender2D;
import dev.phantomvisuals.modules.impl.render.Crosshair;
import dev.phantomvisuals.modules.impl.render.NoRender;
import dev.phantomvisuals.modules.impl.render.ScoreboardMod;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import dev.phantomvisuals.phantomvisuals;
import java.awt.Color;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_266;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
public abstract class InGameHudMixin {
    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void render(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        EventRender2D event = new EventRender2D(context, tickCounter);
        phantomvisuals.getInstance().getEventHandler().post(event);
        ScoreboardMod mod = ScoreboardMod.getInstance();
        if (mod != null) {
            mod.updateDragLogic();
        }
    }

    @Inject(method={"renderHotbar"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderHotbar(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        if (this.isHudHotbarEnabled()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderStatusBars"}, at={@At(value="HEAD")}, cancellable=true)
    public void cancelStatusBars(class_332 context, CallbackInfo ci) {
        if (this.isHudHotbarEnabled()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderExperienceBar"}, at={@At(value="HEAD")}, cancellable=true)
    public void cancelXpBar(class_332 context, int i, CallbackInfo ci) {
        if (this.isHudHotbarEnabled()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderExperienceLevel"}, at={@At(value="HEAD")}, cancellable=true)
    public void cancelXpLevel(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        if (this.isHudHotbarEnabled()) {
            ci.cancel();
        }
    }

    @Unique
    private boolean isHudHotbarEnabled() {
        try {
            BooleanSetting bs;
            BooleanSetting setting = phantomvisuals.getInstance().getHudManager().getElements().getName("Hotbar");
            return setting instanceof BooleanSetting && (Boolean)(bs = setting).getValue() != false;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @Inject(method={"renderStatusEffectOverlay"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderStatusEffectOverlay(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        NoRender noRender = phantomvisuals.getInstance().getModuleManager().getModule(NoRender.class);
        if (noRender.isToggled() && ((Boolean)noRender.potions.getValue()).booleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderScoreboardSidebar(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/scoreboard/ScoreboardObjective;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderScoreboardSidebarHead(class_332 context, class_266 objective, CallbackInfo ci) {
        NoRender noRender = phantomvisuals.getInstance().getModuleManager().getModule(NoRender.class);
        if (noRender.isToggled() && ((Boolean)noRender.scoreboard.getValue()).booleanValue()) {
            ci.cancel();
            return;
        }
        ScoreboardMod mod = ScoreboardMod.getInstance();
        if (mod != null && mod.isToggled()) {
            context.method_51448().method_22903();
            float scale = ((Float)mod.scale.getValue()).floatValue();
            float xOffset = ((Float)mod.posX.getValue()).floatValue();
            float yOffset = ((Float)mod.posY.getValue()).floatValue();
            int pivotX = context.method_51421();
            int pivotY = context.method_51443() / 2;
            context.method_51448().method_46416(xOffset, yOffset, 0.0f);
            context.method_51448().method_46416((float)pivotX, (float)pivotY, 0.0f);
            context.method_51448().method_22905(scale, scale, 1.0f);
            context.method_51448().method_46416((float)(-pivotX), (float)(-pivotY), 0.0f);
            if (class_310.method_1551().field_1755 instanceof class_408 && ((Boolean)mod.showHitbox.getValue()).booleanValue()) {
                int w = 150;
                int h = 120;
                int x = pivotX - w;
                int y = pivotY - h / 2;
                context.method_49601(x, y, w, h, Color.RED.getRGB());
                context.method_25294(x, y, x + w, y + h, 0x33FF0000);
            }
        }
    }

    @Inject(method={"renderScoreboardSidebar(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/scoreboard/ScoreboardObjective;)V"}, at={@At(value="TAIL")})
    public void renderScoreboardSidebarTail(class_332 context, class_266 objective, CallbackInfo ci) {
        ScoreboardMod mod = ScoreboardMod.getInstance();
        if (mod != null && mod.isToggled()) {
            context.method_51448().method_22909();
        }
    }

    @ModifyArg(method={"renderScoreboardSidebar(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/scoreboard/ScoreboardObjective;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;fill(IIIII)V"), index=4)
    private int modifyScoreboardBackgroundColor(int color) {
        ScoreboardMod mod = ScoreboardMod.getInstance();
        if (mod != null && mod.isToggled() && ((Boolean)mod.transparent.getValue()).booleanValue()) {
            return 0;
        }
        return color;
    }

    @Inject(method={"renderCrosshair"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderCrosshair(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        if (phantomvisuals.getInstance().getModuleManager().getModule(Crosshair.class).isToggled()) {
            ci.cancel();
        }
    }

    @Unique
    private boolean isPotion(class_1799 stack, class_1291 status) {
        if (!(stack.method_7909() instanceof class_1812)) {
            return false;
        }
        class_1844 component = (class_1844)stack.method_57824(class_9334.field_49651);
        if (component == null) {
            return false;
        }
        if (component.comp_2378().isEmpty()) {
            return false;
        }
        for (class_1293 effect : ((class_1842)((class_6880)component.comp_2378().get()).comp_349()).method_8049()) {
            if (effect.method_5579().comp_349() != status) continue;
            return true;
        }
        return false;
    }
}

