/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.modules.api;

import dev.phantomvisuals.client.managers.AutoSaveManager;
import dev.phantomvisuals.client.util.Wrapper;
import dev.phantomvisuals.client.util.notify.Notify;
import dev.phantomvisuals.client.util.notify.NotifyIcons;
import dev.phantomvisuals.modules.api.Category;
import dev.phantomvisuals.modules.settings.Setting;
import dev.phantomvisuals.modules.settings.api.Bind;
import dev.phantomvisuals.phantomvisuals;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_1074;

public abstract class Module
implements Wrapper {
    private final String name;
    private final String description;
    private final Category category;
    private boolean visible = true;
    protected boolean toggled;
    private Bind bind = new Bind(-1, false);
    private final List<Setting<?>> settings = new ArrayList();

    public Module(String name, Category category, String description) {
        this.name = name;
        this.category = category;
        this.description = description;
    }

    public Module(String name, Category category) {
        this(name, category, name);
    }

    public void onEnable() {
        this.toggled = true;
        phantomvisuals.getInstance().getEventHandler().subscribe(this);
        if (!Module.fullNullCheck() && !this.name.equals("UI")) {
            String translatedName = class_1074.method_4662((String)this.name, (Object[])new Object[0]);
            String msg = class_1074.method_4662((String)"notify.featureEnabled", (Object[])new Object[]{translatedName});
            phantomvisuals.getInstance().getNotifyManager().add(new Notify(NotifyIcons.successIcon, msg, 1000L));
        }
    }

    public void onDisable() {
        this.toggled = false;
        phantomvisuals.getInstance().getEventHandler().unsubscribe(this);
        if (!Module.fullNullCheck() && !this.name.equals("UI")) {
            String translatedName = class_1074.method_4662((String)this.name, (Object[])new Object[0]);
            String msg = class_1074.method_4662((String)"notify.featureDisabled", (Object[])new Object[]{translatedName});
            phantomvisuals.getInstance().getNotifyManager().add(new Notify(NotifyIcons.failIcon, msg, 1000L));
        }
    }

    public void setToggled(boolean toggled) {
        if (toggled) {
            this.onEnable();
        } else {
            this.onDisable();
        }
        try {
            AutoSaveManager asm = phantomvisuals.getInstance().getAutoSaveManager();
            if (asm != null) {
                asm.scheduleAutoSave();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void toggle() {
        this.setToggled(!this.toggled);
    }

    protected void addSettings(Setting<?> ... settings) {
        this.settings.addAll(Arrays.asList(settings));
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public static boolean fullNullCheck() {
        return Module.mc.field_1724 == null || Module.mc.field_1687 == null;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Category getCategory() {
        return this.category;
    }

    @Generated
    public boolean isToggled() {
        return this.toggled;
    }

    @Generated
    public Bind getBind() {
        return this.bind;
    }

    @Generated
    public List<Setting<?>> getSettings() {
        return this.settings;
    }

    @Generated
    public void setBind(Bind bind) {
        this.bind = bind;
    }
}

