/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.modules.impl.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.phantomvisuals.client.events.impl.EventRender3D;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.util.perf.Perf;
import dev.phantomvisuals.modules.api.Category;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import dev.phantomvisuals.modules.settings.impl.NumberSetting;
import java.awt.Color;
import java.util.ArrayList;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1074;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class BlockOverlay
extends Module {
    private final NumberSetting lineWidth = new NumberSetting("setting.lineWidth", 2.0f, 1.0f, 5.0f, 0.1f);
    private final NumberSetting alpha = new NumberSetting("setting.alpha", 150.0f, 0.0f, 255.0f, 1.0f);
    private final BooleanSetting fill = new BooleanSetting("setting.fill", false, () -> true);
    private final NumberSetting fillAlpha = new NumberSetting("setting.fillAlpha", 50.0f, 0.0f, 255.0f, 1.0f, () -> (Boolean)this.fill.getValue());
    private final ThemeManager themeManager = ThemeManager.getInstance();

    public BlockOverlay() {
        super("BlockOverlay", Category.Render, class_1074.method_4662((String)"module.blockoverlay.description", (Object[])new Object[0]));
    }

    @Override
    public void onDisable() {
        super.onDisable();
    }

    @EventHandler
    public void onRender3D(EventRender3D.Game event) {
        if (BlockOverlay.fullNullCheck()) {
            return;
        }
        try (Perf.CpuScope __ = Perf.scopeCpu("BlockOverlay.onRender3D");){
            class_243 blockCenter;
            class_239 hitResult = BlockOverlay.mc.field_1765;
            if (hitResult == null || hitResult.method_17783() != class_239.class_240.field_1332) {
                return;
            }
            class_3965 blockHitResult = (class_3965)hitResult;
            class_2338 blockPos = blockHitResult.method_17777();
            class_243 playerPos = BlockOverlay.mc.field_1724.method_30950(event.getTickDelta());
            double distance = playerPos.method_1022(blockCenter = class_243.method_24953((class_2382)blockPos));
            if (distance > 100.0) {
                return;
            }
            Color overlayColor = this.getOverlayColor();
            Color overlayColorSecondary = this.getOverlayColorSecondary();
            class_265 shape = BlockOverlay.mc.field_1687.method_8320(blockPos).method_26218((class_1922)BlockOverlay.mc.field_1687, blockPos);
            if (shape.method_1110()) {
                class_238 blockBox = new class_238(blockPos).method_1014(0.001);
                this.renderBlockOverlayDirect(event.getMatrices(), blockBox, overlayColor, overlayColorSecondary, event.getTickDelta());
                return;
            }
            ArrayList boxes = new ArrayList();
            shape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> boxes.add(new class_238(minX, minY, minZ, maxX, maxY, maxZ).method_996(blockPos).method_1014(0.001)));
            for (class_238 b : boxes) {
                this.renderBlockOverlayDirect(event.getMatrices(), b, overlayColor, overlayColorSecondary, event.getTickDelta());
            }
        }
    }

    private Color getOverlayColor() {
        Color themeColor = this.themeManager.getCurrentTheme().getBackgroundColor();
        return new Color(themeColor.getRed(), themeColor.getGreen(), themeColor.getBlue(), ((Float)this.alpha.getValue()).intValue());
    }

    private Color getOverlayColorSecondary() {
        Color themeColorSecondary = this.themeManager.getCurrentTheme().getSecondaryBackgroundColor();
        return new Color(themeColorSecondary.getRed(), themeColorSecondary.getGreen(), themeColorSecondary.getBlue(), ((Float)this.alpha.getValue()).intValue());
    }

    private void renderBlockOverlayDirect(class_4587 matrices, class_238 box, Color overlayColor, Color overlayColorSecondary, float tickDelta) {
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        if (((Boolean)this.fill.getValue()).booleanValue()) {
            Color fillColor = new Color(overlayColor.getRed(), overlayColor.getGreen(), overlayColor.getBlue(), ((Float)this.fillAlpha.getValue()).intValue());
            Color fillColorSecondary = new Color(overlayColorSecondary.getRed(), overlayColorSecondary.getGreen(), overlayColorSecondary.getBlue(), ((Float)this.fillAlpha.getValue()).intValue());
            this.renderBoxFillGradient(matrices, box, fillColor, fillColorSecondary);
        }
        Color outlineColor = new Color(overlayColor.getRed(), overlayColor.getGreen(), overlayColor.getBlue(), ((Float)this.alpha.getValue()).intValue());
        Color outlineColorSecondary = new Color(overlayColorSecondary.getRed(), overlayColorSecondary.getGreen(), overlayColorSecondary.getBlue(), ((Float)this.alpha.getValue()).intValue());
        this.renderBoxOutlineGradient(matrices, box, outlineColor, outlineColorSecondary, ((Float)this.lineWidth.getValue()).floatValue());
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    private void renderBoxFill(class_4587 matrices, class_238 box, Color color) {
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_243 camera = BlockOverlay.mc.field_1773.method_19418().method_19326();
        float minX = (float)(box.field_1323 - camera.field_1352);
        float minY = (float)(box.field_1322 - camera.field_1351);
        float minZ = (float)(box.field_1321 - camera.field_1350);
        float maxX = (float)(box.field_1320 - camera.field_1352);
        float maxY = (float)(box.field_1325 - camera.field_1351);
        float maxZ = (float)(box.field_1324 - camera.field_1350);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    private void renderBoxOutline(class_4587 matrices, class_238 box, Color color, float lineWidth) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_243 camera = BlockOverlay.mc.field_1773.method_19418().method_19326();
        class_243 boxCenter = box.method_1005();
        double distance = camera.method_1022(boxCenter);
        float adjustedLineWidth = Math.max(0.5f, lineWidth * (float)(10.0 / Math.max(distance, 1.0)));
        GL11.glLineWidth((float)adjustedLineWidth);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        float minX = (float)(box.field_1323 - camera.field_1352);
        float minY = (float)(box.field_1322 - camera.field_1351);
        float minZ = (float)(box.field_1321 - camera.field_1350);
        float maxX = (float)(box.field_1320 - camera.field_1352);
        float maxY = (float)(box.field_1325 - camera.field_1351);
        float maxZ = (float)(box.field_1324 - camera.field_1350);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    private void renderBoxFillGradient(class_4587 matrices, class_238 box, Color startColor, Color endColor) {
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_243 camera = BlockOverlay.mc.field_1773.method_19418().method_19326();
        float minX = (float)(box.field_1323 - camera.field_1352);
        float minY = (float)(box.field_1322 - camera.field_1351);
        float minZ = (float)(box.field_1321 - camera.field_1350);
        float maxX = (float)(box.field_1320 - camera.field_1352);
        float maxY = (float)(box.field_1325 - camera.field_1351);
        float maxZ = (float)(box.field_1324 - camera.field_1350);
        float r1 = (float)startColor.getRed() / 255.0f;
        float g1 = (float)startColor.getGreen() / 255.0f;
        float b1 = (float)startColor.getBlue() / 255.0f;
        float a1 = (float)startColor.getAlpha() / 255.0f;
        float r2 = (float)endColor.getRed() / 255.0f;
        float g2 = (float)endColor.getGreen() / 255.0f;
        float b2 = (float)endColor.getBlue() / 255.0f;
        float a2 = (float)endColor.getAlpha() / 255.0f;
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r1, g1, b1, a1);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    private void renderBoxOutlineGradient(class_4587 matrices, class_238 box, Color startColor, Color endColor, float lineWidth) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_243 camera = BlockOverlay.mc.field_1773.method_19418().method_19326();
        class_243 boxCenter = box.method_1005();
        double distance = camera.method_1022(boxCenter);
        float adjustedLineWidth = Math.max(0.5f, lineWidth * (float)(10.0 / Math.max(distance, 1.0)));
        GL11.glLineWidth((float)adjustedLineWidth);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        float minX = (float)(box.field_1323 - camera.field_1352);
        float minY = (float)(box.field_1322 - camera.field_1351);
        float minZ = (float)(box.field_1321 - camera.field_1350);
        float maxX = (float)(box.field_1320 - camera.field_1352);
        float maxY = (float)(box.field_1325 - camera.field_1351);
        float maxZ = (float)(box.field_1324 - camera.field_1350);
        float r1 = (float)startColor.getRed() / 255.0f;
        float g1 = (float)startColor.getGreen() / 255.0f;
        float b1 = (float)startColor.getBlue() / 255.0f;
        float a1 = (float)startColor.getAlpha() / 255.0f;
        float r2 = (float)endColor.getRed() / 255.0f;
        float g2 = (float)endColor.getGreen() / 255.0f;
        float b2 = (float)endColor.getBlue() / 255.0f;
        float a2 = (float)endColor.getAlpha() / 255.0f;
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r1, g1, b1, a1);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r2, g2, b2, a2);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r1, g1, b1, a1);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_286.method_43433((class_9801)buffer.method_60800());
    }
}

