/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.modules.impl.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.phantomvisuals.client.events.impl.EventRender3D;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.modules.api.Category;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import dev.phantomvisuals.modules.settings.impl.NumberSetting;
import java.awt.Color;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1074;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_898;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class CustomHitBox
extends Module
implements ThemeManager.ThemeChangeListener {
    @NotNull
    public BooleanSetting fill = new BooleanSetting("setting.fill", true);
    @NotNull
    public NumberSetting lineWidth = new NumberSetting("setting.lineWidth", 1.5f, 0.5f, 6.0f, 0.1f);
    @NotNull
    public NumberSetting fillAlpha = new NumberSetting("setting.fillAlpha", 90.0f, 0.0f, 255.0f, 1.0f, () -> (Boolean)this.fill.getValue());
    @NotNull
    public NumberSetting outlineAlpha = new NumberSetting("setting.outlineAlpha", 255.0f, 0.0f, 255.0f, 1.0f);
    private final ThemeManager themeManager = ThemeManager.getInstance();
    private boolean prevRenderHitboxes;

    public CustomHitBox() {
        super("CustomHitBox", Category.Render, class_1074.method_4662((String)"module.customhitbox.description", (Object[])new Object[0]));
        this.themeManager.addThemeChangeListener(this);
    }

    @Override
    public void onThemeChanged(ThemeManager.Theme theme) {
    }

    @Override
    public void onEnable() {
        class_898 dispatcher = class_310.method_1551().method_1561();
        this.prevRenderHitboxes = dispatcher.method_3958();
        dispatcher.method_3955(true);
        super.onEnable();
    }

    @EventHandler
    public void onRender3D(EventRender3D.Game e) {
        if (CustomHitBox.fullNullCheck()) {
            return;
        }
        this.renderCustomHitBoxDirect(e.getMatrices(), e.getTickDelta());
    }

    private void renderCustomHitBoxDirect(class_4587 matrices, float tickDelta) {
        boolean wasDepthTestEnabled = GL11.glIsEnabled((int)2929);
        boolean wasBlendEnabled = GL11.glIsEnabled((int)3042);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        for (class_1297 entity : CustomHitBox.mc.field_1687.method_18112()) {
            class_1309 le;
            if (entity == CustomHitBox.mc.field_1724 || entity.method_5767() || entity instanceof class_1309 && (le = (class_1309)entity).method_6059(class_1294.field_5905)) continue;
            class_238 worldBox = entity.method_5829().method_1014(0.002);
            class_243 interpolatedPos = entity.method_30950(tickDelta);
            class_238 interpolatedBox = worldBox.method_997(interpolatedPos.method_1020(entity.method_19538()));
            Color theme = ThemeManager.getInstance().getCurrentTheme().getBackgroundColor();
            if (((Boolean)this.fill.getValue()).booleanValue()) {
                Color fillColor = new Color(theme.getRed(), theme.getGreen(), theme.getBlue(), ((Float)this.fillAlpha.getValue()).intValue());
                this.renderEntityBoxFill(matrices, interpolatedBox, fillColor);
            }
            Color outlineColor = new Color(theme.getRed(), theme.getGreen(), theme.getBlue(), ((Float)this.outlineAlpha.getValue()).intValue());
            this.renderEntityBoxOutline(matrices, interpolatedBox, outlineColor, ((Float)this.lineWidth.getValue()).floatValue());
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        if (!wasDepthTestEnabled) {
            RenderSystem.disableDepthTest();
        }
        if (!wasBlendEnabled) {
            RenderSystem.disableBlend();
        }
    }

    private void renderEntityBoxFill(class_4587 matrices, class_238 box, Color color) {
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_243 camera = CustomHitBox.mc.field_1773.method_19418().method_19326();
        float minX = (float)(box.field_1323 - camera.field_1352);
        float minY = (float)(box.field_1322 - camera.field_1351);
        float minZ = (float)(box.field_1321 - camera.field_1350);
        float maxX = (float)(box.field_1320 - camera.field_1352);
        float maxY = (float)(box.field_1325 - camera.field_1351);
        float maxZ = (float)(box.field_1324 - camera.field_1350);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    private void renderEntityBoxOutline(class_4587 matrices, class_238 box, Color color, float lineWidth) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_243 camera = CustomHitBox.mc.field_1773.method_19418().method_19326();
        class_243 boxCenter = box.method_1005();
        double distance = camera.method_1022(boxCenter);
        float adjustedLineWidth = Math.max(0.5f, lineWidth * (float)(10.0 / Math.max(distance, 1.0)));
        GL11.glLineWidth((float)adjustedLineWidth);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        float minX = (float)(box.field_1323 - camera.field_1352);
        float minY = (float)(box.field_1322 - camera.field_1351);
        float minZ = (float)(box.field_1321 - camera.field_1350);
        float maxX = (float)(box.field_1320 - camera.field_1352);
        float maxY = (float)(box.field_1325 - camera.field_1351);
        float maxZ = (float)(box.field_1324 - camera.field_1350);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, minX, maxY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, minZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, minY, maxZ).method_22915(r, g, b, a);
        buffer.method_22918(matrix, maxX, maxY, maxZ).method_22915(r, g, b, a);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    @Override
    public void onDisable() {
        class_898 dispatcher = class_310.method_1551().method_1561();
        dispatcher.method_3955(this.prevRenderHitboxes);
        super.onDisable();
    }
}

