/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.modules.impl.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.phantomvisuals.client.events.impl.EventAttackEntity;
import dev.phantomvisuals.client.events.impl.EventRender3D;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.util.animations.Animation;
import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.modules.api.Category;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.impl.NumberSetting;
import dev.phantomvisuals.phantomvisuals;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3966;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class HitBubbles
extends Module
implements ThemeManager.ThemeChangeListener {
    private final NumberSetting size = new NumberSetting("setting.size", 0.5f, 0.2f, 2.0f, 0.05f);
    private final NumberSetting lifeTime = new NumberSetting("setting.lifeTime", 0.8f, 0.2f, 2.0f, 0.05f);
    private static final long GROW_MS = 400L;
    private final class_2960 bubbleTex = phantomvisuals.id("textures/bubble.png");
    private final List<HitCircle> hitCircles = new CopyOnWriteArrayList<HitCircle>();
    private final ThemeManager themeManager = ThemeManager.getInstance();
    private Color currentColor = this.themeManager.getThemeColor();

    public HitBubbles() {
        super("HitBubbles", Category.Render, "module.hitbubbles.description");
        this.themeManager.addThemeChangeListener(this);
    }

    @Override
    public void onThemeChanged(ThemeManager.Theme theme) {
        this.currentColor = theme.getBackgroundColor();
    }

    @Override
    public void onDisable() {
        this.themeManager.removeThemeChangeListener(this);
        this.hitCircles.clear();
        super.onDisable();
    }

    @EventHandler
    private void onAttackEntity(EventAttackEntity e) {
        class_3966 ehr;
        if (HitBubbles.fullNullCheck()) {
            return;
        }
        if (e.getTarget() == HitBubbles.mc.field_1724) {
            return;
        }
        class_1297 class_12972 = e.getTarget();
        if (!(class_12972 instanceof class_1309)) {
            return;
        }
        class_1309 entity = (class_1309)class_12972;
        if (!entity.method_5805()) {
            return;
        }
        if (!e.isEffectsAllowed()) {
            return;
        }
        if (!e.canProcess()) {
            return;
        }
        class_239 ch = HitBubbles.mc.field_1765;
        class_243 hitPos = ch != null && ch.method_17783() == class_239.class_240.field_1331 ? ((ehr = (class_3966)ch).method_17782() == e.getTarget() ? ehr.method_17784() : this.computeHitOnEntityAABB(entity)) : this.computeHitOnEntityAABB(entity);
        if (hitPos == null) {
            hitPos = entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 2.0f), 0.0);
        }
        class_243 cameraPos = HitBubbles.mc.method_1561().field_4686.method_19326();
        class_243 toCamera = cameraPos.method_1020(hitPos).method_1029();
        float yaw = (float)Math.toDegrees(Math.atan2(toCamera.field_1350, toCamera.field_1352));
        float pitch = (float)Math.toDegrees(Math.atan2(-toCamera.field_1351, Math.sqrt(toCamera.field_1352 * toCamera.field_1352 + toCamera.field_1350 * toCamera.field_1350)));
        this.hitCircles.add(new HitCircle(hitPos, (long)(((Float)this.lifeTime.getValue()).floatValue() * 1000.0f), yaw, pitch));
    }

    @EventHandler
    public void onRender3D(EventRender3D.Game e) {
        if (HitBubbles.fullNullCheck()) {
            return;
        }
        long now = System.currentTimeMillis();
        this.hitCircles.removeIf(c -> now - c.spawnTime > c.ttl);
        for (HitCircle c2 : this.hitCircles) {
            long age = now - c2.spawnTime;
            c2.grow.update(true);
            float growVal = c2.grow.getValue();
            float timeFade = (float)Math.pow(1.0 - (double)((float)age / (float)c2.ttl), 0.8);
            float alphaK = Math.max(0.0f, Math.min(1.0f, growVal * timeFade));
            int alpha = (int)(255.0f * alphaK);
            if (alpha <= 2) continue;
            float r = ((Float)this.size.getValue()).floatValue() * (0.6f + 0.4f * growVal);
            Color themeColor = this.themeManager.getCurrentTheme().getBackgroundColor();
            Color drawColor = new Color(themeColor.getRed(), themeColor.getGreen(), themeColor.getBlue(), alpha);
            RenderSystem.setShader((class_10156)class_10142.field_53880);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.bubbleTex);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.disableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)515);
            RenderSystem.depthMask((boolean)false);
            class_243 cameraPos = HitBubbles.mc.method_1561().field_4686.method_19326();
            double yawRadians = Math.toRadians(c2.rotationYaw);
            double pitchRadians = Math.toRadians(c2.rotationPitch);
            double cosYaw = Math.cos(yawRadians);
            double sinYaw = Math.sin(yawRadians);
            double cosPitch = Math.cos(pitchRadians);
            double sinPitch = Math.sin(pitchRadians);
            class_243 forward = new class_243(cosYaw * cosPitch, -sinPitch, sinYaw * cosPitch).method_1029();
            class_243 worldUp = new class_243(0.0, 1.0, 0.0);
            class_243 right = worldUp.method_1036(forward).method_1029();
            class_243 up = forward.method_1036(right).method_1029();
            class_243 scaledRight = right.method_1021((double)r);
            class_243 scaledUp = up.method_1021((double)r);
            class_243 topLeft = c2.origin.method_1019(scaledUp).method_1020(scaledRight);
            class_243 topRight = c2.origin.method_1019(scaledUp).method_1019(scaledRight);
            class_243 bottomLeft = c2.origin.method_1020(scaledUp).method_1020(scaledRight);
            class_243 bottomRight = c2.origin.method_1020(scaledUp).method_1019(scaledRight);
            topLeft = topLeft.method_1020(cameraPos);
            topRight = topRight.method_1020(cameraPos);
            bottomLeft = bottomLeft.method_1020(cameraPos);
            bottomRight = bottomRight.method_1020(cameraPos);
            Matrix4f matrix = e.getMatrices().method_23760().method_23761();
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            float red = (float)drawColor.getRed() / 255.0f;
            float green = (float)drawColor.getGreen() / 255.0f;
            float blue = (float)drawColor.getBlue() / 255.0f;
            float alphaValue = (float)drawColor.getAlpha() / 255.0f;
            buffer.method_22918(matrix, (float)bottomLeft.field_1352, (float)bottomLeft.field_1351, (float)bottomLeft.field_1350).method_22913(0.0f, 1.0f).method_22915(red, green, blue, alphaValue);
            buffer.method_22918(matrix, (float)bottomRight.field_1352, (float)bottomRight.field_1351, (float)bottomRight.field_1350).method_22913(1.0f, 1.0f).method_22915(red, green, blue, alphaValue);
            buffer.method_22918(matrix, (float)topRight.field_1352, (float)topRight.field_1351, (float)topRight.field_1350).method_22913(1.0f, 0.0f).method_22915(red, green, blue, alphaValue);
            buffer.method_22918(matrix, (float)topLeft.field_1352, (float)topLeft.field_1351, (float)topLeft.field_1350).method_22913(0.0f, 0.0f).method_22915(red, green, blue, alphaValue);
            class_286.method_43433((class_9801)buffer.method_60800());
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
        }
    }

    private class_243 computeHitOnEntityAABB(class_1309 entity) {
        class_243 start = HitBubbles.mc.field_1724.method_33571();
        class_243 dir = HitBubbles.mc.field_1724.method_5828(1.0f);
        class_243 end = start.method_1019(dir.method_1021(6.0));
        class_238 bb = entity.method_5829();
        Optional res = bb.method_992(start, end);
        return res.orElse(null);
    }

    private static class HitCircle {
        final class_243 origin;
        final long spawnTime;
        final long ttl;
        final Animation grow;
        final float rotationYaw;
        final float rotationPitch;

        HitCircle(class_243 origin, long ttl, float rotationYaw, float rotationPitch) {
            this.origin = origin;
            this.spawnTime = System.currentTimeMillis();
            this.ttl = ttl;
            this.grow = new Animation(400L, 1.0, true, Easing.BOTH_SINE);
            this.rotationYaw = rotationYaw;
            this.rotationPitch = rotationPitch;
        }
    }
}

