/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.modules.impl.render;

import dev.phantomvisuals.client.events.impl.EventRender3D;
import dev.phantomvisuals.client.events.impl.EventTick;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.client.util.perf.Perf;
import dev.phantomvisuals.client.util.renderer.Render3D;
import dev.phantomvisuals.modules.api.Category;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import dev.phantomvisuals.modules.settings.impl.ListSetting;
import dev.phantomvisuals.modules.settings.impl.NumberSetting;
import dev.phantomvisuals.phantomvisuals;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1074;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_746;

public class JumpCircle
extends Module {
    private final NumberSetting size = new NumberSetting("Circle Size", 0.5f, 0.2f, 2.0f, 0.05f);
    private final NumberSetting Life_Time = new NumberSetting("Life Time", 0.5f, 0.2f, 2.0f, 0.05f);
    private final NumberSetting speed = new NumberSetting("Speed", 1.0f, 0.5f, 3.0f, 0.1f);
    private final BooleanSetting texJumpCircle = new BooleanSetting("First", true);
    private final BooleanSetting texCircle = new BooleanSetting("Second", false);
    private final ListSetting textureMode = new ListSetting("Texture", true, this.texJumpCircle, this.texCircle);
    private final BooleanSetting animGrow = new BooleanSetting("Grow", true);
    private final BooleanSetting animPulse = new BooleanSetting("Pulse", false);
    private final BooleanSetting animRipple = new BooleanSetting("Ripple", false);
    private final ListSetting animationMode = new ListSetting("Animation", true, this.animGrow, this.animPulse, this.animRipple);
    private final class_2960 texJump = phantomvisuals.id("textures/jumpcircle.png");
    private final class_2960 texCircle2 = phantomvisuals.id("textures/circle.png");
    private final List<Circle> circles = new ArrayList<Circle>();
    private boolean wasOnGround = true;
    private long lastJumpTime = 0L;

    public JumpCircle() {
        super("JumpCircle", Category.Render, class_1074.method_4662((String)"module.jumpcircle.description", (Object[])new Object[0]));
    }

    @Override
    public void onDisable() {
        this.circles.clear();
        super.onDisable();
    }

    @EventHandler
    public void onTick(EventTick e) {
        if (JumpCircle.fullNullCheck()) {
            return;
        }
        class_746 p = JumpCircle.mc.field_1724;
        boolean onGround = p.method_24828();
        long now = System.currentTimeMillis();
        if (this.wasOnGround && !onGround && p.method_18798().field_1351 > 0.01 && now - this.lastJumpTime > 100L) {
            double y = p.method_23318() + 0.05;
            this.circles.add(new Circle(new class_243(p.method_23317(), y, p.method_23321()), (long)(((Float)this.Life_Time.getValue()).floatValue() * 1000.0f)));
            this.lastJumpTime = now;
        }
        this.wasOnGround = onGround;
    }

    @EventHandler
    public void onRender3D(EventRender3D.Game e) {
        if (this.circles.isEmpty()) {
            return;
        }
        try (Perf.CpuScope __ = Perf.scopeCpu("JumpCircle.onRender3D");){
            long now = System.currentTimeMillis();
            class_243 camPos = JumpCircle.mc.field_1773.method_19418().method_19326();
            class_2960 texture = (Boolean)this.texJumpCircle.getValue() != false ? this.texJump : this.texCircle2;
            Color themeColor = ThemeManager.getInstance().getCurrentTheme().getBackgroundColor();
            int rBase = themeColor.getRed();
            int gBase = themeColor.getGreen();
            int bBase = themeColor.getBlue();
            class_4587 matrices = e.getMatrices();
            this.circles.removeIf(c -> now - c.spawnTime > c.ttl);
            for (Circle c2 : this.circles) {
                float alphaK;
                float radiusMul;
                float t = Math.min(1.0f, (float)(now - c2.spawnTime) / (float)c2.ttl * ((Float)this.speed.getValue()).floatValue());
                if (((Boolean)this.animPulse.getValue()).booleanValue()) {
                    float s = (float)Math.sin(Math.PI * 2 * (double)t);
                    radiusMul = 0.7f + 0.5f * Math.max(0.0f, s);
                    alphaK = Math.max(0.0f, s) * (1.0f - t);
                } else if (((Boolean)this.animRipple.getValue()).booleanValue()) {
                    te = Easing.EASE_OUT_CIRC.apply(t);
                    radiusMul = 0.6f + 0.8f * te;
                    alphaK = (float)Math.sin((double)t * Math.PI) * (1.0f - t);
                } else {
                    te = Easing.BOTH_SINE.apply(t);
                    radiusMul = 0.6f + 0.4f * te;
                    alphaK = (float)Math.pow(1.0f - t, 0.8) * te;
                }
                int alpha = (int)(255.0f * class_3532.method_15363((float)alphaK, (float)0.0f, (float)1.0f));
                if (alpha < 3) continue;
                float radius = ((Float)this.size.getValue()).floatValue() * radiusMul;
                int finalColor = alpha << 24 | rBase << 16 | gBase << 8 | bBase;
                matrices.method_22903();
                matrices.method_22904(c2.origin.field_1352 - camPos.field_1352, c2.origin.field_1351 - camPos.field_1351, c2.origin.field_1350 - camPos.field_1350);
                Render3D.drawTextureVivid(matrices, -radius, 0.0f, -radius, radius, 0.0f, radius, texture, new Color(finalColor, true), 1.0f);
                matrices.method_22909();
            }
        }
    }

    private static class Circle {
        final class_243 origin;
        final long spawnTime;
        final long ttl;

        Circle(class_243 origin, long ttl) {
            this.origin = origin;
            this.spawnTime = System.currentTimeMillis();
            this.ttl = ttl;
        }
    }
}

