/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.modules.impl.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.phantomvisuals.client.events.impl.EventRender3D;
import dev.phantomvisuals.client.managers.FriendsManager;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.modules.api.Category;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import dev.phantomvisuals.modules.settings.impl.NumberSetting;
import java.awt.Color;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class Nimb
extends Module {
    private final NumberSetting mainRadius = new NumberSetting("Radius", 0.45f, 0.2f, 1.0f, 0.05f);
    private final NumberSetting tubeRadius = new NumberSetting("Tube Thickness", 0.02f, 0.005f, 0.1f, 0.005f);
    private final NumberSetting verticalOffset = new NumberSetting("Height Offset", 0.3f, 0.0f, 1.0f, 0.05f);
    private final NumberSetting opacity = new NumberSetting("Opacity", 0.6f, 0.0f, 1.0f, 0.01f);
    private final BooleanSetting animations = new BooleanSetting("Animations", true);
    private final BooleanSetting showFriends = new BooleanSetting("Show Friends", true);
    private static final int RADIAL_SAMPLES = 64;
    private static final int TUBE_SAMPLES = 12;
    private static final float[] COS_U = new float[65];
    private static final float[] SIN_U = new float[65];
    private static final float[] COS_V = new float[13];
    private static final float[] SIN_V = new float[13];

    public Nimb() {
        super("Nimb", Category.Render, "\u041e\u0442\u0440\u0438\u0441\u043e\u0432\u044b\u0432\u0430\u0435\u0442 \u043e\u0431\u044a\u0435\u043c\u043d\u044b\u0439 \u043d\u0438\u043c\u0431 \u043d\u0430\u0434 \u0433\u043e\u043b\u043e\u0432\u043e\u0439");
    }

    @EventHandler
    public void onRender3D(EventRender3D.Game e) {
        if (Nimb.fullNullCheck()) {
            return;
        }
        float tickDelta = e.getTickDelta();
        class_4587 matrices = e.getMatrices();
        class_243 camPos = Nimb.mc.field_1773.method_19418().method_19326();
        for (class_1657 p : Nimb.mc.field_1687.method_18456()) {
            if (p == Nimb.mc.field_1724 && Nimb.mc.field_1690.method_31044().method_31034() || p != Nimb.mc.field_1724 && (!FriendsManager.checkFriend(p.method_7334().getName()) || !((Boolean)this.showFriends.getValue()).booleanValue())) continue;
            this.renderNimb(matrices, p, tickDelta, camPos);
        }
    }

    private void renderNimb(class_4587 matrices, class_1657 player, float tickDelta, class_243 cam) {
        class_243 pos = player.method_30950(tickDelta);
        matrices.method_22903();
        matrices.method_22904(pos.field_1352 - cam.field_1352, pos.field_1351 - cam.field_1351 + (double)player.method_17682() + (double)((Float)this.verticalOffset.getValue()).floatValue(), pos.field_1350 - cam.field_1350);
        if (((Boolean)this.animations.getValue()).booleanValue()) {
            float move = class_3532.method_15374((float)((float)(System.currentTimeMillis() % 2500L) / 2500.0f * ((float)Math.PI * 2))) * 0.04f;
            matrices.method_46416(0.0f, move, 0.0f);
        }
        float rotation = (float)(System.currentTimeMillis() % 4000L) / 4000.0f * 360.0f;
        matrices.method_22907(class_7833.field_40716.rotationDegrees(rotation));
        this.drawCleanTorus(matrices, ((Float)this.mainRadius.getValue()).floatValue(), ((Float)this.tubeRadius.getValue()).floatValue(), ThemeManager.getInstance().getCurrentTheme().getAccentColor());
        matrices.method_22909();
    }

    private void drawCleanTorus(class_4587 matrices, float radius, float tubeRadius, Color color) {
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableCull();
        float alpha = ((Float)this.opacity.getValue()).floatValue();
        GL11.glCullFace((int)1028);
        this.renderGeometry(matrices, radius, tubeRadius, color, alpha * 0.4f);
        GL11.glCullFace((int)1029);
        this.renderGeometry(matrices, radius, tubeRadius, color, alpha);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    private void renderGeometry(class_4587 matrices, float radius, float tubeRadius, Color color, float alpha) {
        Matrix4f m = matrices.method_23760().method_23761();
        class_289 tess = class_289.method_1348();
        class_287 buffer = tess.method_60827(class_293.class_5596.field_27380, class_290.field_1576);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        long time = System.currentTimeMillis();
        for (int i = 0; i < 64; ++i) {
            float cosU = COS_U[i];
            float sinU = SIN_U[i];
            float nCosU = COS_U[i + 1];
            float nSinU = SIN_U[i + 1];
            for (int j = 0; j <= 12; ++j) {
                float cV = COS_V[j];
                float sV = SIN_V[j];
                float dist = radius + tubeRadius * cV;
                float shine = (sV + 1.0f) * 0.5f;
                float shineCubed = shine * shine * shine;
                float wave = class_3532.method_15374((float)((float)i * 0.1f + (float)time / 500.0f)) * 0.1f;
                float fShine = class_3532.method_15363((float)(shineCubed + wave), (float)0.0f, (float)1.0f);
                float fR = class_3532.method_16439((float)fShine, (float)r, (float)1.0f);
                float fG = class_3532.method_16439((float)fShine, (float)g, (float)1.0f);
                float fB = class_3532.method_16439((float)fShine, (float)b, (float)1.0f);
                float fA = class_3532.method_16439((float)fShine, (float)alpha, (float)Math.min(alpha * 1.5f, 1.0f));
                buffer.method_22918(m, dist * cosU, tubeRadius * sV, dist * sinU).method_22915(fR, fG, fB, fA);
                buffer.method_22918(m, dist * nCosU, tubeRadius * sV, dist * nSinU).method_22915(fR, fG, fB, fA);
            }
        }
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    static {
        for (int i = 0; i <= 64; ++i) {
            float u = (float)i / 64.0f * ((float)Math.PI * 2);
            Nimb.COS_U[i] = class_3532.method_15362((float)u);
            Nimb.SIN_U[i] = class_3532.method_15374((float)u);
        }
        for (int j = 0; j <= 12; ++j) {
            float v = (float)j / 12.0f * ((float)Math.PI * 2);
            Nimb.COS_V[j] = class_3532.method_15362((float)v);
            Nimb.SIN_V[j] = class_3532.method_15374((float)v);
        }
    }
}

