/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.modules.impl.render;

import dev.phantomvisuals.client.events.impl.EventAttackEntity;
import dev.phantomvisuals.client.events.impl.EventRender3D;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.util.renderer.Render3D;
import dev.phantomvisuals.modules.api.Category;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import dev.phantomvisuals.modules.settings.impl.ListSetting;
import dev.phantomvisuals.modules.settings.impl.NumberSetting;
import dev.phantomvisuals.phantomvisuals;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1667;
import net.minecraft.class_1684;
import net.minecraft.class_1685;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class Particles
extends Module
implements ThemeManager.ThemeChangeListener {
    private final ListSetting triggers = new ListSetting("setting.triggers", false, new BooleanSetting("trigger.damage", true), new BooleanSetting("trigger.arrow", true), new BooleanSetting("trigger.trident", true), new BooleanSetting("trigger.pearl", true));
    private final NumberSetting amount = new NumberSetting("setting.amount", 20.0f, 5.0f, 50.0f, 1.0f);
    private final NumberSetting size = new NumberSetting("setting.size", 30.0f, 10.0f, 50.0f, 1.0f);
    private final NumberSetting scatterStrength = new NumberSetting("setting.scatter", 0.07f, 0.01f, 0.2f, 0.01f);
    private final NumberSetting animSpeed = new NumberSetting("setting.speed", 1.0f, 0.25f, 3.0f, 0.05f);
    private final NumberSetting lifeTimeSec = new NumberSetting(class_1074.method_4662((String)"setting.lifetime", (Object[])new Object[0]), 3.0f, 0.5f, 10.0f, 0.5f);
    private final ListSetting mode = new ListSetting(class_1074.method_4662((String)"setting.animationMode", (Object[])new Object[0]), true, new BooleanSetting("mode.bouncy", true), new BooleanSetting("mode.legacy", false));
    private final ListSetting damageTextures = new ListSetting("Damage Textures", false, new BooleanSetting("setting.star", true), new BooleanSetting("setting.heart", false), new BooleanSetting("setting.dollar", false), new BooleanSetting("setting.circle", false), new BooleanSetting("setting.amongus", false));
    private final ListSetting trailTextures = new ListSetting("Trail Textures", false, new BooleanSetting("setting.star", false), new BooleanSetting("setting.heart", true), new BooleanSetting("setting.dollar", false), new BooleanSetting("setting.circle", true), new BooleanSetting("setting.amongus", false));
    private static final class_2960 STAR = phantomvisuals.id("hud/star.png");
    private static final class_2960 HEART = phantomvisuals.id("hud/heart.png");
    private static final class_2960 DOLLAR = phantomvisuals.id("hud/dollar.png");
    private static final class_2960 CIRCLE = phantomvisuals.id("hud/circle.png");
    private static final class_2960 AMONGUS = phantomvisuals.id("hud/amongus.png");
    private final ThemeManager themeManager;
    private final List<Particle> particles = new CopyOnWriteArrayList<Particle>();
    private final List<PendingSpawn> pending = new CopyOnWriteArrayList<PendingSpawn>();

    public Particles() {
        super("Particles", Category.Render, "Spawns particles on attacks and projectiles.");
        this.themeManager = ThemeManager.getInstance();
        this.themeManager.addThemeChangeListener(this);
    }

    @EventHandler
    private void onAttackEntity(EventAttackEntity e) {
        class_1309 entity;
        if (Particles.fullNullCheck() || !this.isTriggerEnabled("trigger.damage")) {
            return;
        }
        class_1297 class_12972 = e.getTarget();
        if (!(class_12972 instanceof class_1309) || (entity = (class_1309)class_12972) == Particles.mc.field_1724) {
            return;
        }
        if (!entity.method_5805() || !e.canProcess()) {
            return;
        }
        List<class_2960> activeTextures = this.getActiveTextures(this.damageTextures);
        if (activeTextures.isEmpty()) {
            return;
        }
        int spawnCount = Math.round(((Float)this.amount.getValue()).floatValue());
        long lifeMs = (long)(((Float)this.lifeTimeSec.getValue()).floatValue() * 1000.0f);
        class_2960 tex = activeTextures.get(ThreadLocalRandom.current().nextInt(activeTextures.size()));
        class_243 base = this.computeHitOnEntityAABB(entity);
        if (base == null) {
            base = entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 2.0f), 0.0);
        }
        for (int i = 0; i < spawnCount; ++i) {
            this.ensureSpace();
            this.particles.add(Particle.createDamage(this, base, tex, lifeMs, ((Float)this.scatterStrength.getValue()).floatValue()));
        }
    }

    @EventHandler
    public void onRender3D(EventRender3D.Game e) {
        if (Particles.fullNullCheck()) {
            return;
        }
        long now = System.currentTimeMillis();
        this.spawnProjectileTrails(e.getTickDelta());
        this.handlePendingSpawns(now);
        this.particles.removeIf(p -> now - p.spawnTime > p.lifeTime || Particles.mc.field_1724.method_19538().method_1022(p.pos) > 100.0);
        class_243 cameraPos = Particles.mc.field_1773.method_19418().method_19326();
        Color themeColor = this.themeManager.getCurrentTheme().getAccentColor();
        for (Particle p2 : this.particles) {
            p2.updatePhysics();
            float f = Math.max(0.0f, 1.0f - (float)(now - p2.spawnTime) / (float)p2.lifeTime);
            int alpha = (int)(204.0f * f);
            if (alpha <= 0) continue;
            float worldSize = ((Float)this.size.getValue()).floatValue() * 0.012f * f;
            Color color = new Color(themeColor.getRed(), themeColor.getGreen(), themeColor.getBlue(), alpha);
            class_243 toCam = cameraPos.method_1020(p2.pos);
            class_243 renderPos = toCam.method_1027() > 0.0 ? p2.pos.method_1019(toCam.method_1029().method_1021(0.02)) : p2.pos;
            Render3D.drawBillboardTexture(e.getMatrices(), renderPos, worldSize, p2.tex, color);
        }
    }

    private void spawnProjectileTrails(float tickDelta) {
        if (Particles.mc.field_1687 == null) {
            return;
        }
        List<class_2960> activeTextures = this.getActiveTextures(this.trailTextures);
        if (activeTextures.isEmpty()) {
            return;
        }
        for (class_1297 entity : Particles.mc.field_1687.method_18112()) {
            boolean isMoving = entity.method_18798().method_1027() > 1.0E-4;
            boolean shouldSpawn = false;
            if (this.isTriggerEnabled("trigger.arrow") && entity instanceof class_1667) {
                if (!entity.method_24828() && isMoving) {
                    shouldSpawn = true;
                }
            } else if (this.isTriggerEnabled("trigger.trident") && entity instanceof class_1685) {
                if (!entity.method_24828() && isMoving) {
                    shouldSpawn = true;
                }
            } else if (this.isTriggerEnabled("trigger.pearl") && entity instanceof class_1684 && !entity.method_24828() && isMoving) {
                shouldSpawn = true;
            }
            if (!shouldSpawn || !(ThreadLocalRandom.current().nextFloat() <= 0.4f)) continue;
            this.ensureSpace();
            class_2960 tex = activeTextures.get(ThreadLocalRandom.current().nextInt(activeTextures.size()));
            long lifeMs = (long)(((Float)this.lifeTimeSec.getValue()).floatValue() * 600.0f);
            double x = entity.field_6014 + (entity.method_23317() - entity.field_6014) * (double)tickDelta;
            double y = entity.field_6036 + (entity.method_23318() - entity.field_6036) * (double)tickDelta + (double)entity.method_17682() / 2.0;
            double z = entity.field_5969 + (entity.method_23321() - entity.field_5969) * (double)tickDelta;
            this.particles.add(Particle.createTrail(this, new class_243(x, y, z), tex, lifeMs));
        }
    }

    private void handlePendingSpawns(long now) {
        if (!this.isModeEnabled("mode.bouncy")) {
            this.pending.clear();
            return;
        }
        List<class_2960> activeTextures = this.getActiveTextures(this.damageTextures);
        if (activeTextures.isEmpty()) {
            return;
        }
        this.pending.removeIf(ps -> {
            if (ps.entity == null || !ps.entity.method_5805() || now - ps.createdAt > 250L) {
                return true;
            }
            if (ps.entity.field_6235 > 0) {
                int j = 0;
                while ((float)j < ((Float)this.amount.getValue()).floatValue()) {
                    this.ensureSpace();
                    class_2960 tex = (class_2960)activeTextures.get(ThreadLocalRandom.current().nextInt(activeTextures.size()));
                    this.particles.add(Particle.createDamage(this, ps.impactPoint, tex, (long)(((Float)this.lifeTimeSec.getValue()).floatValue() * 1000.0f), ((Float)this.scatterStrength.getValue()).floatValue()));
                    ++j;
                }
                return true;
            }
            return false;
        });
    }

    private List<class_2960> getActiveTextures(ListSetting setting) {
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        for (BooleanSetting b : setting.getToggled()) {
            String n = b.getName();
            if (n.contains("star")) {
                list.add(STAR);
                continue;
            }
            if (n.contains("heart")) {
                list.add(HEART);
                continue;
            }
            if (n.contains("dollar")) {
                list.add(DOLLAR);
                continue;
            }
            if (n.contains("circle")) {
                list.add(CIRCLE);
                continue;
            }
            if (!n.contains("amongus")) continue;
            list.add(AMONGUS);
        }
        return list;
    }

    private boolean isTriggerEnabled(String name) {
        BooleanSetting b = this.triggers.getName(name);
        return b != null && (Boolean)b.getValue() != false;
    }

    private boolean isModeEnabled(String name) {
        BooleanSetting b = this.mode.getName(name);
        return b != null && (Boolean)b.getValue() != false;
    }

    private class_243 computeHitOnEntityAABB(class_1309 entity) {
        class_243 start = Particles.mc.field_1724.method_33571();
        class_243 end = start.method_1019(Particles.mc.field_1724.method_5828(1.0f).method_1021(6.0));
        Optional res = entity.method_5829().method_992(start, end);
        return res.orElse(null);
    }

    private void ensureSpace() {
        if (this.particles.size() >= 1000) {
            this.particles.remove(0);
        }
    }

    private double groundTopY(class_243 pos) {
        if (Particles.mc.field_1687 == null) {
            return Double.NaN;
        }
        class_2338 bp = new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350);
        class_2680 state = Particles.mc.field_1687.method_8320(bp.method_10074());
        class_265 shape = state.method_26220((class_1922)Particles.mc.field_1687, bp.method_10074());
        if (shape.method_1110()) {
            return Double.NaN;
        }
        return (double)bp.method_10074().method_10264() + shape.method_1107().field_1325;
    }

    @Override
    public void onThemeChanged(ThemeManager.Theme theme) {
    }

    @Override
    public void onDisable() {
        this.particles.clear();
        this.pending.clear();
        this.themeManager.removeThemeChangeListener(this);
        super.onDisable();
    }

    private static class Particle {
        class_243 pos;
        class_243 velocityPhysics;
        class_2960 tex;
        long spawnTime;
        long lifeTime;
        int bounces = 0;
        final Particles owner;

        Particle(Particles o, class_243 p, class_243 v, class_2960 t, long lt) {
            this.owner = o;
            this.pos = p;
            this.velocityPhysics = v;
            this.tex = t;
            this.spawnTime = System.currentTimeMillis();
            this.lifeTime = lt;
        }

        static Particle createDamage(Particles o, class_243 p, class_2960 t, long lt, float s) {
            class_243 vel = new class_243(ThreadLocalRandom.current().nextDouble(-s, s), ThreadLocalRandom.current().nextDouble(0.1, 0.3), ThreadLocalRandom.current().nextDouble(-s, s));
            return new Particle(o, p, vel, t, lt);
        }

        static Particle createTrail(Particles o, class_243 p, class_2960 t, long lt) {
            return new Particle(o, p, new class_243(0.0, 0.01, 0.0), t, lt);
        }

        void updatePhysics() {
            double s = ((Float)this.owner.animSpeed.getValue()).floatValue();
            this.velocityPhysics = this.velocityPhysics.method_1023(0.0, 6.0E-5 * s, 0.0);
            class_243 nextPos = this.pos.method_1019(this.velocityPhysics.method_1021(s));
            double groundY = this.owner.groundTopY(nextPos);
            if (!Double.isNaN(groundY) && nextPos.field_1351 <= groundY + 0.03) {
                this.pos = new class_243(nextPos.field_1352, groundY + 0.03, nextPos.field_1350);
                if (this.velocityPhysics.field_1351 < 0.0) {
                    if (this.bounces < 3) {
                        this.velocityPhysics = new class_243(this.velocityPhysics.field_1352 * 0.8, -this.velocityPhysics.field_1351 * 0.3, this.velocityPhysics.field_1350 * 0.8);
                        ++this.bounces;
                    } else {
                        this.velocityPhysics = new class_243(0.0, 0.0, 0.0);
                    }
                }
            } else {
                this.pos = nextPos;
            }
        }
    }

    private static class PendingSpawn {
        final class_1309 entity;
        final class_243 impactPoint;
        final long createdAt;

        PendingSpawn(class_1309 e, class_243 p, long c) {
            this.entity = e;
            this.impactPoint = p;
            this.createdAt = c;
        }
    }
}

