/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.modules.impl.render;

import dev.phantomvisuals.client.events.impl.EventRender2D;
import dev.phantomvisuals.client.events.impl.EventRender3D;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.Render3D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import dev.phantomvisuals.client.util.world.WorldUtils;
import dev.phantomvisuals.modules.api.Category;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1667;
import net.minecraft.class_1684;
import net.minecraft.class_1685;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class Predictions
extends Module
implements ThemeManager.ThemeChangeListener {
    private final List<String> allowedServers = Arrays.asList("localhost", "bpvp.su", "bworld.pro", "sworld.space", "mc.prostotrainer.space", "ru.prostotrainer.space", "eu.prostotrainer.space");
    private final List<ProjectilePoint> projectilePoints = new ArrayList<ProjectilePoint>();
    private final List<ProjectilePoint> prevProjectilePoints = new ArrayList<ProjectilePoint>();
    private final ThemeManager themeManager;
    private Color currentColor;
    private Color currentColorSecondary;
    private final BooleanSetting showPearl = new BooleanSetting("Show Pearl", true, () -> true);
    private final BooleanSetting showBow = new BooleanSetting("Show Bow", true, () -> true);
    private final BooleanSetting showCrossbow = new BooleanSetting("Show Crossbow", true, () -> true);
    private final BooleanSetting showTrident = new BooleanSetting("Show Trident", true, () -> true);
    private final BooleanSetting showWhenHolding = new BooleanSetting("Show When Holding", true, () -> true);
    private final BooleanSetting showLandingInfo = new BooleanSetting("Show Landing Info", true, () -> true);
    private final BooleanSetting highlightPlayers = new BooleanSetting("Highlight Players", true, () -> true);
    private static final double highlightRange = 100.0;
    private static final int MAX_TICKS = 240;
    private static final int SUBSTEPS = 8;
    private static final float BASE_LINE_WIDTH = 4.0f;
    private static final double PEARL_SPEED = 1.5;
    private static final double PEARL_SPEED_FACTOR = 1.06;
    private static final double PEARL_GRAVITY = 0.03;
    private static final double ARROW_SPEED = 3.0;
    private static final double ARROW_GRAVITY = 0.05;
    private static final double TRIDENT_SPEED = 2.5;
    private static final double TRIDENT_GRAVITY = 0.03;
    private static final double WATER_DRAG = 0.8;
    private static final double AIR_DRAG = 0.99;

    @Override
    public boolean isVisible() {
        class_310 client = class_310.method_1551();
        if (client.method_1558() == null) {
            return false;
        }
        String ip = client.method_1558().field_3761.toLowerCase();
        return this.allowedServers.stream().anyMatch(ip::contains);
    }

    public Predictions() {
        super("Predictions", Category.Render, class_1074.method_4662((String)"module.predictions.description", (Object[])new Object[0]));
        this.themeManager = ThemeManager.getInstance();
        this.currentColor = this.themeManager.getThemeColor();
        this.currentColorSecondary = this.themeManager.getCurrentTheme().getSecondaryBackgroundColor();
        this.themeManager.addThemeChangeListener(this);
    }

    @Override
    public void onThemeChanged(ThemeManager.Theme theme) {
        this.currentColor = theme.getBackgroundColor();
        this.currentColorSecondary = theme.getSecondaryBackgroundColor();
    }

    @Override
    public void onDisable() {
        this.themeManager.removeThemeChangeListener(this);
        this.projectilePoints.clear();
        this.prevProjectilePoints.clear();
        super.onDisable();
    }

    @EventHandler
    public void onRender2D(EventRender2D e) {
        if (Predictions.fullNullCheck()) {
            return;
        }
        if (((Boolean)this.showLandingInfo.getValue()).booleanValue() && !this.projectilePoints.isEmpty()) {
            this.renderLandingInfo2D(e);
        }
    }

    @EventHandler
    public void onRender3D(EventRender3D.Game e) {
        if (Predictions.fullNullCheck()) {
            return;
        }
        if (!this.isVisible()) {
            if (this.isToggled()) {
                this.setToggled(false);
            }
            return;
        }
        Render3D.setTickDelta(e.getTickDelta());
        this.prevProjectilePoints.clear();
        this.prevProjectilePoints.addAll(this.projectilePoints);
        this.projectilePoints.clear();
        boolean hasPlayerProjectiles = false;
        for (class_1297 ent : Predictions.mc.field_1687.method_18112()) {
            if (ent instanceof class_1684) {
                class_1684 pearl = (class_1684)ent;
                if (((Boolean)this.showPearl.getValue()).booleanValue()) {
                    boolean isPlayerThrown = pearl.method_24921() == Predictions.mc.field_1724;
                    hasPlayerProjectiles |= isPlayerThrown;
                    this.simulatePearl(pearl, isPlayerThrown);
                    continue;
                }
            }
            if (ent instanceof class_1667) {
                class_1667 arrow = (class_1667)ent;
                if (((Boolean)this.showBow.getValue()).booleanValue()) {
                    if (arrow.method_24828() || !(arrow.method_18798().method_1027() >= 0.01)) continue;
                    hasPlayerProjectiles = true;
                    this.simulateArrow(arrow);
                    continue;
                }
            }
            if (!(ent instanceof class_1685)) continue;
            class_1685 trident = (class_1685)ent;
            if (!((Boolean)this.showTrident.getValue()).booleanValue() || trident.method_24828() || !(trident.method_18798().method_1027() >= 0.01)) continue;
            hasPlayerProjectiles = true;
            this.simulateTrident(trident);
        }
        if (Predictions.mc.field_1724 != null && ((Boolean)this.showWhenHolding.getValue()).booleanValue() && !hasPlayerProjectiles) {
            class_1799 main = Predictions.mc.field_1724.method_6047();
            class_1799 off = Predictions.mc.field_1724.method_6079();
            if ((main.method_31574(class_1802.field_8634) || off.method_31574(class_1802.field_8634)) && ((Boolean)this.showPearl.getValue()).booleanValue()) {
                this.simulatePearlFromHand();
            }
            if (Predictions.mc.field_1724.method_6115()) {
                class_1792 item = Predictions.mc.field_1724.method_6030().method_7909();
                if (item == class_1802.field_8102 && ((Boolean)this.showBow.getValue()).booleanValue()) {
                    this.simulateBowFromHand();
                }
                if (item == class_1802.field_8547 && ((Boolean)this.showTrident.getValue()).booleanValue()) {
                    this.simulateTridentFromHand();
                }
            }
            if ((class_1764.method_7781((class_1799)main) || class_1764.method_7781((class_1799)off)) && ((Boolean)this.showCrossbow.getValue()).booleanValue()) {
                this.simulateCrossbowFromHand();
            }
        }
        if (!this.projectilePoints.isEmpty()) {
            this.renderProjectileTrajectory3D(e, hasPlayerProjectiles);
        }
        if (((Boolean)this.highlightPlayers.getValue()).booleanValue()) {
            for (ProjectilePoint p : this.projectilePoints) {
                if (!p.isLandingPoint() || !p.isPlayerThrown()) continue;
                for (class_1297 entity : Predictions.mc.field_1687.method_18112()) {
                    class_1309 living;
                    if (!(entity instanceof class_1309) || (living = (class_1309)entity) == Predictions.mc.field_1724 || !living.method_5805() || !living.method_5829().method_1014(0.3).method_1006(p.pos()) || !(Predictions.mc.field_1724.method_19538().method_1022(living.method_19538()) <= 100.0)) continue;
                    this.renderPlayerHighlight(e, living);
                }
            }
        }
    }

    private void simulateProjectileLanding(class_243 startPos, class_243 initialVelocity, ProjectileType type, boolean isMoving, boolean isPlayerThrown) {
        class_243 pos = startPos;
        class_243 vel = initialVelocity;
        int ticks = 0;
        block5: for (int t = 0; t < 240; ++t) {
            for (int s = 0; s < 8; ++s) {
                class_243 prev = pos;
                double drag = this.isInWater(pos) ? 0.8 : 0.99;
                double dragPerSub = Math.pow(drag, 0.125);
                double speedF = type == ProjectileType.PEARL ? 1.06 : 1.0;
                pos = pos.method_1019(vel.method_1021(speedF / 8.0));
                if (isPlayerThrown) {
                    for (class_1297 entity : Predictions.mc.field_1687.method_18112()) {
                        if (entity == Predictions.mc.field_1724 || !entity.method_5829().method_1014(0.3).method_1006(pos)) continue;
                        this.projectilePoints.add(new ProjectilePoint(pos, ticks, true, System.nanoTime(), type, isMoving, entity, isPlayerThrown));
                        break block5;
                    }
                }
                this.projectilePoints.add(new ProjectilePoint(pos, ticks, false, System.nanoTime(), type, isMoving, null, isPlayerThrown));
                class_3965 hit = Predictions.mc.field_1687.method_17742(new class_3959(prev, pos, class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)Predictions.mc.field_1724));
                if (hit.method_17783() == class_239.class_240.field_1332) {
                    this.projectilePoints.add(new ProjectilePoint(hit.method_17784(), ticks, true, System.nanoTime(), type, isMoving, null, isPlayerThrown));
                    break block5;
                }
                if (pos.field_1351 < -128.0) break block5;
                double grav = switch (type.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> 0.03;
                    case 1 -> 0.05;
                    case 2 -> 0.03;
                };
                vel = vel.method_1023(0.0, grav * speedF * (this.isInWater(pos) ? 0.2 : 1.0) / 8.0, 0.0).method_1021(dragPerSub);
            }
            ++ticks;
        }
    }

    private void simulatePearl(class_1684 p, boolean b) {
        this.simulateProjectileLanding(p.method_19538(), p.method_18798(), ProjectileType.PEARL, true, b);
    }

    private void simulateArrow(class_1667 a) {
        this.simulateProjectileLanding(a.method_19538(), a.method_18798(), ProjectileType.ARROW, true, true);
    }

    private void simulateTrident(class_1685 tr) {
        this.simulateProjectileLanding(tr.method_19538(), tr.method_18798(), ProjectileType.TRIDENT, true, true);
    }

    private void simulatePearlFromHand() {
        this.simulateHand(1.5, ProjectileType.PEARL);
    }

    private void simulateBowFromHand() {
        this.simulateHand(3.0, ProjectileType.ARROW);
    }

    private void simulateCrossbowFromHand() {
        this.simulateHand(3.0, ProjectileType.ARROW);
    }

    private void simulateTridentFromHand() {
        this.simulateHand(2.5, ProjectileType.TRIDENT);
    }

    private void simulateHand(double speed, ProjectileType type) {
        class_243 vel = new class_243(-Math.sin(Math.toRadians(Predictions.mc.field_1724.method_36454())) * Math.cos(Math.toRadians(Predictions.mc.field_1724.method_36455())), -Math.sin(Math.toRadians(Predictions.mc.field_1724.method_36455())), Math.cos(Math.toRadians(Predictions.mc.field_1724.method_36454())) * Math.cos(Math.toRadians(Predictions.mc.field_1724.method_36455()))).method_1021(speed);
        this.simulateProjectileLanding(Predictions.mc.field_1724.method_33571(), vel, type, false, true);
    }

    private boolean isInWater(class_243 pos) {
        return Predictions.mc.field_1687 != null && Predictions.mc.field_1687.method_8320(class_2338.method_49638((class_2374)pos)).method_26227().method_15771();
    }

    private void renderProjectileTrajectory3D(EventRender3D.Game e, boolean b) {
        List<List<ProjectilePoint>> groups2 = this.groupTrajectories(this.projectilePoints);
        Render3D.prepare();
        Render3D.DEBUG_LINE_WIDTH = 4.0f;
        for (List<ProjectilePoint> group : groups2) {
            if (group.size() < 2) continue;
            for (int i = 1; i < group.size(); ++i) {
                float t = (float)i / (float)group.size();
                int color = this.getGradientColor(t);
                Render3D.drawLine(group.get(i - 1).pos(), group.get(i).pos(), color, 4.0f);
            }
        }
        Render3D.render();
    }

    private int getGradientColor(float t) {
        int r = (int)((float)this.currentColor.getRed() * (1.0f - t) + (float)this.currentColorSecondary.getRed() * t);
        int g = (int)((float)this.currentColor.getGreen() * (1.0f - t) + (float)this.currentColorSecondary.getGreen() * t);
        int b = (int)((float)this.currentColor.getBlue() * (1.0f - t) + (float)this.currentColorSecondary.getBlue() * t);
        return new Color(r, g, b, (int)(Math.max(0.1, (double)(1.0f - t)) * 255.0)).getRGB();
    }

    private List<List<ProjectilePoint>> groupTrajectories(List<ProjectilePoint> points) {
        ArrayList<List<ProjectilePoint>> out = new ArrayList<List<ProjectilePoint>>();
        if (points.isEmpty()) {
            return out;
        }
        ArrayList<ProjectilePoint> curr = new ArrayList<ProjectilePoint>();
        ProjectileType last = null;
        for (ProjectilePoint p : points) {
            if (last != null && last != p.type()) {
                out.add(new ArrayList(curr));
                curr.clear();
            }
            curr.add(p);
            last = p.type();
        }
        out.add(curr);
        return out;
    }

    private void renderLandingInfo2D(EventRender2D e) {
        for (ProjectilePoint p : this.projectilePoints) {
            if (!p.isLandingPoint()) continue;
            class_243 lp = WorldUtils.getPosition(p.pos);
            if (!(lp.field_1350 > 0.0) || !(lp.field_1350 < 1.0)) continue;
            Render2D.drawRoundedRect(e.getContext().method_51448(), (float)lp.field_1352 - 20.0f, (float)lp.field_1351 + 4.0f, 40.0f, 14.0f, 3.0f, new Color(0, 0, 0, 150));
            Render2D.drawFont(e.getContext().method_51448(), Fonts.MEDIUM.getFont(7.5f), String.format("%.1f s", (double)p.ticks / 20.0), (float)lp.field_1352 - 4.0f, (float)lp.field_1351 + 8.0f, Color.WHITE);
        }
    }

    private void renderPlayerHighlight(EventRender3D.Game e, class_1309 p) {
        class_238 b = p.method_5829().method_1014(0.1);
        Render3D.renderBox(e.getMatrices(), b, new Color(this.currentColor.getRed(), this.currentColor.getGreen(), this.currentColor.getBlue(), 80));
        Render3D.renderBoxOutline(e.getMatrices(), b, this.currentColor);
    }

    private record ProjectilePoint(class_243 pos, int ticks, boolean isLandingPoint, long creationTime, ProjectileType type, boolean isMoving, class_1297 hitEntity, boolean isPlayerThrown) {
    }

    private static enum ProjectileType {
        PEARL,
        ARROW,
        TRIDENT;

    }
}

