/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.modules.impl.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.phantomvisuals.client.events.impl.EventAttackEntity;
import dev.phantomvisuals.client.events.impl.EventRender2D;
import dev.phantomvisuals.client.events.impl.EventRender3D;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.render.renderers.JelloRenderer;
import dev.phantomvisuals.client.render.renderers.SoulRenderer;
import dev.phantomvisuals.client.util.animations.Animation;
import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.client.util.async.Async;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.world.WorldUtils;
import dev.phantomvisuals.modules.api.Category;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import dev.phantomvisuals.modules.settings.impl.ListSetting;
import dev.phantomvisuals.modules.settings.impl.NumberSetting;
import dev.phantomvisuals.phantomvisuals;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class TargetEsp
extends Module
implements ThemeManager.ThemeChangeListener {
    private static final float BASE_SIZE = 5.0f;
    private final BooleanSetting modeMarker = new BooleanSetting("mode.marker", true, () -> false);
    private final BooleanSetting modeGhosts = new BooleanSetting("mode.soul", false, () -> false);
    private final BooleanSetting modeSpirits = new BooleanSetting("mode.spirits", false, () -> false);
    private final BooleanSetting modeJello = new BooleanSetting("mode.circle", false, () -> false);
    private final BooleanSetting modeOrbit = new BooleanSetting("mode.orbit", false, () -> false);
    private final BooleanSetting modeMarkerOld = new BooleanSetting("old", false, () -> false);
    private final BooleanSetting modeMarkerNew = new BooleanSetting("new", true, () -> false);
    private final BooleanSetting spiritsStyleNormal = new BooleanSetting("Normal", true, () -> false);
    private final BooleanSetting spiritsStyleNew = new BooleanSetting("New", false, () -> false);
    private final BooleanSetting spiritsStyleOld = new BooleanSetting("Old", false, () -> false);
    private final ListSetting spiritsModeStyle = new ListSetting("Spirits Style", true, this.spiritsStyleNormal, this.spiritsStyleNew, this.spiritsStyleOld);
    private final ListSetting mode = new ListSetting(class_1074.method_4662((String)"setting.animationMode", (Object[])new Object[0]), true, this.modeMarker, this.modeGhosts, this.modeSpirits, this.modeJello, this.modeOrbit);
    private final BooleanSetting hitFlash = new BooleanSetting("Hit Flash", true, () -> true);
    private final NumberSetting markerScale = new NumberSetting("setting.markerSize", 3.0f, 0.5f, 8.0f, 0.1f);
    private final BooleanSetting markerGlow = new BooleanSetting("setting.markerGlow", true, () -> (Boolean)this.modeMarker.getValue());
    private final NumberSetting markerGlowIntensity = new NumberSetting("setting.glowIntensity", 0.8f, 0.1f, 2.0f, 0.1f);
    private ListSetting markerMode = new ListSetting("setting.markerMode", true, this.modeMarkerOld, this.modeMarkerNew);
    private final NumberSetting ghostsScale = new NumberSetting("setting.ghostsScale", 0.3f, 0.05f, 1.0f, 0.01f);
    private final NumberSetting ghostsParticleDensity = new NumberSetting("setting.particleDensity", 14.0f, 5.0f, 20.0f, 1.0f);
    private final BooleanSetting ghostsGlow = new BooleanSetting("setting.markerGlow", true, () -> (Boolean)this.modeGhosts.getValue());
    private final NumberSetting ghostsGlowIntensity = new NumberSetting("setting.glowIntensity", 0.5f, 0.1f, 1.5f, 0.1f);
    private final NumberSetting ghostsAlpha = new NumberSetting("setting.alpha", 1.0f, 0.1f, 1.0f, 0.1f);
    private final BooleanSetting spiritsGlow = new BooleanSetting("Glow", true, () -> (Boolean)this.modeSpirits.getValue());
    private final NumberSetting jelloHeight = new NumberSetting("setting.jelloHeight", 1.5f, 0.5f, 3.0f, 0.1f);
    private final NumberSetting jelloAnimationSpeed = new NumberSetting("setting.animationSpeed", 2500.0f, 1000.0f, 5000.0f, 100.0f);
    private final BooleanSetting jelloGlow = new BooleanSetting("setting.markerGlow", true, () -> (Boolean)this.modeJello.getValue());
    private final NumberSetting jelloGlowIntensity = new NumberSetting("setting.glowIntensity", 0.5f, 0.1f, 1.5f, 0.1f);
    private final NumberSetting jelloAlpha = new NumberSetting("setting.alpha", 1.0f, 0.1f, 1.0f, 0.1f);
    private final NumberSetting orbitDistance = new NumberSetting("Orbit Distance", 0.4f, 0.1f, 1.5f, 0.05f);
    private final NumberSetting orbitSize = new NumberSetting("Orbit Size", 0.2f, 0.01f, 1.0f, 0.01f);
    private final NumberSetting orbitTilt = new NumberSetting("Orbit Tilt", 0.4f, 0.0f, 1.0f, 0.05f);
    private final BooleanSetting orbitTrail = new BooleanSetting("Orbit Trail", true, this.modeOrbit::getValue);
    private final BooleanSetting orbitGlow = new BooleanSetting("Glow", true, this.modeOrbit::getValue);
    private final List<OrbitTrailPoint> trailPoints = new ArrayList<OrbitTrailPoint>();
    private final ThemeManager themeManager;
    private Color currentColor;
    private final SoulRenderer soulRenderer;
    private final JelloRenderer jelloRenderer;
    private final Animation animation = new Animation(300L, 1.0, true, Easing.BOTH_SINE);
    private final Animation soulAnimation = new Animation(500L, 1.0, true, Easing.BOTH_SINE);
    private final Animation jelloAnimation = new Animation(500L, 1.0, true, Easing.BOTH_SINE);
    private final Animation orbitAnimation = new Animation(500L, 1.0, true, Easing.BOTH_SINE);
    private class_1309 lastTarget = null;
    private class_1309 fadingTarget = null;
    private long lastSeenTime = 0L;
    private static final long ESP_DURATION = 2500L;
    private long lastHitTime = 0L;
    private static final long HIT_FLASH_DURATION = 300L;
    private long lastSpiritsTime = 0L;
    private float animationNurik = 0.0f;
    private long currentTimeSpirits = 0L;
    private class_243 lastKnownCenter = null;
    private float lastKnownHeight = 1.8f;
    private float lastKnownWidth = 0.6f;
    private boolean forceFade = false;
    private class_243 fadeOrigin = null;
    private long lastOcclusionAt = 0L;
    private boolean lastOcclusion = false;
    private volatile float cachedFinalSize = -1.0f;
    private volatile int cachedColorRGBA = -1;
    private volatile float cachedRotation = 0.0f;

    public TargetEsp() {
        super("TargetEsp", Category.Render, class_1074.method_4662((String)"module.targetesp.description", (Object[])new Object[0]));
        this.addSettings(this.mode, this.hitFlash);
        this.markerScale.setVisible(this.modeMarker::getValue);
        this.markerGlow.setVisible(this.modeMarker::getValue);
        this.markerGlowIntensity.setVisible(() -> (Boolean)this.modeMarker.getValue() != false && (Boolean)this.markerGlow.getValue() != false);
        this.markerMode.setVisible(this.modeMarker::getValue);
        this.spiritsModeStyle.setVisible(this.modeSpirits::getValue);
        this.spiritsGlow.setVisible(this.modeSpirits::getValue);
        this.ghostsScale.setVisible(this.modeGhosts::getValue);
        this.ghostsParticleDensity.setVisible(this.modeGhosts::getValue);
        this.ghostsGlow.setVisible(this.modeGhosts::getValue);
        this.ghostsGlowIntensity.setVisible(() -> (Boolean)this.modeGhosts.getValue() != false && (Boolean)this.ghostsGlow.getValue() != false);
        this.ghostsAlpha.setVisible(this.modeGhosts::getValue);
        this.jelloHeight.setVisible(this.modeJello::getValue);
        this.jelloAnimationSpeed.setVisible(this.modeJello::getValue);
        this.jelloGlow.setVisible(this.modeJello::getValue);
        this.jelloGlowIntensity.setVisible(() -> (Boolean)this.modeJello.getValue() != false && (Boolean)this.jelloGlow.getValue() != false);
        this.jelloAlpha.setVisible(this.modeJello::getValue);
        this.orbitDistance.setVisible(this.modeOrbit::getValue);
        this.orbitSize.setVisible(this.modeOrbit::getValue);
        this.orbitTilt.setVisible(this.modeOrbit::getValue);
        this.orbitTrail.setVisible(this.modeOrbit::getValue);
        this.orbitGlow.setVisible(this.modeOrbit::getValue);
        this.themeManager = ThemeManager.getInstance();
        this.currentColor = this.themeManager.getThemeColor();
        this.themeManager.addThemeChangeListener(this);
        this.soulRenderer = new SoulRenderer(this.themeManager);
        this.jelloRenderer = new JelloRenderer(this.themeManager);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.trailPoints.clear();
    }

    @Override
    public void onThemeChanged(ThemeManager.Theme theme) {
        this.currentColor = theme.getBackgroundColor();
    }

    private static int clamp255(double v) {
        return v < 0.0 ? 0 : (v > 255.0 ? 255 : (int)Math.round(v));
    }

    private Color getTargetColor() {
        if (((Boolean)this.hitFlash.getValue()).booleanValue() && System.currentTimeMillis() - this.lastHitTime < 300L) {
            return Color.RED;
        }
        return this.currentColor;
    }

    private class_243 entityCenter(class_1309 ent, EventRender2D e) {
        return ent.method_30950(e.getTickDelta()).method_1031(0.0, (double)ent.method_17682() * 0.5, 0.0);
    }

    private boolean isOccluded(class_243 from, class_243 to) {
        long now = System.currentTimeMillis();
        if (now - this.lastOcclusionAt < 50L) {
            return this.lastOcclusion;
        }
        class_3965 hr = TargetEsp.mc.field_1687.method_17742(new class_3959(from, to, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)TargetEsp.mc.field_1724));
        this.lastOcclusion = hr.method_17783() != class_239.class_240.field_1333;
        this.lastOcclusionAt = now;
        return this.lastOcclusion;
    }

    @EventHandler
    public void onAttackEntity(EventAttackEntity e) {
        if (this.lastTarget != null && e.getTarget() == this.lastTarget) {
            this.lastHitTime = System.currentTimeMillis();
        }
    }

    @EventHandler
    public void onRender2D(EventRender2D e) {
        class_1309 living;
        class_3966 hit;
        if (TargetEsp.fullNullCheck()) {
            return;
        }
        long now = System.currentTimeMillis();
        class_239 class_2392 = TargetEsp.mc.field_1765;
        if (class_2392 instanceof class_3966 && (class_2392 = (hit = (class_3966)class_2392).method_17782()) instanceof class_1309 && (living = (class_1309)class_2392).method_5805()) {
            class_243 center = this.entityCenter(living, e);
            if (!living.method_5767() && !this.isOccluded(TargetEsp.mc.field_1724.method_5836(e.getTickDelta()), center)) {
                if (this.lastTarget != living) {
                    this.lastSpiritsTime = 0L;
                    this.currentTimeSpirits = 0L;
                    this.animationNurik = 0.0f;
                }
                this.lastTarget = living;
                this.lastSeenTime = now;
                this.forceFade = false;
                this.fadingTarget = null;
                this.lastKnownCenter = center;
                this.lastKnownHeight = living.method_17682();
                this.lastKnownWidth = living.method_17681();
            }
        }
        if (!(this.lastTarget == null || this.lastTarget.method_5805() && now - this.lastSeenTime <= 2500L)) {
            this.fadeOrigin = this.lastKnownCenter;
            this.fadingTarget = this.lastTarget;
            this.lastTarget = null;
            this.forceFade = true;
        }
        this.animation.update(this.lastTarget != null && (Boolean)this.modeMarker.getValue() != false);
        this.soulAnimation.update(this.lastTarget != null && ((Boolean)this.modeGhosts.getValue() != false || (Boolean)this.modeSpirits.getValue() != false));
        this.jelloAnimation.update(this.lastTarget != null && (Boolean)this.modeJello.getValue() != false);
        this.orbitAnimation.update(this.lastTarget != null && (Boolean)this.modeOrbit.getValue() != false);
        if (((Boolean)this.modeMarker.getValue()).booleanValue()) {
            this.renderMarker(e);
        }
    }

    @EventHandler
    public void onRender3D(EventRender3D.Game e) {
        class_243 basePos;
        if (TargetEsp.fullNullCheck()) {
            return;
        }
        class_1309 target = this.lastTarget != null ? this.lastTarget : this.fadingTarget;
        class_243 class_2432 = basePos = target != null ? target.method_30950(e.getTickDelta()) : this.fadeOrigin;
        if (basePos == null) {
            return;
        }
        if (((Boolean)this.modeOrbit.getValue()).booleanValue() && this.orbitAnimation.getValue() > 0.0f) {
            this.renderOrbitWithTrail(e, basePos);
        } else if (((Boolean)this.modeSpirits.getValue()).booleanValue() && this.soulAnimation.getValue() > 0.0f) {
            if (((Boolean)this.spiritsStyleNormal.getValue()).booleanValue()) {
                this.renderSpiritsNormal(e, target, e.getTickDelta());
            } else if (((Boolean)this.spiritsStyleNew.getValue()).booleanValue()) {
                this.renderSpiritsNew(e, target, e.getTickDelta());
            } else if (((Boolean)this.spiritsStyleOld.getValue()).booleanValue()) {
                this.renderSpiritsOld(e, target, e.getTickDelta());
            }
        } else if (((Boolean)this.modeGhosts.getValue()).booleanValue() && this.soulAnimation.getValue() > 0.0f) {
            this.soulRenderer.render(e, target, ((Float)this.ghostsParticleDensity.getValue()).intValue(), ((Float)this.ghostsScale.getValue()).floatValue(), (Boolean)this.ghostsGlow.getValue(), ((Float)this.ghostsGlowIntensity.getValue()).floatValue(), this.soulAnimation.getValue(), this.fadeOrigin, this.lastKnownHeight, this.lastKnownWidth, ((Float)this.ghostsAlpha.getValue()).floatValue(), this.getTargetColor());
        } else if (((Boolean)this.modeJello.getValue()).booleanValue() && this.jelloAnimation.getValue() > 0.0f) {
            this.jelloRenderer.render(e, target, this.fadeOrigin, this.lastKnownWidth, this.lastKnownHeight, ((Float)this.jelloHeight.getValue()).doubleValue(), ((Float)this.jelloAnimationSpeed.getValue()).doubleValue(), (Boolean)this.jelloGlow.getValue(), ((Float)this.jelloGlowIntensity.getValue()).doubleValue(), this.jelloAnimation.getValue(), this.getTargetColor());
        }
    }

    private void renderSpiritsNormal(EventRender3D.Game e, class_1309 target, float partialTicks) {
        double o;
        double c;
        double s;
        double angle;
        int i;
        int baseColor;
        if (target == null) {
            return;
        }
        double radius = 0.3 + (double)(target.method_17681() / 2.0f);
        float animVal = this.soulAnimation.getValue();
        float speed = 30.0f;
        float size = 0.4f;
        double distance = 6.0;
        int length = 40;
        class_243 cameraPos = TargetEsp.mc.field_1773.method_19418().method_19326();
        class_4184 camera = TargetEsp.mc.field_1773.method_19418();
        if (this.lastSpiritsTime == 0L) {
            this.lastSpiritsTime = System.currentTimeMillis();
        }
        long currentTime = System.currentTimeMillis();
        class_243 interpolated = target.method_30950(partialTicks);
        interpolated = new class_243(interpolated.field_1352, interpolated.field_1351 + 0.32 + (double)(target.method_17682() / 2.0f), interpolated.field_1350);
        int color1 = baseColor = this.multAlpha(this.getTargetColor().getRGB(), animVal);
        int color2 = this.multDark(baseColor, 0.8f);
        int color3 = this.multDark(baseColor, 0.6f);
        int color4 = this.multDark(baseColor, 0.4f);
        class_4587 matrices = e.getMatrices();
        this.setupRender((Boolean)this.spiritsGlow.getValue());
        matrices.method_22903();
        matrices.method_22904(interpolated.field_1352 + 0.2 - cameraPos.field_1352, interpolated.field_1351 - cameraPos.field_1351, interpolated.field_1350 - cameraPos.field_1350);
        float sfz = 0.3f;
        for (i = 0; i < length; ++i) {
            angle = (double)0.05f * ((double)(currentTime - this.lastSpiritsTime) - (double)i * distance) / (double)speed;
            s = Math.sin(angle * Math.PI) * radius;
            c = Math.cos(angle * Math.PI) * radius;
            o = Math.cos(angle * Math.PI) * radius;
            this.renderSpiritParticle(matrices, camera, i, length, sfz, size, s, o, -c, color1, color2, color3, color4);
        }
        for (i = 0; i < length; ++i) {
            angle = (double)0.05f * ((double)(currentTime - this.lastSpiritsTime) - (double)i * distance) / (double)speed;
            s = Math.sin(angle * Math.PI) * radius;
            c = Math.cos(angle * Math.PI) * radius;
            o = Math.sin(angle * Math.PI) * radius;
            this.renderSpiritParticle(matrices, camera, i, length, sfz, size, -s, o, -c, color1, color2, color3, color4);
        }
        for (i = 0; i < length; ++i) {
            angle = (double)0.05f * ((double)(currentTime - this.lastSpiritsTime) - (double)i * distance) / (double)speed;
            s = Math.sin(angle * Math.PI) * radius;
            c = Math.cos(angle * Math.PI) * radius;
            o = Math.sin(angle * Math.PI) * radius;
            this.renderSpiritParticle(matrices, camera, i, length, sfz, size, s, o, c, color1, color2, color3, color4);
        }
        matrices.method_22909();
        this.finishRender();
    }

    private void renderSpiritsNew(EventRender3D.Game e, class_1309 target, float partialTicks) {
        long timeDiff;
        if (target == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.currentTimeSpirits == 0L) {
            this.currentTimeSpirits = currentTime;
        }
        if ((timeDiff = currentTime - this.currentTimeSpirits) > 0L) {
            this.animationNurik += (float)(5L * timeDiff) / 900.0f;
        }
        this.currentTimeSpirits = currentTime;
        class_243 lerpedPos = target.method_30950(partialTicks);
        class_243 cameraPos = TargetEsp.mc.field_1773.method_19418().method_19326();
        float alphaPC = this.soulAnimation.getValue();
        int baseColor = this.getTargetColor().getRGB();
        class_4587 matrices = e.getMatrices();
        class_4184 camera = TargetEsp.mc.field_1773.method_19418();
        this.setupRender((Boolean)this.spiritsGlow.getValue());
        matrices.method_22903();
        for (int i = 0; i < 9; i += 3) {
            for (int j = 0; j < 12; ++j) {
                float f2 = this.animationNurik + (float)j * 0.1f;
                int n5 = (int)Math.pow(i, 2.0);
                double pX = lerpedPos.field_1352 - cameraPos.field_1352 + 0.75 * Math.sin(f2 + (float)n5);
                double pY = lerpedPos.field_1351 - cameraPos.field_1351 + 0.5 + (double)0.3f * Math.sin(this.animationNurik + (float)j * 0.2f) + (double)(0.2f * (float)i);
                double pZ = lerpedPos.field_1350 - cameraPos.field_1350 + 0.75 * Math.cos(f2 - (float)n5);
                matrices.method_22903();
                matrices.method_22904(pX, pY, pZ);
                float scale = 0.005f + (float)j / 2000.0f;
                matrices.method_22905(scale, scale, scale);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(-camera.method_19330()));
                matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
                int r = baseColor >> 16 & 0xFF;
                int g = baseColor >> 8 & 0xFF;
                int b = baseColor & 0xFF;
                int a = (int)(alphaPC * 255.0f);
                this.drawRawQuad(matrices.method_23760().method_23761(), -25.0f, 50.0f, r, g, b, a);
                matrices.method_22909();
            }
        }
        matrices.method_22909();
        this.finishRender();
    }

    private void renderSpiritsOld(EventRender3D.Game e, class_1309 target, float partialTicks) {
        long timeDiff;
        if (target == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.currentTimeSpirits == 0L) {
            this.currentTimeSpirits = currentTime;
        }
        if ((timeDiff = currentTime - this.currentTimeSpirits) > 0L) {
            this.animationNurik += (float)(5L * timeDiff) / 200.0f;
        }
        this.currentTimeSpirits = currentTime;
        class_243 lerpedPos = target.method_30950(partialTicks);
        class_243 cameraPos = TargetEsp.mc.field_1773.method_19418().method_19326();
        float alphaPC = this.soulAnimation.getValue();
        int baseColor = this.getTargetColor().getRGB();
        class_4184 camera = TargetEsp.mc.field_1773.method_19418();
        double targetWidth = target.method_17681() + 0.12f;
        class_4587 matrices = e.getMatrices();
        this.setupRender((Boolean)this.spiritsGlow.getValue());
        matrices.method_22903();
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i <= 17; ++i) {
                double radians = Math.toRadians((((float)i / 1.5f + this.animationNurik) * 6.0f + (float)(j * 120)) % 2160.0f);
                double sinQuad = Math.sin(Math.toRadians(this.animationNurik * 2.0f + (float)(i * (j + 1))) * (double)1.1f) / 1.25;
                float offset = (float)i / 17.0f;
                matrices.method_22903();
                matrices.method_22904(lerpedPos.field_1352 - cameraPos.field_1352 + Math.cos(radians) * targetWidth, lerpedPos.field_1351 + (double)1.1f - cameraPos.field_1351 + sinQuad, lerpedPos.field_1350 - cameraPos.field_1350 + Math.sin(radians) * targetWidth);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(-camera.method_19330()));
                matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
                int col = this.multAlpha(baseColor, offset * alphaPC);
                int r = col >> 16 & 0xFF;
                int g = col >> 8 & 0xFF;
                int b = col & 0xFF;
                int a = col >> 24 & 0xFF;
                float scale = Math.max(0.25f * offset, 0.22f);
                this.drawRawQuad(matrices.method_23760().method_23761(), -scale, scale * 2.0f, r, g, b, a);
                matrices.method_22909();
            }
        }
        matrices.method_22909();
        this.finishRender();
    }

    private void renderSpiritParticle(class_4587 matrices, class_4184 camera, int i, int length, float sfz, float sizeBase, double x, double y, double z, int c1, int c2, int c3, int c4) {
        float scale = 1.0f - (float)i / (float)(length - 1) * sfz;
        float curSize = sizeBase * scale;
        matrices.method_22903();
        matrices.method_22904(x, y, z);
        matrices.method_46416(-curSize / 2.0f, -curSize / 2.0f, 0.0f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-camera.method_19330()));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrices.method_46416(curSize / 2.0f, curSize / 2.0f, 0.0f);
        this.drawSpiritsQuad(matrices.method_23760().method_23761(), c1, c2, c3, c4, curSize);
        matrices.method_22909();
    }

    private void drawSpiritsQuad(Matrix4f matrix, int color1, int color2, int color3, int color4, float size) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a1 = color1 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r3 = color3 >> 16 & 0xFF;
        int g3 = color3 >> 8 & 0xFF;
        int b3 = color3 & 0xFF;
        int a3 = color3 >> 24 & 0xFF;
        int r4 = color4 >> 16 & 0xFF;
        int g4 = color4 >> 8 & 0xFF;
        int b4 = color4 & 0xFF;
        int a4 = color4 >> 24 & 0xFF;
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        buffer.method_22918(matrix, 0.0f, -size, 0.0f).method_22913(0.0f, 0.0f).method_1336(r1, g1, b1, a1);
        buffer.method_22918(matrix, -size, -size, 0.0f).method_22913(0.0f, 1.0f).method_1336(r2, g2, b2, a2);
        buffer.method_22918(matrix, -size, 0.0f, 0.0f).method_22913(1.0f, 1.0f).method_1336(r3, g3, b3, a3);
        buffer.method_22918(matrix, 0.0f, 0.0f, 0.0f).method_22913(1.0f, 0.0f).method_1336(r4, g4, b4, a4);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    private void drawRawQuad(Matrix4f matrix, float n7, float n8, int r, int g, int b, int a) {
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        buffer.method_22918(matrix, n7, n7 + n8, 0.0f).method_22913(0.0f, 1.0f).method_1336(r, g, b, a);
        buffer.method_22918(matrix, n7 + n8, n7 + n8, 0.0f).method_22913(1.0f, 1.0f).method_1336(r, g, b, a);
        buffer.method_22918(matrix, n7 + n8, n7, 0.0f).method_22913(1.0f, 0.0f).method_1336(r, g, b, a);
        buffer.method_22918(matrix, n7, n7, 0.0f).method_22913(0.0f, 0.0f).method_1336(r, g, b, a);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    private void setupRender(boolean useGlow) {
        RenderSystem.enableBlend();
        if (useGlow) {
            RenderSystem.blendFunc((int)770, (int)1);
        } else {
            RenderSystem.defaultBlendFunc();
        }
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        RenderSystem.setShaderTexture((int)0, (class_2960)phantomvisuals.id("hud/glow.png"));
    }

    private void finishRender() {
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
        RenderSystem.defaultBlendFunc();
    }

    private int multAlpha(int color, float alpha) {
        return (int)((float)(color >> 24 & 0xFF) * alpha) << 24 | color & 0xFFFFFF;
    }

    private int multDark(int color, float factor) {
        int r = (int)((float)(color >> 16 & 0xFF) * factor);
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        return (color >> 24 & 0xFF) << 24 | r << 16 | g << 8 | b;
    }

    private void renderOrbitWithTrail(EventRender3D.Game e, class_243 pos) {
        class_4587 matrices = e.getMatrices();
        float anim = this.orbitAnimation.getValue();
        if (anim <= 0.001f) {
            return;
        }
        float baseSize = ((Float)this.orbitSize.getValue()).floatValue();
        double radius = this.lastKnownWidth + ((Float)this.orbitDistance.getValue()).floatValue();
        float time = (float)(System.currentTimeMillis() % 3000L) / 3000.0f * (float)Math.PI * 2.0f;
        long now = System.currentTimeMillis();
        Color c = this.getTargetColor();
        if (this.lastTarget != null) {
            for (int i = 0; i < 3; ++i) {
                float angle = time + (float)i * 2.0943952f;
                double x = pos.field_1352 + Math.cos(angle) * radius;
                double z = pos.field_1350 + Math.sin(angle) * radius;
                double y = pos.field_1351 + (double)this.lastKnownHeight * 0.5 + Math.sin(angle) * (double)((Float)this.orbitTilt.getValue()).floatValue();
                if (((Boolean)this.orbitTrail.getValue()).booleanValue()) {
                    this.trailPoints.add(new OrbitTrailPoint(new class_243(x, y, z), now, true, c));
                    continue;
                }
                this.drawOrbitParticle(matrices, new class_243(x, y, z), 1.0f, true, anim, baseSize, c);
            }
        }
        if (((Boolean)this.orbitTrail.getValue()).booleanValue()) {
            this.trailPoints.removeIf(p -> now - p.time > 600L);
            for (OrbitTrailPoint p2 : this.trailPoints) {
                float life = 1.0f - (float)(now - p2.time) / 600.0f;
                if (!(life > 0.05f)) continue;
                this.drawOrbitParticle(matrices, p2.pos, life, p2.isMain, anim, baseSize, this.getTargetColor());
            }
        }
    }

    private void drawOrbitParticle(class_4587 matrices, class_243 pointPos, float life, boolean isMain, float anim, float baseSize, Color c) {
        this.setupRender((Boolean)this.orbitGlow.getValue());
        class_243 cam = TargetEsp.mc.field_1773.method_19418().method_19326();
        int a = (int)(255.0f * ((Float)this.ghostsAlpha.getValue()).floatValue() * anim * (life * life));
        if (a <= 5) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904(pointPos.field_1352 - cam.field_1352, pointPos.field_1351 - cam.field_1351, pointPos.field_1350 - cam.field_1350);
        matrices.method_22907(TargetEsp.mc.field_1773.method_19418().method_23767());
        float s = (isMain ? baseSize : baseSize * 0.4f) * anim * (0.3f + life * 0.7f);
        if (s > 0.001f) {
            this.drawRawQuad(matrices.method_23760().method_23761(), -s, s * 2.0f, c.getRed(), c.getGreen(), c.getBlue(), a);
        }
        matrices.method_22909();
        this.finishRender();
    }

    private void renderMarker(EventRender2D e) {
        class_243 centerWorld;
        class_243 class_2432 = centerWorld = this.lastTarget != null ? this.entityCenter(this.lastTarget, e) : this.fadeOrigin;
        if (centerWorld == null) {
            return;
        }
        float animVal = this.animation.getValue();
        class_243 pos = WorldUtils.getPosition(centerWorld);
        if (pos.field_1350 < 0.0 || pos.field_1350 > 1.0) {
            return;
        }
        e.getContext().method_51448().method_22903();
        e.getContext().method_51448().method_22904(pos.method_10216(), pos.method_10214(), 0.0);
        if (animVal > 0.0f) {
            float maxSize = (float)WorldUtils.getScale(centerWorld, 5.0f * ((Float)this.markerScale.getValue()).floatValue() * animVal);
            Async.run(() -> {
                this.cachedFinalSize = maxSize;
                this.cachedRotation = (float)(Math.sin((double)System.currentTimeMillis() / 1000.0) * 360.0);
                Color mCol = this.getTargetColor();
                this.cachedColorRGBA = TargetEsp.clamp255(255.0f * animVal) << 24 | mCol.getRed() << 16 | mCol.getGreen() << 8 | mCol.getBlue();
            });
            if (((Boolean)this.markerGlow.getValue()).booleanValue()) {
                float gS = maxSize * (1.0f + ((Float)this.markerGlowIntensity.getValue()).floatValue() * 0.5f);
                Render2D.drawTexture(e.getContext().method_51448(), -gS / 2.0f, -gS / 2.0f, gS, gS, 0.0f, phantomvisuals.id("hud/glow.png"), this.currentColor);
            }
            e.getContext().method_51448().method_22907(class_7833.field_40718.rotationDegrees(this.cachedRotation));
            Render2D.drawTexture(e.getContext().method_51448(), -this.cachedFinalSize / 2.0f, -this.cachedFinalSize / 2.0f, this.cachedFinalSize, this.cachedFinalSize, 0.0f, phantomvisuals.id((Boolean)this.modeMarkerNew.getValue() != false ? "hud/alt_marker.png" : "hud/marker.png"), new Color(this.cachedColorRGBA, true));
        }
        e.getContext().method_51448().method_22909();
    }

    private static class OrbitTrailPoint {
        final class_243 pos;
        final long time;
        final boolean isMain;
        final Color color;

        OrbitTrailPoint(class_243 pos, long time, boolean isMain, Color color) {
            this.pos = pos;
            this.time = time;
            this.isMain = isMain;
            this.color = color;
        }
    }
}

