/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.modules.impl.render;

import dev.phantomvisuals.client.events.impl.EventRender3D;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.util.perf.Perf;
import dev.phantomvisuals.client.util.renderer.Render3D;
import dev.phantomvisuals.modules.api.Category;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.impl.NumberSetting;
import java.util.ArrayList;
import java.util.List;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1074;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.joml.Matrix4f;

public class Trails
extends Module {
    private final NumberSetting length = new NumberSetting("setting.trails.length", 20.0f, 5.0f, 200.0f, 1.0f);
    private final List<TrailPoint> points = new ArrayList<TrailPoint>();
    private static final long LIFETIME = 500L;

    public Trails() {
        super("Trails", Category.Render, class_1074.method_4662((String)"module.trails.description", (Object[])new Object[0]));
    }

    @EventHandler
    public void onRender3D(EventRender3D.Game e) {
        if (Trails.fullNullCheck() || Trails.mc.field_1690.method_31044().method_31034()) {
            this.points.clear();
            return;
        }
        try (Perf.CpuScope __ = Perf.scopeCpu("Trails.onRender3D");){
            long now = System.currentTimeMillis();
            float tickDelta = e.getTickDelta();
            double ix = class_3532.method_16436((double)tickDelta, (double)Trails.mc.field_1724.field_6014, (double)Trails.mc.field_1724.method_23317());
            double iy = class_3532.method_16436((double)tickDelta, (double)Trails.mc.field_1724.field_6036, (double)Trails.mc.field_1724.method_23318());
            double iz = class_3532.method_16436((double)tickDelta, (double)Trails.mc.field_1724.field_5969, (double)Trails.mc.field_1724.method_23321());
            this.updateTrailPoints(ix, iy, iz, now);
            if (this.points.size() < 2) {
                return;
            }
            Render3D.prepare();
            int themeRGB = ThemeManager.getInstance().getCurrentTheme().getBackgroundColor().getRGB() & 0xFFFFFF;
            double h = Trails.mc.field_1724.method_18381(Trails.mc.field_1724.method_18376());
            class_243 cam = Trails.mc.field_1773.method_19418().method_19326();
            Matrix4f matrix = e.getMatrices().method_23760().method_23761();
            for (int i = 0; i < this.points.size() - 1; ++i) {
                TrailPoint a = this.points.get(i);
                TrailPoint b = this.points.get(i + 1);
                float alphaA = (float)i / (float)this.points.size();
                float alphaB = (float)(i + 1) / (float)this.points.size();
                int colorA = (int)(alphaA * 255.0f) << 24 | themeRGB;
                int colorB = (int)(alphaB * 255.0f) << 24 | themeRGB;
                this.addVerticalQuad(matrix, a, b, h, cam, colorA, colorB);
                Render3D.drawLine(new class_243(a.x, a.y, a.z), new class_243(b.x, b.y, b.z), colorA, 1.2f);
                Render3D.drawLine(new class_243(a.x, a.y + h, a.z), new class_243(b.x, b.y + h, b.z), colorA, 1.2f);
            }
            Render3D.render();
        }
    }

    private void updateTrailPoints(double x, double y, double z, long now) {
        this.points.removeIf(p -> now - p.time > 500L);
        if (this.points.isEmpty() || this.squaredDist(x, y, z, this.points.get(this.points.size() - 1)) > 1.0E-4) {
            TrailPoint p2 = new TrailPoint();
            p2.set(x, y, z, now);
            this.points.add(p2);
        }
        while (this.points.size() > ((Float)this.length.getValue()).intValue()) {
            this.points.remove(0);
        }
    }

    private double squaredDist(double x, double y, double z, TrailPoint p) {
        double dx = x - p.x;
        double dy = y - p.y;
        double dz = z - p.z;
        return dx * dx + dy * dy + dz * dz;
    }

    private void addVerticalQuad(Matrix4f matrix, TrailPoint a, TrailPoint b, double h, class_243 cam, int colA, int colB) {
        float ax = (float)(a.x - cam.field_1352);
        float ay = (float)(a.y - cam.field_1351);
        float az = (float)(a.z - cam.field_1350);
        float bx = (float)(b.x - cam.field_1352);
        float by = (float)(b.y - cam.field_1351);
        float bz = (float)(b.z - cam.field_1350);
        float height = (float)h;
        Render3D.Vertex[] vertices = new Render3D.Vertex[]{new Render3D.Vertex(matrix, ax, ay, az, colA), new Render3D.Vertex(matrix, ax, ay + height, az, colA), new Render3D.Vertex(matrix, bx, by + height, bz, colB), new Render3D.Vertex(matrix, bx, by, bz, colB)};
        Render3D.QUADS.add(new Render3D.VertexCollection(vertices));
    }

    @Override
    public void onDisable() {
        this.points.clear();
        super.onDisable();
    }

    private static class TrailPoint {
        double x;
        double y;
        double z;
        long time;

        private TrailPoint() {
        }

        public void set(double x, double y, double z, long time) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.time = time;
        }
    }
}

