/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.modules.impl.render;

import dev.phantomvisuals.client.events.impl.EventRender3D;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.util.renderer.Render3D;
import dev.phantomvisuals.mixin.accessors.IWorldRenderer;
import dev.phantomvisuals.modules.api.Category;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import dev.phantomvisuals.modules.settings.impl.ListSetting;
import dev.phantomvisuals.modules.settings.impl.NumberSetting;
import dev.phantomvisuals.phantomvisuals;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class WorldParticles
extends Module
implements ThemeManager.ThemeChangeListener {
    private final NumberSetting particleSize = new NumberSetting("\u0420\u0430\u0437\u043c\u0435\u0440", 0.15f, 0.05f, 0.2f, 0.01f);
    private final NumberSetting maxParticles = new NumberSetting("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", 150.0f, 20.0f, 500.0f, 5.0f);
    private final NumberSetting spawnInterval = new NumberSetting("\u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u0441\u043f\u0430\u0432\u043d\u0430", 60.0f, 10.0f, 200.0f, 10.0f);
    private final float spawnRadius = 10.0f;
    private final ListSetting mode = new ListSetting("\u0420\u0435\u0436\u0438\u043c", true, new BooleanSetting("\u041f\u0440\u043e\u0441\u0442\u043e\u0439", true), new BooleanSetting("\u0412\u0437\u043b\u0435\u0442", false));
    private final BooleanSetting randomColor = new BooleanSetting("\u0420\u0430\u043d\u0434\u043e\u043c\u043d\u044b\u0439 \u0446\u0432\u0435\u0442", false);
    private final BooleanSetting glossy = new BooleanSetting("\u0413\u043b\u044f\u043d\u0446\u0435\u0432\u044b\u0435", false);
    private static final class_2960 GLOW = phantomvisuals.id("hud/glow.png");
    private final ThemeManager themeManager;
    private Color currentColor;
    private final List<Particle> particles = new ArrayList<Particle>();
    private long lastSpawnTime = 0L;

    public WorldParticles() {
        super("Snow", Category.Render, "\u041a\u0440\u0430\u0441\u0438\u0432\u044b\u0435 \u0447\u0430\u0441\u0442\u0438\u0446\u044b \u0441\u043d\u0435\u0433\u0430");
        this.themeManager = ThemeManager.getInstance();
        this.currentColor = this.themeManager.getThemeColor();
        this.themeManager.addThemeChangeListener(this);
    }

    @EventHandler
    public void onRender3D(EventRender3D.Game e) {
        if (WorldParticles.fullNullCheck()) {
            return;
        }
        long now = System.currentTimeMillis();
        if ((float)(now - this.lastSpawnTime) >= ((Float)this.spawnInterval.getValue()).floatValue()) {
            this.spawnParticle();
            this.lastSpawnTime = now;
        }
        this.particles.removeIf(p -> {
            if (now - p.spawnTime > p.lifeTime) {
                return true;
            }
            p.updateMotion(this.isVzletMode());
            return p.pos.field_1351 < -2.0;
        });
        Render3D.beginBillboardBatch(GLOW);
        for (Particle p2 : this.particles) {
            if (!this.isInFrustum(p2.pos)) continue;
            this.renderParticle(p2, e, now);
        }
        Render3D.endBillboardBatch();
    }

    private void spawnParticle() {
        class_243 vel;
        class_243 pos;
        this.ensureSpace();
        double radius = 10.0;
        if (this.isVzletMode()) {
            pos = WorldParticles.mc.field_1724.method_19538().method_1031(ThreadLocalRandom.current().nextDouble(-radius, radius), 0.2, ThreadLocalRandom.current().nextDouble(-radius, radius));
            vel = new class_243(ThreadLocalRandom.current().nextDouble(-0.01, 0.01), 0.03, ThreadLocalRandom.current().nextDouble(-0.01, 0.01));
        } else {
            pos = WorldParticles.mc.field_1724.method_19538().method_1031(ThreadLocalRandom.current().nextDouble(-radius, radius), ThreadLocalRandom.current().nextDouble(5.0, 8.0), ThreadLocalRandom.current().nextDouble(-radius, radius));
            vel = new class_243(ThreadLocalRandom.current().nextDouble(-0.01, 0.01), -0.01, ThreadLocalRandom.current().nextDouble(-0.01, 0.01));
        }
        Color themeColor = this.themeManager.getCurrentTheme().getBackgroundColor();
        Color color = (Boolean)this.randomColor.getValue() != false ? new Color(ThreadLocalRandom.current().nextInt(256), ThreadLocalRandom.current().nextInt(256), ThreadLocalRandom.current().nextInt(256)) : themeColor;
        this.particles.add(new Particle(this, pos, vel, 5000L, color));
    }

    private void ensureSpace() {
        while ((float)this.particles.size() >= ((Float)this.maxParticles.getValue()).floatValue() && !this.particles.isEmpty()) {
            this.particles.remove(0);
        }
    }

    private boolean isInFrustum(class_243 pos) {
        return ((IWorldRenderer)WorldParticles.mc.field_1769).getFrustum().method_23093(new class_238(pos.method_1031(-0.2, -0.2, -0.2), pos.method_1031(0.2, 0.2, 0.2)));
    }

    private void renderParticle(Particle p, EventRender3D.Game e, long now) {
        float baseSize = ((Float)this.particleSize.getValue()).floatValue();
        float life = p.getLifeProgress(now);
        float sizeFactor = life < 0.2f ? life / 0.2f : (life > 0.8f ? (1.0f - life) / 0.2f : 1.0f);
        float heightFactor = 1.0f;
        if (!this.isVzletMode() && p.pos.field_1351 < 1.5) {
            heightFactor = (float)(p.pos.field_1351 / 1.5);
        }
        float lightFactor = WorldParticles.mc.field_1687 != null && WorldParticles.mc.field_1724 != null ? Math.max(0.5f, 1.0f - WorldParticles.mc.field_1687.method_22349(WorldParticles.mc.field_1724.method_24515())) : 1.0f;
        float size = baseSize * sizeFactor * heightFactor;
        int alpha = Math.max(0, Math.min(255, (int)(255.0f * sizeFactor * heightFactor * lightFactor)));
        Color glowColor = new Color(p.color.getRed(), p.color.getGreen(), p.color.getBlue(), alpha);
        int rgbaMain = new Color(glowColor.getRed(), glowColor.getGreen(), glowColor.getBlue(), alpha).getRGB();
        if (((Boolean)this.glossy.getValue()).booleanValue()) {
            Render3D.batchBillboard(e.getMatrices(), p.pos, size * 2.5f, rgbaMain);
            Render3D.batchBillboard(e.getMatrices(), p.pos, size * 1.5f, rgbaMain);
        } else {
            int softAlpha = Math.max(0, Math.min(255, (int)((float)alpha * 0.65f)));
            int rgbaSoft = new Color(glowColor.getRed(), glowColor.getGreen(), glowColor.getBlue(), softAlpha).getRGB();
            Render3D.batchBillboard(e.getMatrices(), p.pos, size * 2.2f, rgbaSoft);
            Render3D.batchBillboard(e.getMatrices(), p.pos, size * 1.2f, glowColor.getRGB());
            int whiteAlpha = Math.min(255, alpha + 50);
            int rgbaWhite = new Color(255, 255, 255, whiteAlpha).getRGB();
            Render3D.batchBillboard(e.getMatrices(), p.pos, size * 0.5f, rgbaWhite);
        }
    }

    private boolean isVzletMode() {
        BooleanSetting vzlet = this.mode.getName("\u0412\u0437\u043b\u0435\u0442");
        return vzlet != null && (Boolean)vzlet.getValue() != false;
    }

    @Override
    public void onThemeChanged(ThemeManager.Theme theme) {
        this.currentColor = theme.getBackgroundColor();
        for (Particle p : this.particles) {
            p.color = this.currentColor;
        }
    }

    @Override
    public void onDisable() {
        this.particles.clear();
        this.themeManager.removeThemeChangeListener(this);
        super.onDisable();
    }

    private class Particle {
        class_243 pos;
        class_243 vel;
        long spawnTime;
        long lifeTime;
        Color color;

        Particle(WorldParticles worldParticles, class_243 pos, class_243 vel, long lifeTime, Color color) {
            this.pos = pos;
            this.vel = vel;
            this.spawnTime = System.currentTimeMillis();
            this.lifeTime = lifeTime;
            this.color = color;
        }

        void updateMotion(boolean vzlet) {
            double motionRandom = 0.002;
            this.vel = this.vel.method_1031((ThreadLocalRandom.current().nextDouble() - 0.5) * motionRandom, (ThreadLocalRandom.current().nextDouble() - 0.5) * motionRandom * 0.5, (ThreadLocalRandom.current().nextDouble() - 0.5) * motionRandom);
            this.vel = vzlet ? new class_243(this.vel.field_1352, 0.03, this.vel.field_1350) : new class_243(this.vel.field_1352, -0.005 + Math.sin((double)(System.currentTimeMillis() - this.spawnTime) / 500.0) * 0.002, this.vel.field_1350);
            this.pos = this.pos.method_1019(this.vel);
        }

        float getLifeProgress(long now) {
            return (float)(now - this.spawnTime) / (float)this.lifeTime;
        }
    }
}

