/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.modules.impl.render;

import dev.phantomvisuals.modules.api.Category;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import dev.phantomvisuals.modules.settings.impl.NumberSetting;
import lombok.Generated;
import net.minecraft.class_1074;

public class Zoom
extends Module {
    private final NumberSetting zoomStrength = new NumberSetting("setting.zoomStrength", 3.0f, 1.0f, 15.0f, 0.1f);
    private final BooleanSetting smoothZoom = new BooleanSetting("setting.smoothZoom", true);
    private final NumberSetting smoothSpeed = new NumberSetting("setting.smoothSpeed", 10.0f, 1.0f, 15.0f, 1.0f, () -> (Boolean)this.smoothZoom.getValue());
    private float currentFov = -1.0f;
    private float originalFov = -1.0f;

    public Zoom() {
        super("Zoom", Category.Render, class_1074.method_4662((String)"module.zoom.description", (Object[])new Object[0]));
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.currentFov = -1.0f;
        this.originalFov = -1.0f;
    }

    @Override
    public void onDisable() {
        super.onDisable();
    }

    public float applyZoom(float baseFov, float tickDelta) {
        float alpha;
        float targetFov;
        if (this.originalFov < 0.0f) {
            this.originalFov = baseFov;
        }
        boolean active = this.isToggled();
        float strength = Math.max(1.0f, ((Float)this.zoomStrength.getValue()).floatValue());
        float f = targetFov = active ? this.originalFov / strength : this.originalFov;
        if (!((Boolean)this.smoothZoom.getValue()).booleanValue()) {
            this.currentFov = targetFov;
            if (!active && Math.abs(this.currentFov - this.originalFov) <= 1.0E-4f) {
                this.currentFov = -1.0f;
                this.originalFov = -1.0f;
                return baseFov;
            }
            return this.currentFov;
        }
        if (this.currentFov < 0.0f) {
            this.currentFov = baseFov;
        }
        float speedPerSecond = ((Float)this.smoothSpeed.getValue()).floatValue();
        float dtSeconds = tickDelta / 20.0f;
        if (dtSeconds < 0.0f) {
            dtSeconds = 0.0f;
        }
        if ((alpha = 1.0f - (float)Math.exp(-speedPerSecond * dtSeconds)) > 1.0f) {
            alpha = 1.0f;
        }
        this.currentFov += (targetFov - this.currentFov) * alpha;
        float epsilon = 5.0E-4f;
        if (Math.abs(targetFov - this.currentFov) <= epsilon) {
            this.currentFov = targetFov;
        }
        if (!active && this.currentFov == this.originalFov) {
            this.currentFov = -1.0f;
            this.originalFov = -1.0f;
            return baseFov;
        }
        return this.currentFov;
    }

    @Generated
    public NumberSetting getZoomStrength() {
        return this.zoomStrength;
    }

    @Generated
    public BooleanSetting getSmoothZoom() {
        return this.smoothZoom;
    }

    @Generated
    public NumberSetting getSmoothSpeed() {
        return this.smoothSpeed;
    }
}

