/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.modules.impl.utility;

import dev.phantomvisuals.client.ChatUtils;
import dev.phantomvisuals.client.events.impl.EventAttackEntity;
import dev.phantomvisuals.client.events.impl.EventMouse;
import dev.phantomvisuals.client.managers.FriendsManager;
import dev.phantomvisuals.modules.api.Category;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.api.Bind;
import dev.phantomvisuals.modules.settings.impl.BindSetting;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import java.util.Arrays;
import java.util.List;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_3966;

public class FriendHelper
extends Module {
    private final List<String> allowedServers = Arrays.asList("localhost");
    private final BindSetting friendKey = new BindSetting("setting.friendKey", new Bind(2, true));
    private final BooleanSetting noFriendDamage = new BooleanSetting("setting.noFriendDamage", true);

    public FriendHelper() {
        super("FriendHelper", Category.Utility, class_1074.method_4662((String)"module.friendhelper.description", (Object[])new Object[0]));
        this.getSettings().add(this.friendKey);
        this.getSettings().add(this.noFriendDamage);
    }

    @Override
    public boolean isVisible() {
        return this.isAllowedServer();
    }

    private boolean isAllowedServer() {
        if (mc.method_1558() == null) {
            return false;
        }
        String ip = FriendHelper.mc.method_1558().field_3761.toLowerCase();
        return this.allowedServers.stream().anyMatch(ip::contains);
    }

    public BooleanSetting getNoFriendDamage() {
        return this.noFriendDamage;
    }

    @EventHandler
    public void onAttack(EventAttackEntity e) {
        if (!this.isAllowedServer()) {
            if (this.isToggled()) {
                this.setToggled(false);
            }
            return;
        }
        if (!this.isToggled() || !((Boolean)this.noFriendDamage.getValue()).booleanValue()) {
            return;
        }
        class_1297 target = e.getTarget();
        if (target instanceof class_1657) {
            String nameAlt;
            class_1657 player = (class_1657)target;
            String namePrimary = player.method_7334().getName();
            String string = nameAlt = player.method_5477() != null ? player.method_5477().getString() : namePrimary;
            if (FriendsManager.checkFriend(namePrimary) || FriendsManager.checkFriend(nameAlt)) {
                e.cancel();
            }
        }
    }

    @EventHandler
    public void onMouse(EventMouse event) {
        if (!this.isToggled() || !this.isAllowedServer()) {
            return;
        }
        if (event.getAction() == 1 && ((Bind)this.friendKey.getValue()).isMouse() && ((Bind)this.friendKey.getValue()).getKey() == event.getButton()) {
            this.handleFriendAction();
        }
    }

    private void handleFriendAction() {
        if (FriendHelper.mc.field_1765 == null || FriendHelper.mc.field_1765.method_17783() != class_239.class_240.field_1331) {
            return;
        }
        class_3966 ehr = (class_3966)FriendHelper.mc.field_1765;
        class_1297 class_12972 = ehr.method_17782();
        if (!(class_12972 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_12972;
        String playerName = player.method_5477().getString();
        if (FriendsManager.checkFriend(playerName)) {
            FriendsManager.removeFriend(playerName);
            ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"friend.removed", (Object[])new Object[0]), playerName));
        } else {
            FriendsManager.addFriend(playerName);
            ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"friend.added", (Object[])new Object[0]), playerName));
        }
    }
}

