/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.modules.settings;

import dev.phantomvisuals.client.events.impl.EventSettingChange;
import dev.phantomvisuals.client.managers.AutoSaveManager;
import dev.phantomvisuals.phantomvisuals;
import java.util.function.Supplier;
import lombok.Generated;

public abstract class Setting<Value> {
    private final String name;
    protected Value value;
    protected Value defaultValue;
    private Supplier<Boolean> visible = () -> true;

    public Setting(String name, Value defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    public Setting(String name, Value defaultValue, Supplier<Boolean> visible) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.visible = visible;
    }

    public void setValue(Value value) {
        EventSettingChange event = new EventSettingChange(this);
        phantomvisuals.getInstance().getEventHandler().post(event);
        if (!event.isCancelled()) {
            this.value = value;
            try {
                AutoSaveManager asm = phantomvisuals.getInstance().getAutoSaveManager();
                if (asm != null) {
                    asm.scheduleAutoSave();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void reset() {
        this.value = this.defaultValue;
    }

    public boolean isVisible() {
        return this.visible.get();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Value getValue() {
        return this.value;
    }

    @Generated
    public Value getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public Supplier<Boolean> getVisible() {
        return this.visible;
    }

    @Generated
    public void setDefaultValue(Value defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setVisible(Supplier<Boolean> visible) {
        this.visible = visible;
    }
}

