/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.modules.settings.impl;

import dev.phantomvisuals.modules.settings.Setting;
import java.awt.Color;
import java.util.function.Supplier;

public class ColorSetting
extends Setting<Integer> {
    private float[] hsb = new float[3];
    private boolean rainbow = false;
    private float rainbowSpeed = 1.0f;
    private int alpha = 255;
    private Integer cachedValue;
    private Runnable onAction;
    private Runnable onSetVisible;

    public ColorSetting(String name, Integer color) {
        super(name, color);
        this.updateHSB(color);
        this.cachedValue = color;
    }

    public ColorSetting(String name, Color color) {
        this(name, color.getRGB());
    }

    @Override
    public Integer getValue() {
        if (this.rainbow) {
            float timeOffset = (float)(System.currentTimeMillis() % (long)(10000.0f / this.rainbowSpeed)) / (10000.0f / this.rainbowSpeed);
            int rainbowColor = Color.HSBtoRGB(timeOffset, this.hsb[1], this.hsb[2]);
            return rainbowColor & 0xFFFFFF | this.alpha << 24;
        }
        if (this.cachedValue == null) {
            this.cachedValue = (Integer)super.getValue();
        }
        return this.cachedValue;
    }

    public ColorSetting set(Integer value) {
        super.setValue(value);
        this.cachedValue = value;
        this.updateHSB(value);
        if (this.onAction != null) {
            this.onAction.run();
        }
        return this;
    }

    public ColorSetting setRainbow(boolean rainbow) {
        this.rainbow = rainbow;
        return this;
    }

    public boolean isRainbow() {
        return this.rainbow;
    }

    public ColorSetting setRainbowSpeed(float speed) {
        this.rainbowSpeed = speed;
        return this;
    }

    public void setHSB(float hue, float saturation, float brightness) {
        this.hsb[0] = hue;
        this.hsb[1] = saturation;
        this.hsb[2] = brightness;
        int rgb = Color.HSBtoRGB(hue, saturation, brightness);
        int finalColor = rgb & 0xFFFFFF | this.alpha << 24;
        super.setValue(finalColor);
        this.cachedValue = finalColor;
    }

    private void updateHSB(int rgb) {
        Color c = new Color(rgb, true);
        Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), this.hsb);
        this.alpha = c.getAlpha();
    }

    @Override
    public void setVisible(Supplier<Boolean> visible) {
        super.setVisible(visible);
        if (this.onSetVisible != null) {
            this.onSetVisible.run();
        }
    }

    public ColorSetting onAction(Runnable action) {
        this.onAction = action;
        return this;
    }

    public ColorSetting onSetVisible(Runnable action) {
        this.onSetVisible = action;
        return this;
    }

    public Color getColor() {
        return new Color(this.getValue(), true);
    }

    public void setColor(Color color) {
        this.set(color.getRGB());
    }
}

