/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.util;

import dev.firstdark.rpc.DiscordRpc;
import dev.firstdark.rpc.enums.ActivityType;
import dev.firstdark.rpc.enums.ErrorCode;
import dev.firstdark.rpc.handlers.RPCEventHandler;
import dev.firstdark.rpc.models.DiscordRichPresence;
import dev.firstdark.rpc.models.User;

public class DiscordRichPresenceUtil {
    private static final String DEFAULT_APP_ID = "1455185228669915237";
    private static volatile boolean running = false;
    private static Thread rpcThread;
    private static DiscordRpc rpc;
    public static String state;

    public static synchronized void discordrpc() {
        DiscordRichPresenceUtil.startDiscord(null);
    }

    public static synchronized void startDiscord(String applicationId) {
        if (running) {
            return;
        }
        String appId = applicationId;
        if (appId == null || appId.isEmpty()) {
            appId = System.getProperty("discord.app.id", System.getenv("DISCORD_APP_ID"));
        }
        if (appId == null || appId.isEmpty()) {
            appId = DEFAULT_APP_ID;
        }
        rpc = new DiscordRpc();
        rpc.setDebugMode(false);
        RPCEventHandler handler = new RPCEventHandler(){

            @Override
            public void ready(User user) {
                running = true;
                DiscordRichPresenceUtil.pushPresence();
            }

            @Override
            public void disconnected(ErrorCode errorCode, String message) {
                running = false;
            }

            @Override
            public void errored(ErrorCode errorCode, String message) {
            }
        };
        try {
            rpc.init(appId, handler, false);
        }
        catch (Throwable t) {
            return;
        }
        rpcThread = new Thread(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (running) {
                        DiscordRichPresenceUtil.pushPresence();
                    }
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Throwable throwable) {
                }
            }
        }, "Discord-RPC-FirstDark-Thread");
        rpcThread.setDaemon(true);
        rpcThread.start();
    }

    public static synchronized void shutdownDiscord() {
        running = false;
        if (rpcThread != null) {
            rpcThread.interrupt();
            rpcThread = null;
        }
        try {
            if (rpc != null) {
                rpc.shutdown();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        rpc = null;
    }

    private static void pushPresence() {
        if (rpc == null) {
            return;
        }
        DiscordRichPresence presence = DiscordRichPresence.builder().details(state != null && !state.isEmpty() ? state : "https://t.me/phantomvisual").largeImageText("https://t.me/phantomvisual").smallImageText("Playing").activityType(ActivityType.PLAYING).button(DiscordRichPresence.RPCButton.of("\u0421\u043a\u0430\u0447\u0430\u0442\u044c", "https://t.me/phantomvisual")).build();
        try {
            rpc.updatePresence(presence);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

