/*
 * Decompiled with CFR 0.152.
 */
package dev.redstones.mediaplayerinfo.impl.linux;

import dev.redstones.mediaplayerinfo.IMediaSession;
import dev.redstones.mediaplayerinfo.MediaInfo;
import dev.redstones.mediaplayerinfo.impl.linux.LinuxMediaPlayerInfo;
import dev.redstones.mediaplayerinfo.impl.linux.dbus.Player;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import org.freedesktop.dbus.DBusMap;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Ldev/redstones/mediaplayerinfo/impl/linux/LinuxMediaSession;", "Ldev/redstones/mediaplayerinfo/IMediaSession;", "dbus", "Ldev/redstones/mediaplayerinfo/impl/linux/dbus/Player;", "owner", "", "(Ldev/redstones/mediaplayerinfo/impl/linux/dbus/Player;Ljava/lang/String;)V", "media", "Ldev/redstones/mediaplayerinfo/MediaInfo;", "getMedia", "()Ldev/redstones/mediaplayerinfo/MediaInfo;", "getOwner", "()Ljava/lang/String;", "generateMediaInfo", "next", "", "pause", "play", "playPause", "previous", "stop", "MediaPlayerInfo"})
public final class LinuxMediaSession
implements IMediaSession {
    @NotNull
    private final Player dbus;
    @NotNull
    private final String owner;
    @NotNull
    private final MediaInfo media;

    public LinuxMediaSession(@NotNull Player dbus, @NotNull String owner) {
        Intrinsics.checkNotNullParameter(dbus, "dbus");
        Intrinsics.checkNotNullParameter(owner, "owner");
        this.dbus = dbus;
        this.owner = owner;
        this.media = this.generateMediaInfo();
    }

    @Override
    @NotNull
    public String getOwner() {
        return this.owner;
    }

    @Override
    @NotNull
    public MediaInfo getMedia() {
        return this.media;
    }

    @Override
    public void play() {
        this.dbus.Play();
    }

    @Override
    public void pause() {
        this.dbus.Pause();
    }

    @Override
    public void playPause() {
        this.dbus.PlayPause();
    }

    @Override
    public void stop() {
        this.dbus.Stop();
    }

    @Override
    public void next() {
        this.dbus.Next();
    }

    @Override
    public void previous() {
        this.dbus.Previous();
    }

    private final MediaInfo generateMediaInfo() {
        String string;
        DBusMap metadata = (DBusMap)LinuxMediaPlayerInfo.INSTANCE.getProperty$MediaPlayerInfo(this.getOwner(), "Metadata");
        boolean playing = Intrinsics.areEqual(LinuxMediaPlayerInfo.INSTANCE.getProperty$MediaPlayerInfo(this.getOwner(), "PlaybackStatus"), "Playing");
        long position = (long)((Number)LinuxMediaPlayerInfo.INSTANCE.getProperty$MediaPlayerInfo(this.getOwner(), "Position")).doubleValue() / (long)1000000;
        Object v = metadata.get("mpris:length");
        Intrinsics.checkNotNull(v);
        long duration = Long.parseLong(v.toString()) / (long)1000000;
        Object v2 = metadata.get("xesam:title");
        Intrinsics.checkNotNull(v2, "null cannot be cast to non-null type kotlin.String");
        String title = (String)v2;
        Object $this$generateMediaInfo_u24lambda_u240 = metadata.get("xesam:artist");
        boolean bl = false;
        if ($this$generateMediaInfo_u24lambda_u240 instanceof String) {
            string = (String)$this$generateMediaInfo_u24lambda_u240;
        } else {
            Intrinsics.checkNotNull($this$generateMediaInfo_u24lambda_u240, "null cannot be cast to non-null type kotlin.collections.List<*>");
            string = CollectionsKt.joinToString$default((List)$this$generateMediaInfo_u24lambda_u240, ", ", null, null, 0, null, null, 62, null);
        }
        String artist = string;
        Object artworkUrl = metadata.get("mpris:artUrl");
        byte[] artwork = artworkUrl instanceof String ? TextStreamsKt.readBytes(new URL((String)artworkUrl)) : new byte[]{};
        return new MediaInfo(title, artist, artwork, position, duration, playing);
    }
}

