/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.silentchaos512.lib.command.internal.TeleportCommand;
import net.silentchaos512.lib.component.LootContainer;
import net.silentchaos512.lib.world.placement.DimensionFilterPlacement;
import org.slf4j.Logger;

@Mod(value="silentlib")
public final class SilentLib {
    public static final String MOD_ID = "silentlib";
    public static final Logger LOGGER = LogUtils.getLogger();
    static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES_REGISTRAR = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"silentlib");
    static final DeferredRegister<PlacementModifierType<?>> PLACEMENT_MODIFIER_TYPE_REGISTRAR = DeferredRegister.create((ResourceKey)Registries.PLACEMENT_MODIFIER_TYPE, (String)"silentlib");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<LootContainer>> LOOT_CONTAINER = DATA_COMPONENT_TYPES_REGISTRAR.register("loot_container", () -> DataComponentType.builder().persistent(LootContainer.CODEC).networkSynchronized(LootContainer.STREAM_CODEC).build());
    public static final DeferredHolder<PlacementModifierType<?>, PlacementModifierType<DimensionFilterPlacement>> DIMENSION_FILTER_PLACEMENT = PLACEMENT_MODIFIER_TYPE_REGISTRAR.register("dimension_filter", () -> () -> DimensionFilterPlacement.CODEC);

    public SilentLib(IEventBus modEventBus) {
        DATA_COMPONENT_TYPES_REGISTRAR.register(modEventBus);
        PLACEMENT_MODIFIER_TYPE_REGISTRAR.register(modEventBus);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
    }

    private void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        TeleportCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    public static String getVersion() {
        Optional o = ModList.get().getModContainerById(MOD_ID);
        if (o.isPresent()) {
            return ((ModContainer)o.get()).getModInfo().getVersion().toString();
        }
        return "0.0.0";
    }

    public static boolean isDevBuild() {
        return "NONE".equals(SilentLib.getVersion());
    }

    public static Identifier getId(String path) {
        return Identifier.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

