/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.client.gui;

import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.silentchaos512.lib.util.Anchor;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;

public abstract class DebugRenderOverlay {
    protected static final String SPLITTER = "=";
    private static final int DEFAULT_UPDATE_FREQUENCY = 10;
    private static final int DEFAULT_SPLIT_WIDTH = 100;
    private static final int LINE_HEIGHT = 10;
    private List<String> debugText = new ArrayList<String>();
    private int textWidth;
    private int textHeight;
    @Deprecated
    private int startX = 3;
    @Deprecated
    private int startY = 3;
    private int ticksPassed = 0;

    protected DebugRenderOverlay() {
        NeoForge.EVENT_BUS.addListener(this::renderTick);
        NeoForge.EVENT_BUS.addListener(this::clientTick);
    }

    @Deprecated
    protected DebugRenderOverlay(int startX, int startY) {
        this();
        this.startX = startX;
        this.startY = startY;
    }

    @Nonnull
    public abstract List<String> getDebugText();

    public abstract float getTextScale();

    public Anchor getAnchorPoint() {
        return Anchor.TOP_LEFT;
    }

    public int getMarginSize() {
        return 3;
    }

    @Nonnegative
    public int getUpdateFrequency() {
        return 10;
    }

    @Nonnegative
    public int getSplitWidth() {
        return 100;
    }

    public abstract boolean isHidden();

    protected void drawLine(GuiGraphics graphics, Font font, String line, int x, int y, int color) {
        String[] array = line.split(SPLITTER);
        if (array.length == 2) {
            graphics.drawString(font, array[0].trim(), x, y, color);
            graphics.drawString(font, array[1].trim(), x + this.getSplitWidth(), y, color);
        } else {
            graphics.drawString(font, line, x, y, color);
        }
    }

    @Deprecated
    public int getStartX() {
        return this.startX;
    }

    @Deprecated
    public int getStartY() {
        return this.startY;
    }

    public void renderTick(RenderGuiLayerEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (this.isHidden() || this.debugText.isEmpty() || mc.isPaused() || event.getName() != VanillaGuiLayers.CHAT) {
            return;
        }
        float scale = this.getTextScale();
        if (scale <= 0.0f) {
            return;
        }
        Font font = mc.font;
        Matrix3x2fStack matrix = event.getGuiGraphics().pose();
        matrix.pushMatrix();
        matrix.scale(scale, scale, (Matrix3x2f)matrix);
        Window mainWindow = mc.getWindow();
        int x = (int)((float)this.getAnchorPoint().getX(mainWindow.getGuiScaledWidth(), this.textWidth, this.getMarginSize()) / this.getTextScale());
        int y = (int)((float)this.getAnchorPoint().getY(mainWindow.getGuiScaledHeight(), this.textHeight, this.getMarginSize()) / this.getTextScale());
        for (String line : this.debugText) {
            this.drawLine(event.getGuiGraphics(), font, line, x, y, 0xFFFFFF);
            y += 10;
        }
        matrix.popMatrix();
    }

    public void clientTick(ClientTickEvent.Pre event) {
        if (this.getUpdateFrequency() == 0 || ++this.ticksPassed % this.getUpdateFrequency() == 0) {
            this.debugText = this.getDebugText();
            Font font = Minecraft.getInstance().font;
            this.textWidth = 0;
            this.textHeight = 10 * this.debugText.size();
            for (String line : this.debugText) {
                String[] array = line.split(SPLITTER);
                if (array.length == 2) {
                    int width = this.getSplitWidth() + font.width(array[1]);
                    this.textWidth = Math.max(this.textWidth, width);
                    continue;
                }
                this.textWidth = Math.max(this.textWidth, font.width(line));
            }
        }
    }
}

