/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.command.internal;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.permissions.PermissionCheck;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.silentchaos512.lib.util.TeleportUtils;

public final class TeleportCommand {
    private TeleportCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sl_tp").requires((Predicate)Commands.hasPermission((PermissionCheck)Commands.LEVEL_GAMEMASTERS))).then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(TeleportCommand::run)))));
    }

    private static int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos target = BlockPosArgument.getLoadedBlockPos(context, (String)"pos");
        ServerLevel level = DimensionArgument.getDimension(context, (String)"dimension");
        for (Entity entity : EntityArgument.getEntities(context, (String)"entity")) {
            if (entity instanceof Player) {
                TeleportUtils.teleport((Player)entity, (ResourceKey<Level>)level.dimension(), target.getX(), target.getY(), target.getZ(), null);
            }
            TeleportUtils.teleportEntity(entity, (Level)level, target.getX(), target.getY(), target.getZ(), null);
        }
        return 1;
    }
}

