/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.crafting.recipe;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function5;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.Level;
import net.silentchaos512.lib.crafting.recipe.CraftingRecipeExtension;

public abstract class ExtendedShapedRecipe
implements CraftingRecipeExtension {
    protected final ShapedRecipePattern pattern;
    protected final ItemStack result;
    protected final String group;
    protected final CraftingBookCategory category;
    protected final boolean showNotification;
    @Nullable
    private PlacementInfo placementInfo;

    public ExtendedShapedRecipe(String pGroup, CraftingBookCategory pCategory, ShapedRecipePattern pPattern, ItemStack pResult, boolean pShowNotification) {
        this.group = pGroup;
        this.category = pCategory;
        this.pattern = pPattern;
        this.result = pResult;
        this.showNotification = pShowNotification;
    }

    public ExtendedShapedRecipe(String pGroup, CraftingBookCategory pCategory, ShapedRecipePattern pPattern, ItemStack pResult) {
        this(pGroup, pCategory, pPattern, pResult, true);
    }

    public abstract RecipeSerializer<? extends ExtendedShapedRecipe> getSerializer();

    public String group() {
        return this.group;
    }

    public CraftingBookCategory category() {
        return this.category;
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals((List)this.pattern.ingredients());
        }
        return this.placementInfo;
    }

    public boolean showNotification() {
        return this.showNotification;
    }

    public boolean matches(CraftingInput pInv, Level pLevel) {
        return this.pattern.matches(pInv);
    }

    public ItemStack assemble(CraftingInput pContainer, HolderLookup.Provider pRegistries) {
        return this.result.copy();
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    public List<RecipeDisplay> display() {
        return List.of(new ShapedCraftingRecipeDisplay(this.pattern.width(), this.pattern.height(), this.pattern.ingredients().stream().map(optionalIngredient -> optionalIngredient.map(Ingredient::display).orElse((SlotDisplay)SlotDisplay.Empty.INSTANCE)).toList(), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.result), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.CRAFTING_TABLE)));
    }

    @Override
    public ItemStack getResultForDisplay() {
        return this.result.copy();
    }

    @Override
    public List<Ingredient> getIngredientsForDisplay() {
        return this.placementInfo().ingredients();
    }

    protected static <R extends ExtendedShapedRecipe> Products.P5<RecordCodecBuilder.Mu<R>, String, CraftingBookCategory, ShapedRecipePattern, ItemStack, Boolean> basicCodecFields(RecordCodecBuilder.Instance<R> builder) {
        return builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(r -> r.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(r -> r.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(r -> r.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(r -> r.showNotification));
    }

    public static class BasicSerializer<R extends ExtendedShapedRecipe>
    implements RecipeSerializer<R> {
        private final MapCodec<R> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, R> streamCodec;
        private final Function5<String, CraftingBookCategory, ShapedRecipePattern, ItemStack, Boolean, R> factory;

        public BasicSerializer(Function5<String, CraftingBookCategory, ShapedRecipePattern, ItemStack, Boolean, R> factory) {
            this.factory = factory;
            this.codec = RecordCodecBuilder.mapCodec(builder -> ExtendedShapedRecipe.basicCodecFields(builder).apply((Applicative)builder, this.factory));
            this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
        }

        public MapCodec<R> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, R> streamCodec() {
            return this.streamCodec;
        }

        public R fromNetwork(RegistryFriendlyByteBuf buf) {
            String group = buf.readUtf();
            CraftingBookCategory category = (CraftingBookCategory)buf.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buf);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            boolean showNotification = buf.readBoolean();
            return (R)((ExtendedShapedRecipe)this.factory.apply((Object)group, (Object)category, (Object)pattern, (Object)result, (Object)showNotification));
        }

        public void toNetwork(RegistryFriendlyByteBuf buf, R recipe) {
            buf.writeUtf(((ExtendedShapedRecipe)recipe).group);
            buf.writeEnum((Enum)((ExtendedShapedRecipe)recipe).category);
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buf, (Object)((ExtendedShapedRecipe)recipe).pattern);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)((ExtendedShapedRecipe)recipe).result);
            buf.writeBoolean(((ExtendedShapedRecipe)recipe).showNotification);
        }
    }
}

