/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.crafting.recipe;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.silentchaos512.lib.crafting.recipe.CraftingRecipeExtension;

public abstract class ExtendedShapelessRecipe
implements CraftingRecipeExtension {
    protected final String group;
    protected final CraftingBookCategory category;
    protected final ItemStack result;
    protected final List<Ingredient> ingredients;
    @Nullable
    private PlacementInfo placementInfo;
    protected final boolean isSimple;

    public ExtendedShapelessRecipe(String group, CraftingBookCategory category, ItemStack result, List<Ingredient> ingredient) {
        this.group = group;
        this.category = category;
        this.result = result;
        this.ingredients = ingredient;
        this.isSimple = ingredient.stream().allMatch(Ingredient::isSimple);
    }

    public abstract RecipeSerializer<? extends ExtendedShapelessRecipe> getSerializer();

    public String group() {
        return this.group;
    }

    public CraftingBookCategory category() {
        return this.category;
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create(this.ingredients);
        }
        return this.placementInfo;
    }

    public boolean matches(CraftingInput input, Level level) {
        if (input.ingredientCount() != this.ingredients.size()) {
            return false;
        }
        if (!this.isSimple) {
            ArrayList<ItemStack> nonEmptyItems = new ArrayList<ItemStack>(input.ingredientCount());
            for (ItemStack item : input.items()) {
                if (item.isEmpty()) continue;
                nonEmptyItems.add(item);
            }
            return RecipeMatcher.findMatches(nonEmptyItems, this.ingredients) != null;
        }
        return input.size() == 1 && this.ingredients.size() == 1 ? this.ingredients.getFirst().test(input.getItem(0)) : input.stackedContents().canCraft((Recipe)this, null);
    }

    public ItemStack assemble(CraftingInput pContainer, HolderLookup.Provider pRegistries) {
        return this.result.copy();
    }

    public List<RecipeDisplay> display() {
        return List.of(new ShapelessCraftingRecipeDisplay(this.ingredients.stream().map(Ingredient::display).toList(), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.result), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.CRAFTING_TABLE)));
    }

    @Override
    public ItemStack getResultForDisplay() {
        return this.result.copy();
    }

    @Override
    public List<Ingredient> getIngredientsForDisplay() {
        return this.ingredients;
    }

    protected static <T extends ExtendedShapelessRecipe> Products.P4<RecordCodecBuilder.Mu<T>, String, CraftingBookCategory, ItemStack, List<Ingredient>> commonCodecFields(RecordCodecBuilder.Instance<T> pInstance) {
        return pInstance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(r -> r.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(r -> r.category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.lazyInitialized(() -> Ingredient.CODEC.listOf(1, ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth())).fieldOf("ingredients").forGetter(r -> r.ingredients));
    }

    public static class BasicSerializer<R extends ExtendedShapelessRecipe>
    implements RecipeSerializer<R> {
        private final MapCodec<R> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, R> streamCodec;
        private final Function4<String, CraftingBookCategory, ItemStack, List<Ingredient>, R> factory;

        public BasicSerializer(Function4<String, CraftingBookCategory, ItemStack, List<Ingredient>, R> factory) {
            this.factory = factory;
            this.codec = RecordCodecBuilder.mapCodec(builder -> ExtendedShapelessRecipe.commonCodecFields(builder).apply((Applicative)builder, this.factory));
            this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
        }

        public MapCodec<R> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, R> streamCodec() {
            return this.streamCodec;
        }

        public R fromNetwork(RegistryFriendlyByteBuf buf) {
            String group = buf.readUtf();
            CraftingBookCategory category = (CraftingBookCategory)buf.readEnum(CraftingBookCategory.class);
            int ingredientCount = buf.readVarInt();
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            for (int i = 0; i < ingredientCount; ++i) {
                ingredients.add((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
            }
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            return (R)((ExtendedShapelessRecipe)this.factory.apply((Object)group, (Object)category, (Object)result, ingredients));
        }

        public void toNetwork(RegistryFriendlyByteBuf buf, R recipe) {
            buf.writeUtf(((ExtendedShapelessRecipe)recipe).group);
            buf.writeEnum((Enum)((ExtendedShapelessRecipe)recipe).category);
            buf.writeVarInt(((ExtendedShapelessRecipe)recipe).ingredients.size());
            for (Ingredient ingredient : ((ExtendedShapelessRecipe)recipe).ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)((ExtendedShapelessRecipe)recipe).result);
        }
    }
}

