/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.data.client;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.blockstates.BlockModelDefinitionGenerator;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public abstract class LibModelProvider
implements DataProvider {
    private final PackOutput.PathProvider blockStatePathProvider;
    private final PackOutput.PathProvider itemInfoPathProvider;
    private final PackOutput.PathProvider modelPathProvider;
    private final String modId;
    private final boolean autogenBlockItemInfos;

    public LibModelProvider(PackOutput output, String modId, boolean autogenBlockItemInfos) {
        this.blockStatePathProvider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        this.itemInfoPathProvider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "items");
        this.modelPathProvider = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
        this.modId = modId;
        this.autogenBlockItemInfos = autogenBlockItemInfos;
    }

    public LibModelProvider(PackOutput output, String modId) {
        this(output, modId, true);
    }

    @Nullable
    protected abstract BlockModelGenerators createBlockModelGenerators(Consumer<BlockModelDefinitionGenerator> var1, ItemModelOutput var2, BiConsumer<Identifier, ModelInstance> var3);

    @Nullable
    protected abstract ItemModelGenerators createItemModelGenerators(ItemModelOutput var1, BiConsumer<Identifier, ModelInstance> var2);

    public CompletableFuture<?> run(CachedOutput output) {
        ItemInfoCollector itemInfoCollector = new ItemInfoCollector();
        BlockStateGeneratorCollector blockStateGeneratorCollector = new BlockStateGeneratorCollector();
        SimpleModelCollector simpleModelCollector = new SimpleModelCollector();
        BlockModelGenerators blockModelGenerators = this.createBlockModelGenerators(blockStateGeneratorCollector, itemInfoCollector, simpleModelCollector);
        ItemModelGenerators itemModelGenerators = this.createItemModelGenerators(itemInfoCollector, simpleModelCollector);
        if (blockModelGenerators != null) {
            blockModelGenerators.run();
        }
        if (itemModelGenerators != null) {
            itemModelGenerators.run();
        }
        itemInfoCollector.finalizeAndValidate();
        return CompletableFuture.allOf(blockStateGeneratorCollector.save(output, this.blockStatePathProvider), simpleModelCollector.save(output, this.modelPathProvider), itemInfoCollector.save(output, this.itemInfoPathProvider));
    }

    static <T> CompletableFuture<?> saveAll(CachedOutput output, Function<T, Path> p_386455_, Map<T, ? extends Supplier<JsonElement>> generators) {
        return DataProvider.saveAll((CachedOutput)output, Supplier::get, p_386455_, generators);
    }

    public final String getName() {
        return "Model Definitions";
    }

    private boolean isModded(Holder.Reference<?> reference) {
        return reference.key().identifier().getNamespace().equals(this.modId);
    }

    class ItemInfoCollector
    implements ItemModelOutput {
        private final Map<Item, ClientItem> itemInfos = new HashMap<Item, ClientItem>();
        private final Map<Item, Item> copies = new HashMap<Item, Item>();

        ItemInfoCollector() {
        }

        public void accept(Item item, ItemModel.Unbaked model) {
            this.register(item, new ClientItem(model, ClientItem.Properties.DEFAULT));
        }

        public void accept(Item item, ItemModel.Unbaked model, ClientItem.Properties properties) {
            this.register(item, new ClientItem(model, properties));
        }

        public void register(Item p_388205_, ClientItem p_388233_) {
            ClientItem clientitem = this.itemInfos.put(p_388205_, p_388233_);
            if (clientitem != null) {
                throw new IllegalStateException("Duplicate item model definition for " + String.valueOf(p_388205_));
            }
        }

        public void copy(Item p_386920_, Item p_386789_) {
            this.copies.put(p_386789_, p_386920_);
        }

        public void finalizeAndValidate() {
            if (LibModelProvider.this.autogenBlockItemInfos) {
                BuiltInRegistries.ITEM.listElements().filter(LibModelProvider.this::isModded).forEach(p_388426_ -> {
                    BlockItem blockitem;
                    Object patt0$temp;
                    if (!this.copies.containsKey(p_388426_) && (patt0$temp = p_388426_.value()) instanceof BlockItem && !this.itemInfos.containsKey(blockitem = (BlockItem)patt0$temp)) {
                        Identifier resourcelocation = ModelLocationUtils.getModelLocation((Block)blockitem.getBlock());
                        this.accept((Item)blockitem, ItemModelUtils.plainModel((Identifier)resourcelocation));
                    }
                });
            }
            this.copies.forEach((p_386494_, p_386575_) -> {
                ClientItem clientitem = this.itemInfos.get(p_386575_);
                if (clientitem == null) {
                    throw new IllegalStateException("Missing donor: " + String.valueOf(p_386575_) + " -> " + String.valueOf(p_386494_));
                }
                this.register((Item)p_386494_, clientitem);
            });
        }

        public CompletableFuture<?> save(CachedOutput output, PackOutput.PathProvider pathProvider) {
            return DataProvider.saveAll((CachedOutput)output, (Codec)ClientItem.CODEC, p_388594_ -> pathProvider.json(p_388594_.builtInRegistryHolder().key().identifier()), this.itemInfos);
        }
    }

    static class BlockStateGeneratorCollector
    implements Consumer<BlockModelDefinitionGenerator> {
        private final Map<Block, BlockModelDefinitionGenerator> generators = new HashMap<Block, BlockModelDefinitionGenerator>();

        BlockStateGeneratorCollector() {
        }

        @Override
        public void accept(BlockModelDefinitionGenerator p_388748_) {
            Block block = p_388748_.block();
            BlockModelDefinitionGenerator blockstategenerator = this.generators.put(block, p_388748_);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + String.valueOf(block));
            }
        }

        public CompletableFuture<?> save(CachedOutput p_388014_, PackOutput.PathProvider p_388192_) {
            Map map = Maps.transformValues(this.generators, BlockModelDefinitionGenerator::create);
            Function<Block, Path> function = p_387598_ -> p_388192_.json(p_387598_.builtInRegistryHolder().key().identifier());
            return DataProvider.saveAll((CachedOutput)p_388014_, (Codec)BlockModelDefinition.CODEC, function, (Map)map);
        }
    }

    static class SimpleModelCollector
    implements BiConsumer<Identifier, ModelInstance> {
        private final Map<Identifier, ModelInstance> models = new HashMap<Identifier, ModelInstance>();

        SimpleModelCollector() {
        }

        @Override
        public void accept(Identifier location, ModelInstance instance) {
            Supplier supplier = (Supplier)this.models.put(location, instance);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + String.valueOf(location));
            }
        }

        public CompletableFuture<?> save(CachedOutput output, PackOutput.PathProvider pathProvider) {
            return LibModelProvider.saveAll(output, arg_0 -> ((PackOutput.PathProvider)pathProvider).json(arg_0), this.models);
        }
    }
}

