/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.data.recipe;

import com.mojang.datafixers.util.Function5;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.silentchaos512.lib.util.NameUtils;

public abstract class ExtendedShapedRecipeBuilder<R extends CraftingRecipe>
implements RecipeBuilder {
    private final HolderGetter<Item> items;
    protected final RecipeCategory category;
    protected final ItemStack result;
    protected final List<String> rows = new ArrayList<String>();
    protected final Map<Character, Ingredient> key = new LinkedHashMap<Character, Ingredient>();
    protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    protected String group = "";
    protected boolean showNotification = true;

    public ExtendedShapedRecipeBuilder(HolderGetter<Item> items, RecipeCategory category, ItemStack result) {
        this.items = items;
        this.category = category;
        this.result = result;
    }

    public abstract R createRecipe(ResourceKey<Recipe<?>> var1);

    public ExtendedShapedRecipeBuilder<R> define(Character symbol, TagKey<Item> tagIn) {
        return this.define(symbol, Ingredient.of((HolderSet)this.items.getOrThrow(tagIn)));
    }

    public ExtendedShapedRecipeBuilder<R> define(Character symbol, ItemLike itemIn) {
        return this.define(symbol, Ingredient.of((ItemLike)itemIn));
    }

    public ExtendedShapedRecipeBuilder<R> define(Character symbol, ICustomIngredient customIngredient) {
        return this.define(symbol, new Ingredient(customIngredient));
    }

    public ExtendedShapedRecipeBuilder<R> define(Character symbol, Ingredient ingredientIn) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredientIn);
        return this;
    }

    public ExtendedShapedRecipeBuilder<R> pattern(String patternIn) {
        if (!this.rows.isEmpty() && patternIn.length() != this.rows.getFirst().length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(patternIn);
        return this;
    }

    public ExtendedShapedRecipeBuilder<R> unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public ExtendedShapedRecipeBuilder<R> group(@Nullable String groupIn) {
        this.group = groupIn;
        return this;
    }

    public ExtendedShapedRecipeBuilder<R> showNotification(boolean showNotification) {
        this.showNotification = showNotification;
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput output) {
        this.save(output, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)NameUtils.fromItem(this.result)));
    }

    public void save(RecipeOutput output, ResourceKey<Recipe<?>> id) {
        ShapedRecipePattern pattern = ShapedRecipePattern.of(this.key, this.rows);
        Advancement.Builder advancementBuilder = null;
        if (!this.criteria.isEmpty()) {
            advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked(id)).rewards(AdvancementRewards.Builder.recipe(id)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        }
        R recipe = this.createRecipe(id);
        AdvancementHolder advancementHolder = advancementBuilder != null ? advancementBuilder.build(id.identifier().withPrefix("recipes/" + this.category.getFolderName() + "/")) : null;
        output.accept(id, recipe, advancementHolder);
    }

    public RecipeCategory category() {
        return this.category;
    }

    public ItemStack result() {
        return this.result;
    }

    public ShapedRecipePattern pattern() {
        return ShapedRecipePattern.of(this.key, this.rows);
    }

    public String group() {
        return this.group;
    }

    public boolean showNotification() {
        return this.showNotification;
    }

    public static ShapedRecipe vanillaFactory(Identifier id, ExtendedShapedRecipeBuilder<ShapedRecipe> builder) {
        return new ShapedRecipe(Objects.requireNonNullElse(builder.group, ""), RecipeBuilder.determineBookCategory((RecipeCategory)builder.category), ShapedRecipePattern.of(builder.key, builder.rows), builder.result, builder.showNotification);
    }

    public static class Basic<R extends CraftingRecipe>
    extends ExtendedShapedRecipeBuilder<R> {
        private final BiFunction<ResourceKey<Recipe<?>>, Basic<R>, R> factory;

        public Basic(HolderGetter<Item> items, RecipeCategory category, ItemStack result, BiFunction<ResourceKey<Recipe<?>>, Basic<R>, R> factory) {
            super(items, category, result);
            this.factory = factory;
        }

        public Basic(HolderGetter<Item> items, RecipeCategory category, ItemLike result, BiFunction<ResourceKey<Recipe<?>>, Basic<R>, R> factory) {
            super(items, category, new ItemStack(result));
            this.factory = factory;
        }

        public Basic(HolderGetter<Item> items, RecipeCategory category, ItemLike result, int count, BiFunction<ResourceKey<Recipe<?>>, Basic<R>, R> factory) {
            super(items, category, new ItemStack(result, count));
            this.factory = factory;
        }

        public Basic(HolderGetter<Item> items, RecipeCategory category, ItemStack result, Function5<String, CraftingBookCategory, ShapedRecipePattern, ItemStack, Boolean, R> factory) {
            this(items, category, result, Basic.convertConstructor(factory));
        }

        public Basic(HolderGetter<Item> items, RecipeCategory category, ItemLike result, Function5<String, CraftingBookCategory, ShapedRecipePattern, ItemStack, Boolean, R> factory) {
            this(items, category, result, Basic.convertConstructor(factory));
        }

        public Basic(HolderGetter<Item> items, RecipeCategory category, ItemLike result, int count, Function5<String, CraftingBookCategory, ShapedRecipePattern, ItemStack, Boolean, R> factory) {
            this(items, category, result, Basic.convertConstructor(factory));
        }

        private static <R extends CraftingRecipe> BiFunction<ResourceKey<Recipe<?>>, Basic<R>, R> convertConstructor(Function5<String, CraftingBookCategory, ShapedRecipePattern, ItemStack, Boolean, R> factory) {
            return (id, builder) -> (CraftingRecipe)factory.apply((Object)builder.group, (Object)RecipeBuilder.determineBookCategory((RecipeCategory)builder.category), (Object)builder.pattern(), (Object)builder.result, (Object)builder.showNotification);
        }

        @Override
        public R createRecipe(ResourceKey<Recipe<?>> id) {
            return (R)((CraftingRecipe)this.factory.apply(id, this));
        }
    }
}

