/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.data.recipe;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.criterion.ImpossibleTrigger;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.lib.util.NameUtils;

public abstract class LibRecipeProvider
extends RecipeProvider {
    private final String modId;
    protected final HolderGetter<Item> items;

    public static <T extends RecipeProvider> RecipeProvider.Runner createRunner(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registryLookup, final String name, final BiFunction<HolderLookup.Provider, RecipeOutput, T> constructor) {
        return new RecipeProvider.Runner(packOutput, registryLookup){

            protected RecipeProvider createRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
                return (RecipeProvider)constructor.apply(registries, output);
            }

            public String getName() {
                return name;
            }
        };
    }

    public LibRecipeProvider(HolderLookup.Provider registries, RecipeOutput recipeOutput, String modId) {
        super(registries, recipeOutput);
        this.modId = modId;
        this.items = registries.lookupOrThrow(Registries.ITEM);
    }

    protected abstract void buildRecipes();

    protected ResourceKey<Recipe<?>> modId(String path) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)Identifier.fromNamespaceAndPath((String)this.modId, (String)path));
    }

    protected void registerCustomRecipe(RecipeOutput consumer, Function<CraftingBookCategory, Recipe<?>> serializer, Identifier recipeId) {
        SpecialRecipeBuilder.special(serializer).save(consumer, recipeId.toString());
    }

    protected void smeltingAndBlastingRecipes(RecipeOutput consumer, String id, ItemLike ingredientIn, ItemLike result, float experienceIn) {
        this.smeltingAndBlastingRecipes(consumer, id, Ingredient.of((ItemLike)ingredientIn), result, experienceIn);
    }

    protected void smeltingAndBlastingRecipes(RecipeOutput consumer, String id, TagKey<Item> tag, ItemLike result, float experienceIn) {
        this.smeltingAndBlastingRecipes(consumer, id, Ingredient.of((HolderSet)BuiltInRegistries.ITEM.getOrThrow(tag)), result, experienceIn);
    }

    protected void smeltingAndBlastingRecipes(RecipeOutput consumer, String id, Ingredient ingredientIn, ItemLike result, float experienceIn) {
        SimpleCookingRecipeBuilder.blasting((Ingredient)ingredientIn, (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)experienceIn, (int)100).unlockedBy("impossible", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).save(this.output, this.modId("blasting/" + id));
        SimpleCookingRecipeBuilder.smelting((Ingredient)ingredientIn, (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)experienceIn, (int)200).unlockedBy("impossible", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance())).save(consumer, this.modId("smelting/" + id));
    }

    protected void compressionRecipes(RecipeOutput consumer, ItemLike block, ItemLike item, @Nullable ItemLike nugget) {
        this.compressionRecipes(consumer, RecipeCategory.MISC, block, item, nugget);
    }

    protected void compressionRecipes(RecipeOutput consumer, RecipeCategory category, ItemLike block, ItemLike item, @Nullable ItemLike nugget) {
        String blockName = NameUtils.fromItem(block).getPath();
        String itemName = NameUtils.fromItem(item).getPath();
        this.shaped(RecipeCategory.MISC, block, 1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), item).unlockedBy("has_item", this.has(item)).save(consumer, this.modId(itemName + "_from_block"));
        this.shapeless(RecipeCategory.MISC, item, 9).requires(block).unlockedBy("has_item", this.has(item)).save(consumer, this.modId(blockName));
        if (nugget != null) {
            String nuggetName = NameUtils.fromItem(nugget).getPath();
            this.shaped(RecipeCategory.MISC, item, 1).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), nugget).unlockedBy("has_item", this.has(item)).save(consumer, this.modId(itemName + "_from_nugget"));
            this.shapeless(RecipeCategory.MISC, nugget, 9).requires(item).unlockedBy("has_item", this.has(item)).save(consumer, this.modId(nuggetName));
        }
    }
}

