/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.item;

import java.util.Collection;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.component.LootContainer;
import net.silentchaos512.lib.util.LootUtils;
import net.silentchaos512.lib.util.PlayerUtils;
import org.jetbrains.annotations.Nullable;

public class LootContainerItem
extends Item {
    private final boolean listItemsReceived;

    public LootContainerItem(boolean listItemsReceived) {
        this(listItemsReceived, new Item.Properties());
    }

    public LootContainerItem(boolean listItemsReceived, Item.Properties properties) {
        super(properties);
        this.listItemsReceived = listItemsReceived;
    }

    public ItemStack getStack(ResourceKey<LootTable> lootTable) {
        ItemStack result = new ItemStack((ItemLike)this);
        result.set(SilentLib.LOOT_CONTAINER, (Object)new LootContainer(lootTable));
        return result;
    }

    @Nullable
    protected ResourceKey<LootTable> getLootTable(ItemStack stack) {
        LootContainer lootContainer = (LootContainer)stack.get(SilentLib.LOOT_CONTAINER);
        if (lootContainer != null) {
            return lootContainer.lootTable();
        }
        return null;
    }

    protected Collection<ItemStack> getLootDrops(ItemStack heldItem, ServerPlayer player) {
        ResourceKey<LootTable> lootTable = this.getLootTable(heldItem);
        if (lootTable == null) {
            return List.of();
        }
        return LootUtils.gift(lootTable, player);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Collection<ItemStack> lootDrops = this.getLootDrops(heldItem, serverPlayer);
        if (lootDrops.isEmpty()) {
            SilentLib.LOGGER.warn("LootContainerItem has no drops? {}, table={}", (Object)heldItem, this.getLootTable(heldItem));
        }
        lootDrops.forEach(stack -> {
            PlayerUtils.giveItem((Player)serverPlayer, stack);
            if (this.listItemsReceived) {
                LootContainerItem.listItemReceivedInChat(serverPlayer, stack);
            }
        });
        float pitch = ((serverPlayer.getRandom().nextFloat() - serverPlayer.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f;
        serverPlayer.level().playSound(null, serverPlayer.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, pitch);
        heldItem.shrink(1);
        return InteractionResult.SUCCESS;
    }

    private static void listItemReceivedInChat(ServerPlayer serverPlayer, ItemStack stack) {
        MutableComponent itemReceivedText = Component.translatable((String)"item.silentlib.lootContainer.itemReceived", (Object[])new Object[]{stack.getCount(), stack.getHoverName()});
        serverPlayer.sendSystemMessage((Component)itemReceivedText);
    }
}

