/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record DimPos(int posX, int posY, int posZ, ResourceKey<Level> dimension) {
    public static final Codec<DimPos> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(DimPos::posX), (App)Codec.INT.fieldOf("y").forGetter(DimPos::posY), (App)Codec.INT.fieldOf("z").forGetter(DimPos::posZ), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dimension").forGetter(DimPos::dimension)).apply((Applicative)instance, DimPos::of));
    public static final StreamCodec<RegistryFriendlyByteBuf, DimPos> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, DimPos::posX, (StreamCodec)ByteBufCodecs.VAR_INT, DimPos::posY, (StreamCodec)ByteBufCodecs.VAR_INT, DimPos::posZ, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), DimPos::dimension, DimPos::of);
    public static final DimPos ZERO = new DimPos(0, 0, 0, (ResourceKey<Level>)Level.OVERWORLD);

    private DimPos(BlockPos pos, ResourceKey<Level> dimension) {
        this(pos.getX(), pos.getY(), pos.getZ(), dimension);
    }

    public static DimPos of(BlockPos pos, ResourceKey<Level> dimension) {
        return new DimPos(pos, dimension);
    }

    public static DimPos of(int x, int y, int z, ResourceKey<Level> dimension) {
        return new DimPos(x, y, z, dimension);
    }

    public static DimPos of(Entity entity) {
        return new DimPos(entity.blockPosition(), (ResourceKey<Level>)entity.level().dimension());
    }

    public static DimPos deserializeNbt(CompoundTag tag) {
        return DimPos.of(tag.getIntOr("posX", 0), tag.getIntOr("posY", 0), tag.getIntOr("posZ", 0), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (Identifier)Identifier.parse((String)tag.getStringOr("dim", "minecraft:overworld"))));
    }

    public CompoundTag serializeNbt() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("posX", this.posX);
        tag.putInt("posY", this.posY);
        tag.putInt("posZ", this.posZ);
        tag.putString("dim", this.dimension.identifier().toString());
        return tag;
    }

    public Optional<Level> getPosLevel(Level anyLevel) {
        MinecraftServer server = anyLevel.getServer();
        if (server == null) {
            return Optional.empty();
        }
        ServerLevel posLevel = server.getLevel(this.dimension);
        return Optional.ofNullable(posLevel);
    }

    public BlockPos getPos() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    public Vec3 getPosCentered(double yOffset) {
        return new Vec3((double)this.posX + 0.5, (double)this.posY + yOffset, (double)this.posZ + 0.5);
    }

    public DimPos offset(Direction facing, int n) {
        if (n == 0) {
            return this;
        }
        return new DimPos(this.posX + facing.getStepX() * n, this.posY + facing.getStepY() * n, this.posZ + facing.getStepZ() * n, this.dimension);
    }

    @Override
    public String toString() {
        return String.format("(%d, %d, %s) in %s", this.posX, this.posY, this.posZ, this.dimension.identifier());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DimPos) {
            DimPos pos = (DimPos)other;
            return pos.dimension.identifier().equals((Object)this.dimension.identifier()) && pos.posX == this.posX && pos.posY == this.posY && pos.posZ == this.posZ;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * (31 * (31 * this.posX + this.posY) + this.posZ) + this.dimension.identifier().hashCode();
    }
}

