/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public final class NameUtils {
    private static final Pattern PATTERN = Pattern.compile("([a-z0-9._-]+:)?[a-z0-9/._-]+");

    private NameUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean isValid(CharSequence name) {
        return PATTERN.matcher(name).matches();
    }

    public static Identifier checkNotNull(@Nullable Identifier name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name is null, make sure the object has been registered correctly");
        return name;
    }

    public static Identifier common(String path) {
        return Identifier.fromNamespaceAndPath((String)"c", (String)path);
    }

    public static <T> Identifier from(Registry<T> registry, T obj) {
        return NameUtils.checkNotNull(registry.getKey(obj));
    }

    public static Identifier fromBlock(Block block) {
        return NameUtils.checkNotNull(BuiltInRegistries.BLOCK.getKey((Object)block));
    }

    public static Identifier fromBlock(BlockState state) {
        return NameUtils.fromBlock(state.getBlock());
    }

    public static Identifier fromEntity(Entity entity) {
        return NameUtils.fromEntityType(entity.getType());
    }

    public static Identifier fromEntityType(EntityType<?> type) {
        return NameUtils.checkNotNull(BuiltInRegistries.ENTITY_TYPE.getKey(type));
    }

    public static Identifier fromFluid(Fluid fluid) {
        return NameUtils.checkNotNull(BuiltInRegistries.FLUID.getKey((Object)fluid));
    }

    public static Identifier fromFluid(FluidStack fluid) {
        return NameUtils.fromFluid(fluid.getFluid());
    }

    public static Identifier fromItem(ItemLike item) {
        Preconditions.checkNotNull((Object)item.asItem(), (Object)"asItem() is null, has object not been fully constructed?");
        return NameUtils.checkNotNull(BuiltInRegistries.ITEM.getKey((Object)item.asItem()));
    }

    public static Identifier fromItem(ItemStack stack) {
        return NameUtils.fromItem((ItemLike)stack.getItem());
    }

    public static Identifier fromRecipeSerializer(RecipeSerializer<? extends Recipe<?>> serializer) {
        return NameUtils.checkNotNull(BuiltInRegistries.RECIPE_SERIALIZER.getKey(serializer));
    }
}

