/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class PlayerUtils {
    private PlayerUtils() {
    }

    public static void giveItem(Player player, ItemStack stack) {
        ItemStack copy = stack.copy();
        if (!player.getInventory().add(copy)) {
            ItemEntity entityItem = new ItemEntity(player.level(), player.getX(), player.getY(0.5), player.getZ(), copy);
            entityItem.setNoPickUpDelay();
            entityItem.setThrower((Entity)player);
            player.level().addFreshEntity((Entity)entityItem);
        }
    }

    public static CompoundTag getPersistedDataSubcompound(Player player, String subCompoundKey) {
        CompoundTag persistedData;
        CompoundTag forgeData = player.getPersistentData();
        if (!forgeData.contains("PlayerPersisted")) {
            forgeData.put("PlayerPersisted", (Tag)new CompoundTag());
        }
        if (!(persistedData = (CompoundTag)forgeData.getCompound("PlayerPersisted").orElseThrow()).contains(subCompoundKey)) {
            persistedData.put(subCompoundKey, (Tag)new CompoundTag());
        }
        return (CompoundTag)persistedData.getCompound(subCompoundKey).orElseThrow();
    }
}

