/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.silentchaos512.lib.SilentLib;

public class DimensionFilterPlacement
extends PlacementModifier {
    public static final MapCodec<DimensionFilterPlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("is_whitelist").forGetter(f -> f.isWhitelist), (App)Codec.STRING.listOf().fieldOf("list").forGetter(f -> f.levels.stream().map(rk -> rk.identifier().toString()).collect(Collectors.toList()))).apply((Applicative)instance, (isWhitelist, strList) -> {
        Collection levels = strList.stream().map(str -> ResourceKey.create((ResourceKey)Registries.DIMENSION, (Identifier)Identifier.parse((String)str))).collect(Collectors.toList());
        return new DimensionFilterPlacement((boolean)isWhitelist, levels);
    }));
    private final boolean isWhitelist;
    private final Collection<ResourceKey<Level>> levels;

    public DimensionFilterPlacement(boolean isWhitelist, Collection<ResourceKey<Level>> levels) {
        this.isWhitelist = isWhitelist;
        this.levels = levels;
    }

    public Stream<BlockPos> getPositions(PlacementContext helper, RandomSource rand, BlockPos pos) {
        if (this.levels.contains(helper.getLevel().getLevel().dimension()) == this.isWhitelist) {
            return Stream.of(pos);
        }
        return Stream.empty();
    }

    public PlacementModifierType<DimensionFilterPlacement> type() {
        return (PlacementModifierType)SilentLib.DIMENSION_FILTER_PLACEMENT.get();
    }
}

