/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear;

import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.IProxy;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.client.event.TooltipHandler;
import net.silentchaos512.gear.gear.material.MaterialSerializers;
import net.silentchaos512.gear.gear.part.CoreGearPart;
import net.silentchaos512.gear.gear.part.PartSerializers;
import net.silentchaos512.gear.item.BlueprintPackageItem;
import net.silentchaos512.gear.setup.SgAttributes;
import net.silentchaos512.gear.setup.SgBlockEntities;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.setup.SgCommands;
import net.silentchaos512.gear.setup.SgCreativeTabs;
import net.silentchaos512.gear.setup.SgCriteriaTriggers;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.SgEntities;
import net.silentchaos512.gear.setup.SgIngredientTypes;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.SgLoot;
import net.silentchaos512.gear.setup.SgMenuTypes;
import net.silentchaos512.gear.setup.SgRecipeBookCategories;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.SgSlotDisplayTypes;
import net.silentchaos512.gear.setup.SgSounds;
import net.silentchaos512.gear.setup.SgVillages;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.MaterialModifiers;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.setup.gear.TraitConditions;
import net.silentchaos512.gear.setup.gear.TraitEffectTypes;
import net.silentchaos512.gear.world.SgWorldFeatures;
import net.silentchaos512.lib.event.Greetings;
import net.silentchaos512.lib.event.InitialSpawnItems;

class SideProxy
implements IProxy {
    @Nullable
    private static MinecraftServer server;
    @Nullable
    private static CreativeModeTab creativeModeTab;

    SideProxy(IEventBus modEventBus) {
        GearProperties.REGISTRAR.register(modEventBus);
        GearTypes.REGISTRAR.register(modEventBus);
        PartTypes.REGISTRAR.register(modEventBus);
        TraitEffectTypes.REGISTRAR.register(modEventBus);
        MaterialModifiers.REGISTRAR.register(modEventBus);
        MaterialSerializers.REGISTRAR.register(modEventBus);
        PartSerializers.REGISTRAR.register(modEventBus);
        TraitConditions.REGISTRAR.register(modEventBus);
        SgAttributes.ATTRIBUTES.register(modEventBus);
        SgBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        SgBlocks.BLOCKS.register(modEventBus);
        SgCreativeTabs.CREATIVE_TABS.register(modEventBus);
        SgCriteriaTriggers.TRIGGER_TYPES.register(modEventBus);
        SgDataComponents.REGISTRAR.register(modEventBus);
        SgEntities.ENTITIES.register(modEventBus);
        SgIngredientTypes.REGISTRAR.register(modEventBus);
        SgItems.ITEMS.register(modEventBus);
        SgLoot.LOOT_CONDITIONS.register(modEventBus);
        SgLoot.LOOT_FUNCTIONS.register(modEventBus);
        SgLoot.LOOT_MODIFIERS.register(modEventBus);
        SgMenuTypes.MENU_TYPES.register(modEventBus);
        SgVillages.POINTS_OF_INTEREST.register(modEventBus);
        SgVillages.PROFESSIONS.register(modEventBus);
        SgRecipeBookCategories.RECIPE_BOOK_CATEGORIES.register(modEventBus);
        SgRecipes.RECIPE_SERIALIZERS.register(modEventBus);
        SgRecipes.RECIPE_TYPES.register(modEventBus);
        SgSlotDisplayTypes.SLOT_DISPLAY_TYPES.register(modEventBus);
        SgSounds.REGISTRAR.register(modEventBus);
        modEventBus.addListener(SgWorldFeatures::registerFeatures);
        modEventBus.addListener(SideProxy::commonSetup);
        modEventBus.addListener(SideProxy::registerCapabilities);
        modEventBus.addListener(SideProxy::imcEnqueue);
        modEventBus.addListener(SideProxy::imcProcess);
        NeoForge.EVENT_BUS.addListener(SgCommands::registerAll);
        NeoForge.EVENT_BUS.addListener(SideProxy::onAddReloadListeners);
        NeoForge.EVENT_BUS.addListener(SideProxy::serverStarted);
        NeoForge.EVENT_BUS.addListener(SideProxy::serverStopping);
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        InitialSpawnItems.add((Identifier)SilentGear.getId("starter_blueprints"), p -> {
            if (((Boolean)Config.Common.spawnWithStarterBlueprints.get()).booleanValue()) {
                return Collections.singleton(((BlueprintPackageItem)((Object)((Object)SgItems.BLUEPRINT_PACKAGE.get()))).getDefaultStack());
            }
            return Collections.emptyList();
        });
        Greetings.addMessage(SideProxy::detectDataLoadingFailure);
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
    }

    private static void imcEnqueue(InterModEnqueueEvent event) {
    }

    private static void imcProcess(InterModProcessEvent event) {
    }

    private static void onAddReloadListeners(AddServerReloadListenersEvent event) {
        event.addListener(SilentGear.getId("trait"), (PreparableReloadListener)SgRegistries.TRAIT);
        event.addListener(SilentGear.getId("material"), (PreparableReloadListener)SgRegistries.MATERIAL);
        event.addListener(SilentGear.getId("part"), (PreparableReloadListener)SgRegistries.PART);
    }

    private static void serverStarted(ServerStartedEvent event) {
        server = event.getServer();
        SilentGear.LOGGER.info("Traits loaded: {}", (Object)SgRegistries.TRAIT.stream().count());
        SilentGear.LOGGER.info("Parts loaded: {}", (Object)SgRegistries.PART.stream().count());
        SilentGear.LOGGER.info("- Compound: {}", (Object)SgRegistries.PART.stream().filter(part -> part instanceof CoreGearPart).count());
        SilentGear.LOGGER.info("- Simple: {}", (Object)SgRegistries.PART.stream().filter(part -> !(part instanceof CoreGearPart)).count());
        SilentGear.LOGGER.info("Materials loaded: {}", (Object)SgRegistries.MATERIAL.stream().count());
        SilentGear.LOGGER.info("- Standard: {}", (Object)SgRegistries.MATERIAL.stream().filter(mat -> mat.getSerializer() == MaterialSerializers.SIMPLE.get()).count());
    }

    private static void serverStopping(ServerStoppingEvent event) {
        server = null;
    }

    @Override
    @Nullable
    public Player getClientPlayer() {
        return null;
    }

    @Override
    @Nullable
    public Level getClientLevel() {
        return null;
    }

    @Override
    public boolean checkClientInstance() {
        return true;
    }

    @Override
    public boolean checkClientConnection() {
        return true;
    }

    @Override
    @Nullable
    public MinecraftServer getServer() {
        return server;
    }

    @Nullable
    public static Component detectDataLoadingFailure(Player player) {
        if (SgRegistries.MATERIAL.keySet().isEmpty() || SgRegistries.PART.keySet().isEmpty() || SgRegistries.TRAIT.keySet().isEmpty()) {
            String msg = "Materials, parts, and/or traits have not loaded! This may be caused by a broken mod, even those not related to Silent Gear. Search your log for \"Failed to reload data packs\" to find the error.";
            SilentGear.LOGGER.error(msg);
            return Component.literal((String)msg);
        }
        return null;
    }

    static class Server
    extends SideProxy {
        Server(IEventBus modEventBus, ModContainer container) {
            super(modEventBus);
            modEventBus.addListener(this::serverSetup);
        }

        private void serverSetup(FMLDedicatedServerSetupEvent event) {
        }
    }

    static class Client
    extends SideProxy {
        Client(IEventBus modEventBus, ModContainer container) {
            super(modEventBus);
            modEventBus.addListener(Client::clientSetup);
            modEventBus.addListener(Client::postSetup);
            NeoForge.EVENT_BUS.register((Object)TooltipHandler.INSTANCE);
            NeoForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
            if (SilentGear.isDevBuild()) {
                // empty if block
            }
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }

        private static void clientSetup(FMLClientSetupEvent event) {
        }

        private static void postSetup(FMLLoadCompleteEvent event) {
        }

        private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        }

        @Override
        @Nullable
        public Player getClientPlayer() {
            return Minecraft.getInstance().player;
        }

        @Override
        @Nullable
        public Level getClientLevel() {
            Minecraft mc = Minecraft.getInstance();
            return mc != null ? mc.level : null;
        }

        @Override
        public boolean checkClientInstance() {
            return Minecraft.getInstance() != null;
        }

        @Override
        public boolean checkClientConnection() {
            Minecraft mc = Minecraft.getInstance();
            return mc != null && mc.getConnection() != null;
        }
    }
}

