/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.data.material;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.material.MaterialCraftingData;
import net.silentchaos512.gear.api.material.MaterialDisplayData;
import net.silentchaos512.gear.api.material.MaterialEquippableInfo;
import net.silentchaos512.gear.api.material.TextureType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyMap;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.property.HarvestTier;
import net.silentchaos512.gear.api.property.HarvestTierPropertyValue;
import net.silentchaos512.gear.api.property.NumberProperty;
import net.silentchaos512.gear.api.property.NumberPropertyValue;
import net.silentchaos512.gear.api.property.TraitListPropertyValue;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.client.material.SgEquippableInfo;
import net.silentchaos512.gear.core.BuiltinMaterials;
import net.silentchaos512.gear.gear.material.CustomCompoundMaterial;
import net.silentchaos512.gear.gear.material.ProcessedMaterial;
import net.silentchaos512.gear.gear.material.SimpleMaterial;
import net.silentchaos512.gear.gear.trait.Trait;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.lib.util.Color;

public class MaterialBuilder<M extends Material> {
    @Nullable
    BuiltinMaterials builtinMaterial;
    private final Identifier id;
    private final MaterialFactory<M> factory;
    private DataResource<Material> parent = DataResource.empty();
    private MaterialCraftingData crafting = null;
    private MaterialDisplayData display;
    private final Map<PartType, GearPropertyMap> properties = new LinkedHashMap<PartType, GearPropertyMap>();
    private final Map<PartType, List<TraitInstance>> traits = new LinkedHashMap<PartType, List<TraitInstance>>();

    public MaterialBuilder(Identifier id, MaterialFactory<M> factory) {
        this.id = id;
        this.factory = factory;
        this.display = new MaterialDisplayData((Component)this.getDefaultTranslatedName(), (Component)Component.empty(), Color.WHITE, TextureType.HIGH_CONTRAST, SgEquippableInfo.GENERIC_SHINY);
    }

    private MutableComponent getDefaultTranslatedName() {
        return Component.translatable((String)String.format("material.%s.%s", this.id.getNamespace(), this.id.getPath().replace("/", ".")));
    }

    public static MaterialBuilder<SimpleMaterial> simple(DataResource<Material> material) {
        return new MaterialBuilder<SimpleMaterial>(material.getId(), SimpleMaterial::new);
    }

    public static MaterialBuilder<SimpleMaterial> builtin(BuiltinMaterials material) {
        MaterialBuilder<SimpleMaterial> result = MaterialBuilder.simple(material.getMaterial());
        result.builtinMaterial = material;
        return result;
    }

    public static MaterialBuilder<CustomCompoundMaterial> customCompound(DataResource<Material> material) {
        return new MaterialBuilder<CustomCompoundMaterial>(material.getId(), CustomCompoundMaterial::new);
    }

    public static MaterialBuilder<ProcessedMaterial> processed(DataResource<Material> material) {
        return new MaterialBuilder<ProcessedMaterial>(material.getId(), ProcessedMaterial::new);
    }

    public Identifier getId() {
        return this.id;
    }

    public MaterialBuilder<M> parent(DataResource<Material> parent) {
        this.parent = parent;
        return this;
    }

    public MaterialBuilder<M> crafting(ItemLike craftingItem, IMaterialCategory ... categories) {
        return this.crafting(new MaterialCraftingData(Ingredient.of((ItemLike)craftingItem), (List<IMaterialCategory>)Lists.newArrayList((Object[])categories), Collections.emptyList(), Collections.emptyMap(), true));
    }

    public MaterialBuilder<M> crafting(HolderGetter<Item> items, TagKey<Item> craftingItem, IMaterialCategory ... categories) {
        return this.crafting(new MaterialCraftingData(Ingredient.of((HolderSet)items.getOrThrow(craftingItem)), (List<IMaterialCategory>)Lists.newArrayList((Object[])categories), Collections.emptyList(), Collections.emptyMap(), true));
    }

    public MaterialBuilder<M> crafting(Ingredient ingredient, IMaterialCategory ... categories) {
        return this.crafting(new MaterialCraftingData(ingredient, (List<IMaterialCategory>)Lists.newArrayList((Object[])categories), Collections.emptyList(), Collections.emptyMap(), true));
    }

    public MaterialBuilder<M> crafting(MaterialCraftingData crafting) {
        this.crafting = crafting;
        return this;
    }

    public MaterialBuilder<M> craftingWithRodSubstitute(HolderGetter<Item> items, TagKey<Item> craftingItem, TagKey<Item> rod, IMaterialCategory ... categories) {
        if (this.builtinMaterial == null) {
            throw new IllegalStateException("Cannot use craftingWithCommonRod if builtinMaterial is null");
        }
        return this.crafting(new MaterialCraftingData(Ingredient.of((HolderSet)items.getOrThrow(craftingItem)), (List<IMaterialCategory>)Lists.newArrayList((Object[])categories), Collections.emptyList(), Map.of((PartType)PartTypes.ROD.get(), Ingredient.of((HolderSet)items.getOrThrow(rod))), true));
    }

    public MaterialBuilder<M> displayWithDefaultName(int color) {
        return this.displayWithDefaultName((Component)Component.empty(), color, TextureType.HIGH_CONTRAST);
    }

    public MaterialBuilder<M> displayWithDefaultName(int color, TextureType textureType) {
        return this.displayWithDefaultName((Component)Component.empty(), color, textureType);
    }

    public MaterialBuilder<M> displayWithDefaultName(int color, TextureType textureType, MaterialEquippableInfo armor) {
        return this.displayWithDefaultName((Component)Component.empty(), color, textureType, armor);
    }

    public MaterialBuilder<M> displayWithDefaultName(Component namePrefix, int color, TextureType textureType) {
        return this.displayWithDefaultName(namePrefix, color, textureType, SgEquippableInfo.GENERIC_SHINY);
    }

    public MaterialBuilder<M> displayWithDefaultName(Component namePrefix, int color, TextureType textureType, MaterialEquippableInfo armor) {
        return this.display((Component)this.getDefaultTranslatedName(), namePrefix, color, textureType, armor);
    }

    public MaterialBuilder<M> display(Component name, int color) {
        return this.display(name, (Component)Component.empty(), color, TextureType.HIGH_CONTRAST);
    }

    public MaterialBuilder<M> display(Component name, Component namePrefix, int color) {
        return this.display(name, namePrefix, color, TextureType.HIGH_CONTRAST);
    }

    public MaterialBuilder<M> display(Component name, int color, TextureType textureType) {
        return this.display(name, (Component)Component.empty(), color, textureType);
    }

    public MaterialBuilder<M> display(Component name, Component namePrefix, int color, TextureType textureType) {
        return this.display(name, namePrefix, color, textureType, SgEquippableInfo.GENERIC_SHINY);
    }

    public MaterialBuilder<M> display(Component name, Component namePrefix, int color, TextureType textureType, MaterialEquippableInfo armor) {
        return this.display(new MaterialDisplayData(name, namePrefix, new Color(color), textureType, armor));
    }

    public MaterialBuilder<M> display(MaterialDisplayData display) {
        this.display = display;
        return this;
    }

    public MaterialBuilder<M> noProperties(Supplier<PartType> partType) {
        this.properties.computeIfAbsent(partType.get(), pt -> new GearPropertyMap());
        return this;
    }

    public <T, V extends GearPropertyValue<T>, P extends GearProperty<T, V>> MaterialBuilder<M> stat(Supplier<PartType> partType, Supplier<P> property, V value) {
        return this.stat(PartGearKey.ofAll(partType), property, value);
    }

    public <T, V extends GearPropertyValue<T>, P extends GearProperty<T, V>> MaterialBuilder<M> stat(PartGearKey key, Supplier<P> property, V value) {
        GearPropertyMap map = this.properties.computeIfAbsent(key.partType(), pt -> new GearPropertyMap());
        map.put((GearProperty)property.get(), key.gearType(), value);
        return this;
    }

    public <T, V extends GearPropertyValue<T>, P extends GearProperty<T, V>> MaterialBuilder<M> stat(Supplier<PartType> partType, Supplier<P> property, T value) {
        return this.stat(partType, property, ((GearProperty)property.get()).valueOf(value));
    }

    public MaterialBuilder<M> stat(Supplier<PartType> partType, Supplier<NumberProperty> property, float value) {
        return this.stat(partType, (Supplier)property, (Object)new NumberPropertyValue(value, NumberProperty.Operation.AVERAGE));
    }

    public MaterialBuilder<M> stat(Supplier<PartType> partType, Supplier<NumberProperty> property, float value, NumberProperty.Operation operation) {
        return this.stat(partType, (Supplier)property, (Object)new NumberPropertyValue(value, operation));
    }

    public MaterialBuilder<M> stat(PartGearKey key, Supplier<NumberProperty> property, float value) {
        return this.stat(key, property, NumberPropertyValue.average(value));
    }

    public MaterialBuilder<M> stat(PartGearKey key, Supplier<NumberProperty> property, float value, NumberProperty.Operation operation) {
        return this.stat(key, property, new NumberPropertyValue(value, operation));
    }

    @Deprecated
    public MaterialBuilder<M> mainStatsCommon(float toolDurability, float armorDurability, float enchantmentValue, float rarity) {
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.DURABILITY, (Object)NumberPropertyValue.average(toolDurability));
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.ARMOR_DURABILITY, (Object)NumberPropertyValue.average(armorDurability));
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.ENCHANTMENT_VALUE, (Object)NumberPropertyValue.average(enchantmentValue));
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.RARITY, (Object)NumberPropertyValue.average(rarity));
        return this;
    }

    public MaterialBuilder<M> mainStatsCommon(float toolDurability, float armorDurability, float enchantmentValue, float rarity, float chargeValue) {
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.DURABILITY, (Object)NumberPropertyValue.average(toolDurability));
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.ARMOR_DURABILITY, (Object)NumberPropertyValue.average(armorDurability));
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.ENCHANTMENT_VALUE, (Object)NumberPropertyValue.average(enchantmentValue));
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.RARITY, (Object)NumberPropertyValue.average(rarity));
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.CHARGING_VALUE, (Object)NumberPropertyValue.average(chargeValue));
        return this;
    }

    public MaterialBuilder<M> mainStatsHarvest(HarvestTier harvestTier, float harvestSpeed) {
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.HARVEST_TIER, (Object)new HarvestTierPropertyValue(harvestTier));
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.HARVEST_SPEED, (Object)NumberPropertyValue.average(harvestSpeed));
        return this;
    }

    public MaterialBuilder<M> mainStatsHarvest(float harvestSpeed) {
        this.harvestTierBuiltin((Supplier<PartType>)PartTypes.MAIN);
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.HARVEST_SPEED, (Object)NumberPropertyValue.average(harvestSpeed));
        return this;
    }

    public MaterialBuilder<M> harvestTierBuiltin(Supplier<PartType> partType) {
        if (this.builtinMaterial != null) {
            HarvestTier harvestTier = this.builtinMaterial.getHarvestTier();
            this.stat(partType, (Supplier)GearProperties.HARVEST_TIER, (Object)new HarvestTierPropertyValue(harvestTier));
        }
        return this;
    }

    public MaterialBuilder<M> mainStatsMelee(float attackDamage, float magicDamage, float attackSpeed) {
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.ATTACK_DAMAGE, (Object)NumberPropertyValue.average(attackDamage));
        if (magicDamage > 0.0f) {
            this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.MAGIC_DAMAGE, (Object)NumberPropertyValue.average(magicDamage));
        }
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.ATTACK_SPEED, (Object)NumberPropertyValue.average(attackSpeed));
        return this;
    }

    public MaterialBuilder<M> mainStatsRanged(float rangedDamage, float rangedSpeed) {
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.RANGED_DAMAGE, (Object)NumberPropertyValue.average(rangedDamage));
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.DRAW_SPEED, (Object)NumberPropertyValue.average(rangedSpeed));
        return this;
    }

    public MaterialBuilder<M> mainStatsRanged(float rangedDamage, float rangedSpeed, float projectileSpeed, float projectileAccuracy) {
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.RANGED_DAMAGE, (Object)NumberPropertyValue.average(rangedDamage));
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.DRAW_SPEED, (Object)NumberPropertyValue.average(rangedSpeed));
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.PROJECTILE_SPEED, (Object)NumberPropertyValue.average(projectileSpeed));
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.PROJECTILE_ACCURACY, (Object)NumberPropertyValue.average(projectileAccuracy));
        return this;
    }

    public MaterialBuilder<M> mainStatsProjectile(float projectileSpeed, float projectileAccuracy) {
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.PROJECTILE_SPEED, (Object)NumberPropertyValue.average(projectileSpeed));
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.PROJECTILE_ACCURACY, (Object)NumberPropertyValue.average(projectileAccuracy));
        return this;
    }

    @Deprecated
    public MaterialBuilder<M> mainStatsArmor(float armor, float toughness, float magicArmor) {
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.ARMOR, (Object)NumberPropertyValue.average(armor));
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.ARMOR_TOUGHNESS, (Object)NumberPropertyValue.average(toughness));
        this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.MAGIC_ARMOR, (Object)NumberPropertyValue.average(magicArmor));
        return this;
    }

    public MaterialBuilder<M> mainStatsArmor(float head, float chest, float legs, float feet, float toughness, float magicArmor) {
        if (this.properties.get(PartTypes.MAIN.get()).containsKey(PropertyKey.of(GearProperties.ARMOR, GearTypes.ALL))) {
            throw new IllegalStateException("Called mainStatsArmor when armor stat is already defined");
        }
        if (head > 0.0f && chest > 0.0f && legs > 0.0f && feet > 0.0f) {
            float sum = head + chest + legs + feet;
            this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.ARMOR, (Object)NumberPropertyValue.average(sum));
        }
        if (head > 0.0f) {
            this.stat(PartGearKey.ofMain(GearTypes.HELMET), GearProperties.ARMOR, NumberPropertyValue.average(head));
        }
        if (chest > 0.0f) {
            this.stat(PartGearKey.ofMain(GearTypes.CHESTPLATE), GearProperties.ARMOR, NumberPropertyValue.average(chest));
        }
        if (legs > 0.0f) {
            this.stat(PartGearKey.ofMain(GearTypes.LEGGINGS), GearProperties.ARMOR, NumberPropertyValue.average(legs));
        }
        if (feet > 0.0f) {
            this.stat(PartGearKey.ofMain(GearTypes.BOOTS), GearProperties.ARMOR, NumberPropertyValue.average(feet));
        }
        if (toughness > 0.0f) {
            this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.ARMOR_TOUGHNESS, (Object)NumberPropertyValue.average(toughness));
        }
        if (magicArmor > 0.0f) {
            this.stat((Supplier<PartType>)PartTypes.MAIN, (Supplier)GearProperties.MAGIC_ARMOR, (Object)NumberPropertyValue.average(magicArmor));
        }
        return this;
    }

    public MaterialBuilder<M> trait(Supplier<PartType> partType, DataResource<Trait> trait, int level, ITraitCondition ... conditions) {
        TraitInstance inst = TraitInstance.of(trait, level, conditions);
        List list = this.traits.computeIfAbsent(partType.get(), pt -> new ArrayList());
        list.add(inst);
        return this;
    }

    private void validate() {
        if (this.crafting == null) {
            throw new IllegalStateException("Material has no crafting information: " + String.valueOf(this.id));
        }
    }

    public M build() {
        this.validate();
        this.traits.forEach((partType, traitInstances) -> {
            GearPropertyMap gearPropertyMap = this.properties.computeIfAbsent((PartType)partType, pt -> new GearPropertyMap());
            gearPropertyMap.put(GearProperties.TRAITS.get(), (GearType)GearTypes.ALL.get(), new TraitListPropertyValue((List<TraitInstance>)traitInstances));
        });
        return this.factory.create(this.parent, this.crafting, this.display, this.properties);
    }

    public static interface MaterialFactory<M extends Material> {
        public M create(DataResource<Material> var1, MaterialCraftingData var2, MaterialDisplayData var3, Map<PartType, GearPropertyMap> var4);
    }
}

