/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.data.material;

import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.Identifier;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.data.material.MaterialBuilder;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.gear.material.MaterialSerializers;
import org.jetbrains.annotations.NotNull;

public abstract class MaterialsProviderBase
implements DataProvider {
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    protected final DataGenerator generator;
    protected final String modId;

    public MaterialsProviderBase(CompletableFuture<HolderLookup.Provider> lookupProvider, DataGenerator generator, String modId) {
        this.lookupProvider = lookupProvider;
        this.generator = generator;
        this.modId = modId;
    }

    protected abstract Collection<MaterialBuilder<?>> getMaterials(HolderLookup.Provider var1);

    protected DataResource<Material> modId(String path) {
        return DataResource.material(Identifier.fromNamespaceAndPath((String)this.modId, (String)path));
    }

    protected static Identifier commonId(String path) {
        return Identifier.fromNamespaceAndPath((String)"c", (String)path);
    }

    @NotNull
    public String getName() {
        return "Silent Gear Materials: " + this.modId;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        Path outputFolder = this.generator.getPackOutput().getOutputFolder();
        HashSet set = Sets.newHashSet();
        ArrayList list = new ArrayList();
        return this.lookupProvider.thenCompose(provider -> {
            this.getMaterials((HolderLookup.Provider)provider).forEach(builder -> {
                Identifier id = builder.getId();
                if (!set.add(id)) {
                    throw new IllegalStateException("Duplicate material: " + String.valueOf(id));
                }
                Path path = outputFolder.resolve(String.format("data/%s/silentgear_materials/%s.json", id.getNamespace(), id.getPath()));
                SilentGear.LOGGER.info("Serializing material \"{}\"", (Object)id);
                list.add(DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)provider, MaterialSerializers.DISPATCH_CODEC, builder.build(), (Path)path));
            });
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }
}

