/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.data.part;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartCraftingData;
import net.silentchaos512.gear.api.part.PartDisplayData;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyMap;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.property.NumberProperty;
import net.silentchaos512.gear.api.property.NumberPropertyValue;
import net.silentchaos512.gear.api.property.TraitListPropertyValue;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.gear.part.CoreGearPart;
import net.silentchaos512.gear.gear.part.PartSerializers;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.GearTypes;

public class PartBuilder {
    protected final Identifier id;
    protected final GearType gearType;
    protected final PartType partType;
    protected PartCraftingData crafting;
    protected PartDisplayData display;
    protected final GearPropertyMap properties = new GearPropertyMap();

    public PartBuilder(Identifier id, Supplier<GearType> gearType, Supplier<PartType> partType) {
        this.id = id;
        this.gearType = gearType.get();
        this.partType = partType.get();
        if (!this.gearType.isGear()) {
            throw new IllegalArgumentException("Part gear type must extend GearType.ALL");
        }
    }

    public Identifier getId() {
        return this.id;
    }

    public GearType getGearType() {
        return this.gearType;
    }

    public PartBuilder crafting(PartCraftingData crafting) {
        this.crafting = crafting;
        return this;
    }

    public PartBuilder crafting(Ingredient ingredient) {
        return this.crafting(new PartCraftingData(Optional.of(ingredient), Collections.emptyList(), true));
    }

    public PartBuilder crafting(TagKey<Item> tag) {
        return this.crafting(new PartCraftingData(Optional.of(Ingredient.of((HolderSet)BuiltInRegistries.ITEM.getOrThrow(tag))), Collections.emptyList(), true));
    }

    public PartBuilder crafting(ItemLike item) {
        return this.crafting(new PartCraftingData(Optional.of(Ingredient.of((ItemLike)item)), Collections.emptyList(), true));
    }

    public PartBuilder display(PartDisplayData display) {
        this.display = display;
        return this;
    }

    public PartBuilder display(Component name) {
        return this.display(new PartDisplayData(name, (Component)Component.empty()));
    }

    public <T, V extends GearPropertyValue<T>> PartBuilder property(PropertyKey<T, V> key, V value) {
        this.properties.put(key, value);
        return this;
    }

    public <T, V extends GearPropertyValue<T>, P extends GearProperty<T, V>> PartBuilder property(Supplier<P> property, V value) {
        return this.property(PropertyKey.of(property, GearTypes.ALL), value);
    }

    public PartBuilder numberProperty(Supplier<NumberProperty> property, float value) {
        return this.numberProperty(property, (Supplier<GearType>)GearTypes.ALL, value, NumberProperty.Operation.AVERAGE);
    }

    public PartBuilder numberProperty(Supplier<NumberProperty> property, float value, NumberProperty.Operation operation) {
        return this.numberProperty(property, (Supplier<GearType>)GearTypes.ALL, value, operation);
    }

    public PartBuilder numberProperty(Supplier<NumberProperty> property, Supplier<GearType> gearType, float value, NumberProperty.Operation operation) {
        return this.property(PropertyKey.of(property, gearType), new NumberPropertyValue(value, operation));
    }

    public PartBuilder traits(List<TraitInstance> traits) {
        TraitListPropertyValue value = new TraitListPropertyValue(traits);
        return this.property(PropertyKey.of(GearProperties.TRAITS, GearTypes.ALL), value);
    }

    public JsonElement serialize() {
        SilentGear.LOGGER.info("Trying to serialize gear part \"{}\"", (Object)this.id);
        CoreGearPart part = new CoreGearPart(this.gearType, this.partType, Objects.requireNonNull(this.crafting), Objects.requireNonNull(this.display), this.properties);
        CoreGearPart.Serializer serializer = (CoreGearPart.Serializer)PartSerializers.CORE.get();
        DataResult jsonElementDataResult = serializer.codec().codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)part);
        if (jsonElementDataResult.isError()) {
            SilentGear.LOGGER.error("Something went wrong when serializing gear part \"{}\"", (Object)this.id);
        }
        JsonObject json = ((JsonElement)jsonElementDataResult.getOrThrow()).getAsJsonObject();
        Identifier serializerId = Objects.requireNonNull(SgRegistries.PART_SERIALIZER.getKey((Object)serializer));
        json.addProperty("type", serializerId.toString());
        return json;
    }
}

