/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.data.part;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.Identifier;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.data.part.PartBuilder;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.GearTypeMatcher;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.part.PartSerializers;
import net.silentchaos512.gear.gear.part.UpgradeGearPart;
import net.silentchaos512.gear.setup.SgRegistries;

public class UpgradePartBuilder
extends PartBuilder {
    private GearTypeMatcher upgradeGearTypes = GearTypeMatcher.ALL;

    public UpgradePartBuilder(Identifier id, Supplier<GearType> gearType, Supplier<PartType> partType) {
        super(id, gearType, partType);
    }

    public UpgradePartBuilder upgradeGearTypes(GearTypeMatcher matcher) {
        this.upgradeGearTypes = matcher;
        return this;
    }

    @Override
    public JsonElement serialize() {
        SilentGear.LOGGER.info("Trying to serialize upgrade part \"{}\"", (Object)this.id);
        UpgradeGearPart part = new UpgradeGearPart(this.gearType, this.partType, this.upgradeGearTypes, Objects.requireNonNull(this.crafting), Objects.requireNonNull(this.display), this.properties);
        UpgradeGearPart.Serializer serializer = (UpgradeGearPart.Serializer)PartSerializers.UPGRADE.get();
        DataResult jsonElementDataResult = serializer.codec().codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)part);
        if (jsonElementDataResult.isError()) {
            SilentGear.LOGGER.error("Something went wrong when serializing upgrade part \"{}\"", (Object)this.id);
        }
        JsonElement json = (JsonElement)jsonElementDataResult.getOrThrow();
        Identifier serializerId = Objects.requireNonNull(SgRegistries.PART_SERIALIZER.getKey((Object)serializer));
        json.getAsJsonObject().addProperty("type", serializerId.toString());
        return json;
    }
}

