/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.data.trait;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Util;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.gear.trait.Trait;
import net.silentchaos512.gear.gear.trait.condition.GearTypeTraitCondition;
import net.silentchaos512.gear.gear.trait.condition.OrTraitCondition;

public class TraitBuilder {
    private final DataResource<Trait> trait;
    protected final int maxLevel;
    private Component name;
    private Component description;
    private final List<TraitEffect> effects = new ArrayList<TraitEffect>();
    private final List<ITraitCondition> conditions = new ArrayList<ITraitCondition>();
    private final List<Identifier> cancelsList = new ArrayList<Identifier>();
    private final List<Identifier> overridesList = new ArrayList<Identifier>();
    private final List<Component> extraWikiLines = new ArrayList<Component>();

    public TraitBuilder(DataResource<Trait> trait, int maxLevel) {
        this.trait = trait;
        this.maxLevel = maxLevel;
        this.name = Component.translatable((String)Util.makeDescriptionId((String)"trait", (Identifier)this.trait.getId()));
        this.description = Component.translatable((String)(Util.makeDescriptionId((String)"trait", (Identifier)this.trait.getId()) + ".desc"));
    }

    public static TraitBuilder of(DataResource<Trait> trait, int maxLevel) {
        return new TraitBuilder(trait, maxLevel);
    }

    public DataResource<Trait> getTraitHolder() {
        return this.trait;
    }

    public TraitBuilder effects(TraitEffect first, TraitEffect ... rest) {
        if (!this.effects.isEmpty()) {
            throw new IllegalStateException("Already called 'effects' on this TraitBuilder!");
        }
        this.effects.add(first);
        if (rest.length > 0) {
            this.effects.addAll(Arrays.stream(rest).toList());
        }
        return this;
    }

    public TraitBuilder setName(Component text) {
        this.name = text;
        return this;
    }

    public TraitBuilder setDescription(Component text) {
        this.description = text;
        return this;
    }

    public TraitBuilder withConditions(ITraitCondition ... conditions) {
        Collections.addAll(this.conditions, conditions);
        return this;
    }

    @SafeVarargs
    public final TraitBuilder withGearTypeCondition(Supplier<GearType> first, Supplier<GearType> ... rest) {
        if (rest.length > 0) {
            ArrayList<GearType> types = new ArrayList<GearType>(rest.length + 1);
            types.add(first.get());
            Arrays.stream(rest).map(Supplier::get).forEach(types::add);
            ITraitCondition[] values = (GearTypeTraitCondition[])types.stream().map(GearTypeTraitCondition::new).toArray(GearTypeTraitCondition[]::new);
            return this.withConditions(new OrTraitCondition(values));
        }
        return this.withConditions(new GearTypeTraitCondition(first.get()));
    }

    public TraitBuilder cancelsWith(DataResource<Trait> trait) {
        return this.cancelsWith(trait.getId());
    }

    public TraitBuilder cancelsWith(Identifier trait) {
        this.cancelsList.add(trait);
        return this;
    }

    public TraitBuilder overridesTrait(DataResource<Trait> trait) {
        return this.overridesTrait(trait.getId());
    }

    public TraitBuilder overridesTrait(Identifier trait) {
        this.overridesList.add(trait);
        return this;
    }

    public TraitBuilder extraWikiLines(String ... lines) {
        for (String line : lines) {
            this.extraWikiLines.add((Component)Component.literal((String)line));
        }
        return this;
    }

    public TraitBuilder extraWikiLines(Component ... lines) {
        this.extraWikiLines.addAll(Arrays.asList(lines));
        return this;
    }

    public Trait build() {
        return new Trait(this.maxLevel, this.name, this.description, this.effects, this.conditions, this.extraWikiLines);
    }
}

