/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.data.trait;

import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.Identifier;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.data.trait.TraitBuilder;
import net.silentchaos512.gear.gear.trait.Trait;
import org.jetbrains.annotations.NotNull;

public abstract class TraitsProviderBase
implements DataProvider {
    protected final CompletableFuture<HolderLookup.Provider> lookupProvider;
    protected final DataGenerator generator;
    protected final String modId;

    public TraitsProviderBase(CompletableFuture<HolderLookup.Provider> lookupProvider, DataGenerator generator, String modId) {
        this.lookupProvider = lookupProvider;
        this.generator = generator;
        this.modId = modId;
    }

    public abstract Collection<TraitBuilder> getTraits(HolderLookup.Provider var1);

    @NotNull
    public String getName() {
        return "Silent Gear Traits: " + this.modId;
    }

    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        Path outputFolder = this.generator.getPackOutput().getOutputFolder();
        HashSet set = Sets.newHashSet();
        ArrayList list = new ArrayList();
        return this.lookupProvider.thenCompose(provider -> {
            this.getTraits((HolderLookup.Provider)provider).forEach(builder -> {
                Identifier id = builder.getTraitHolder().getId();
                if (!set.add(id)) {
                    throw new IllegalStateException("Duplicate trait: " + String.valueOf(id));
                }
                Path path = outputFolder.resolve(String.format("data/%s/silentgear_traits/%s.json", id.getNamespace(), id.getPath()));
                SilentGear.LOGGER.info("Serializing trait \"{}\"", (Object)id);
                list.add(DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)provider, Trait.CODEC, (Object)builder.build(), (Path)path));
            });
            return CompletableFuture.allOf(list.toArray(new CompletableFuture[0]));
        });
    }
}

