/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;
import net.silentchaos512.gear.api.item.GearTool;
import net.silentchaos512.gear.api.property.HarvestTier;
import net.silentchaos512.gear.api.property.HarvestTierPropertyValue;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.util.GearData;

public interface GearDiggerTool
extends GearTool {
    public TagKey<Block> getToolBlockSet(GearPropertiesData var1);

    default public TagKey<Block> getToolBlockSet(ItemStack stack) {
        return this.getToolBlockSet(GearData.getProperties(stack));
    }

    @Override
    default public Tool createToolProperties(ItemStack gear, GearPropertiesData properties, HolderGetter<Block> blocks) {
        float rawSpeed = properties.getNumber(GearProperties.HARVEST_SPEED);
        float harvestSpeed = Float.isNaN(rawSpeed) || rawSpeed < 0.1f ? 0.1f : rawSpeed;
        HarvestTierPropertyValue harvestTier = properties.getOrDefault(GearProperties.HARVEST_TIER, new HarvestTierPropertyValue(HarvestTier.ZERO));
        return new Tool(List.of(Tool.Rule.deniesDrops((HolderSet)blocks.getOrThrow(((HarvestTier)harvestTier.value()).incorrectForTool())), Tool.Rule.minesAndDrops((HolderSet)blocks.getOrThrow(this.getToolBlockSet(properties)), (float)harvestSpeed)), 1.0f, 1, true);
    }
}

