/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.NumberProperty;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.core.component.GearConstructionData;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.TraitHelper;

public interface GearItem
extends ItemLike {
    public static final Supplier<Collection<PartType>> REQUIRED_PARTS = Suppliers.memoize(() -> ImmutableList.of((Object)((PartType)PartTypes.MAIN.get())));

    default public ItemStack construct(Collection<PartInstance> parts) {
        ItemStack result = new ItemStack((ItemLike)this);
        GearData.writeConstructionParts(result, parts);
        GearData.recalculateGearData(result, null);
        parts.forEach(p -> p.onAddToGear(result));
        TraitHelper.activateTraits(result, 0, (trait, value) -> {
            trait.getTrait().onGearCrafted(new TraitActionContext(null, trait, result));
            return 0;
        });
        return result;
    }

    default public Item asItem() {
        return (Item)this;
    }

    public GearType getGearType();

    default public boolean requiresPartOfType(PartType type) {
        return this.getRequiredParts().contains(type);
    }

    default public boolean supportsPart(ItemStack gear, PartInstance part) {
        if (!part.isValid()) {
            return false;
        }
        boolean canAdd = part.get().canAddToGear(gear, part);
        return this.requiresPartOfType(part.getType()) && canAdd || canAdd;
    }

    default public Collection<PartType> getRequiredParts() {
        return REQUIRED_PARTS.get();
    }

    default public void onRecalculatePre(ItemStack gear, @Nullable Player player, @Nullable GearPropertiesData oldProperties, GearConstructionData constructionData) {
    }

    default public void onRecalculatePost(ItemStack gear, @Nullable Player player, GearPropertiesData finalProperties) {
    }

    default public void buildAttributes(ItemStack gear, ItemAttributeModifiers.Builder builder) {
        TraitHelper.getTraits(gear).forEach(inst -> {
            TraitActionContext context = new TraitActionContext(null, (TraitInstance)inst, gear);
            inst.getTrait().onGetAttributeModifiers(context, builder);
        });
    }

    default public Supplier<NumberProperty> getDurabilityStat() {
        return this.getGearType().durabilityStat();
    }

    default public float getRepairModifier(ItemStack stack) {
        return 1.0f;
    }
}

