/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.item.GearTool;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public interface GearRangedWeapon
extends GearTool {
    public static final Supplier<Collection<PartType>> REQUIRED_PARTS = Suppliers.memoize(() -> ImmutableList.of((Object)((PartType)PartTypes.MAIN.get()), (Object)((PartType)PartTypes.ROD.get()), (Object)((PartType)PartTypes.CORD.get())));

    @Override
    default public Collection<PartType> getRequiredParts() {
        return REQUIRED_PARTS.get();
    }

    default public float getBaseDrawDelay(ItemStack stack) {
        return 20.0f;
    }

    default public float getDrawDelay(ItemStack stack) {
        float speed = GearData.getProperties(stack).getNumber(GearProperties.DRAW_SPEED);
        if (speed <= 0.0f) {
            speed = 1.0f;
        }
        return this.getBaseDrawDelay(stack) / speed;
    }

    default public float getArrowDamage(ItemStack ammo) {
        if (GearHelper.isGear(ammo)) {
            return GearData.getProperties(ammo).getNumber(GearProperties.RANGED_DAMAGE);
        }
        return 1.0f;
    }
}

