/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.util.Lazy;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.GearHelper;
import org.jetbrains.annotations.Nullable;

public interface GearTool
extends GearItem {
    public static final Supplier<Collection<PartType>> REQUIRED_PARTS = Suppliers.memoize(() -> ImmutableList.of((Object)((PartType)PartTypes.MAIN.get()), (Object)((PartType)PartTypes.ROD.get())));

    default public Tool createToolProperties(ItemStack gear, GearPropertiesData properties, HolderGetter<Block> blocks) {
        return new Tool(List.of(), 1.0f, 2, true);
    }

    @Override
    default public void onRecalculatePost(ItemStack gear, @Nullable Player player, GearPropertiesData finalProperties) {
        GearItem.super.onRecalculatePost(gear, player, finalProperties);
        if (!GearHelper.isBroken(gear)) {
            HolderGetter blocksHolderGetter = ((HolderGetter.Provider)Helper.REGISTRY_LOOKUP.get()).lookupOrThrow(Registries.BLOCK);
            gear.set(DataComponents.TOOL, (Object)this.createToolProperties(gear, finalProperties, (HolderGetter<Block>)blocksHolderGetter));
            gear.set(DataComponents.WEAPON, (Object)new Weapon(2));
        }
    }

    @Override
    default public Collection<PartType> getRequiredParts() {
        return REQUIRED_PARTS.get();
    }

    public static class Helper {
        private static Lazy<HolderGetter.Provider> REGISTRY_LOOKUP = Lazy.of(VanillaRegistries::createLookup);
    }
}

