/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.ItemAbility;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearTypeMatcher;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyGroup;
import net.silentchaos512.gear.api.property.NumberProperty;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.util.CodecUtils;
import net.silentchaos512.gear.util.GearHelper;

public record GearType(@Nullable Supplier<GearType> parent, int animationFrames, Set<ItemAbility> itemAbilities, float armorDurabilityMultiplier, Supplier<NumberProperty> durabilityStat, Set<GearPropertyGroup> relevantPropertyGroups) {
    private final Set<GearPropertyGroup> relevantPropertyGroups;
    public static final Codec<GearType> CODEC = CodecUtils.byModNameCodec(SgRegistries.GEAR_TYPE);
    public static final StreamCodec<RegistryFriendlyByteBuf, GearType> STREAM_CODEC = ByteBufCodecs.registry(SgRegistries.GEAR_TYPE_KEY);
    private static final Map<GearType, GearItem> ITEMS = new HashMap<GearType, GearItem>();

    public GearType(@Nullable Supplier<GearType> parent, int animationFrames, Set<ItemAbility> itemAbilities, float armorDurabilityMultiplier, Supplier<NumberProperty> durabilityStat, Set<GearPropertyGroup> relevantPropertyGroups) {
        this.parent = parent;
        this.animationFrames = animationFrames;
        this.itemAbilities = itemAbilities;
        this.armorDurabilityMultiplier = armorDurabilityMultiplier;
        this.durabilityStat = durabilityStat;
        this.relevantPropertyGroups = ImmutableSet.copyOf(relevantPropertyGroups);
    }

    @Nullable
    public static GearItem getItem(GearType type) {
        return ITEMS.computeIfAbsent(type, gt -> {
            for (Item item : BuiltInRegistries.ITEM) {
                GearItem gearItem;
                if (!(item instanceof GearItem) || (gearItem = (GearItem)item).getGearType() != type) continue;
                return gearItem;
            }
            return null;
        });
    }

    public boolean canPerformAction(ItemAbility action) {
        return this.itemAbilities.contains(action);
    }

    public boolean matches(GearType type) {
        return this.matches(type, true);
    }

    public boolean matches(GearType type, boolean includeAll) {
        return includeAll && ((GearType)GearTypes.ALL.get()).equals(type) || this.equals(type) || this.parent != null && this.parent.get().matches(type, includeAll);
    }

    public boolean isGear() {
        return this.matches((GearType)GearTypes.ALL.get(), false);
    }

    public boolean isArmor() {
        return this.matches((GearType)GearTypes.ARMOR.get(), false);
    }

    public Component getDisplayName() {
        Identifier name = SgRegistries.GEAR_TYPE.getKey((Object)this);
        if (name == null) {
            return Component.literal((String)"Unknown Gear Type");
        }
        return Component.translatable((String)("gearType." + name.getNamespace() + "." + name.getPath()));
    }

    public GearTypeMatcher getMatcher(boolean matchParents) {
        return new GearTypeMatcher(matchParents, this);
    }

    public int getBaseDurability(GearPropertiesData baseProperties) {
        float baseValue = baseProperties.getNumber(this.durabilityStat);
        if (this.durabilityStat.get() == GearProperties.ARMOR_DURABILITY.get()) {
            return Math.round(this.armorDurabilityMultiplier * baseValue);
        }
        return Math.round(baseValue);
    }

    public Set<GearPropertyGroup> relevantPropertyGroups() {
        if (this.relevantPropertyGroups.isEmpty() && this.parent != null) {
            return this.parent.get().relevantPropertyGroups();
        }
        return this.relevantPropertyGroups;
    }

    public boolean isPropertyRelevant(GearProperty<?, ?> propertyType) {
        for (GearPropertyGroup group : this.relevantPropertyGroups) {
            if (propertyType.getGroup() != group) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Identifier thisKey = Objects.requireNonNull(SgRegistries.GEAR_TYPE.getKey((Object)this));
        Identifier thatKey = Objects.requireNonNull(SgRegistries.GEAR_TYPE.getKey((Object)((GearType)obj)));
        return thisKey.equals((Object)thatKey);
    }

    @Override
    public int hashCode() {
        Identifier key = Objects.requireNonNull(SgRegistries.GEAR_TYPE.getKey((Object)this));
        return key.hashCode();
    }

    @Override
    public String toString() {
        return this.getDisplayName().getString();
    }

    public static class Builder {
        @Nullable
        private final Supplier<GearType> parent;
        private int animationFrames = 1;
        private Supplier<NumberProperty> durabilityStat = GearProperties.DURABILITY;
        private float armorDurabilityMultiplier = 1.0f;
        private Set<ItemAbility> toolActions = Collections.emptySet();
        private final Set<GearPropertyGroup> relevantPropertyGroups = new LinkedHashSet<GearPropertyGroup>();

        private Builder(@Nullable Supplier<GearType> parent) {
            this.parent = parent;
        }

        public static Builder of() {
            return Builder.of(null);
        }

        public static Builder of(@Nullable Supplier<GearType> parent) {
            return new Builder(parent);
        }

        public GearType build() {
            return new GearType(this.parent, this.animationFrames, this.toolActions, this.armorDurabilityMultiplier, this.durabilityStat, this.relevantPropertyGroups);
        }

        public Builder animationFrames(int animationFrames) {
            this.animationFrames = animationFrames;
            return this;
        }

        public Builder durabilityStat(Supplier<NumberProperty> durabilityStat) {
            this.durabilityStat = durabilityStat;
            return this;
        }

        public Builder armorDurabilityMultiplier(float amount) {
            this.armorDurabilityMultiplier = amount;
            return this;
        }

        public Builder toolActions(ItemAbility ... actions) {
            this.toolActions = GearHelper.makeItemAbilitySet(actions);
            return this;
        }

        public Builder toolActions(Set<ItemAbility> actions) {
            this.toolActions = Collections.unmodifiableSet(actions);
            return this;
        }

        public Builder relevantPropertyGroups(GearPropertyGroup ... propertyGroups) {
            return this.relevantPropertyGroups(Arrays.asList(propertyGroups));
        }

        public Builder relevantPropertyGroups(Collection<GearPropertyGroup> propertyGroups) {
            this.relevantPropertyGroups.addAll(propertyGroups);
            return this;
        }
    }
}

