/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.silentchaos512.gear.SilentGear;

public enum TextureType {
    HIGH_CONTRAST("hc"),
    LOW_CONTRAST("lc");

    private final String alias;
    private final Identifier armorTexture1;
    private final Identifier armorTexture2;
    public static final Codec<TextureType> CODEC;
    public static final StreamCodec<FriendlyByteBuf, TextureType> STREAM_CODEC;

    private TextureType(String alias) {
        this.alias = alias;
        this.armorTexture1 = SilentGear.getId("textures/models/armor/main_generic_" + this.alias + "_layer_1.png");
        this.armorTexture2 = SilentGear.getId("textures/models/armor/main_generic_" + this.alias + "_layer_2.png");
    }

    public Identifier getArmorTexture(boolean innerModel) {
        return innerModel ? this.armorTexture2 : this.armorTexture1;
    }

    @Nullable
    public static TextureType fromString(String str) {
        for (TextureType type : TextureType.values()) {
            if (!str.equalsIgnoreCase(type.name()) && !str.equalsIgnoreCase(type.alias)) continue;
            return type;
        }
        return null;
    }

    static {
        CODEC = Codec.STRING.comapFlatMap(str -> {
            TextureType type = TextureType.fromString(str);
            return type != null ? DataResult.success((Object)((Object)type)) : DataResult.error(() -> "Unknown texture type: " + str);
        }, Enum::name);
        STREAM_CODEC = StreamCodec.of((buf, val) -> buf.writeBoolean(val == HIGH_CONTRAST), buf -> buf.readBoolean() ? HIGH_CONTRAST : LOW_CONTRAST);
    }
}

