/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.property;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.property.GearPropertyGroup;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.util.GearComponentInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.client.util.GearTooltipFlag;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.Color;
import org.apache.commons.lang3.function.TriConsumer;

public abstract class GearProperty<T, V extends GearPropertyValue<T>> {
    protected final T baseValue;
    protected final T defaultValue;
    protected final T minimumValue;
    protected final T maximumValue;
    protected final GearPropertyGroup group;
    protected final Color nameColor;
    protected final boolean affectedBySynergy;
    protected final boolean affectedByGrades;
    protected final boolean forMaterialsOnly;
    protected final boolean visible;
    @Nullable
    private final TriConsumer<ItemStack, T, ItemAttributeModifiers.Builder> attributeAdder;
    @Nullable
    private final BiConsumer<ItemStack, T> dataComponentAdder;

    protected GearProperty(Builder<T> builder) {
        builder.validate();
        this.baseValue = builder.baseValue;
        this.defaultValue = builder.defaultValue;
        this.minimumValue = builder.minimumValue;
        this.maximumValue = builder.maximumValue;
        this.affectedBySynergy = builder.affectedBySynergy;
        this.affectedByGrades = builder.affectedByGrades;
        this.forMaterialsOnly = builder.forMaterialsOnly;
        this.group = builder.group;
        this.nameColor = builder.nameColor;
        this.visible = builder.visible;
        this.attributeAdder = builder.attributeAdder;
        this.dataComponentAdder = builder.dataComponentAdder;
    }

    public abstract Codec<V> codec();

    public abstract StreamCodec<? super RegistryFriendlyByteBuf, V> streamCodec();

    public StreamCodec<FriendlyByteBuf, GearPropertyValue<?>> rawStreamCodec() {
        return this.streamCodec();
    }

    public abstract V valueOf(T var1);

    public T compute(Collection<V> modifiers) {
        return this.compute(this.baseValue, true, (GearType)GearTypes.ALL.get(), modifiers);
    }

    public T compute(T baseValue, Collection<V> modifiers) {
        return this.compute(baseValue, true, (GearType)GearTypes.ALL.get(), modifiers);
    }

    public T compute(T baseValue, boolean clampResult, GearType gearType, Collection<V> modifiers) {
        return this.compute(baseValue, clampResult, gearType, gearType, modifiers);
    }

    public abstract T compute(T var1, boolean var2, GearType var3, GearType var4, Collection<V> var5);

    public T computeForGear(T baseValue, boolean clampResult, GearType itemType, GearType statType, Collection<V> modifiers, List<PartInstance> parts, ItemStack gear) {
        return this.compute(baseValue, clampResult, itemType, statType, modifiers);
    }

    public V computeUnchecked(boolean clampResult, GearType itemType, GearType statType, Collection<GearPropertyValue<?>> modifiers) {
        return this.valueOf(this.compute(this.getBaseValue(), clampResult, itemType, statType, modifiers));
    }

    public V computeUncheckedForGear(GearType itemType, GearType statType, Collection<GearPropertyValue<?>> modifiers, List<PartInstance> parts, ItemStack gear) {
        return this.valueOf(this.computeForGear(this.getBaseValue(), true, itemType, statType, modifiers, parts, gear));
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getBaseValue() {
        return this.baseValue;
    }

    public T getMinimumValue() {
        return this.minimumValue;
    }

    public T getMaximumValue() {
        return this.maximumValue;
    }

    public abstract T getZeroValue();

    public abstract boolean isZero(T var1);

    public boolean isAffectedByGrades() {
        return this.affectedByGrades;
    }

    public boolean isAffectedBySynergy() {
        return this.affectedBySynergy;
    }

    public boolean isForMaterialsOnly() {
        return this.forMaterialsOnly;
    }

    public GearPropertyGroup getGroup() {
        return this.group;
    }

    public abstract List<V> compressModifiers(Collection<V> var1, PartGearKey var2, List<? extends GearComponentInstance<?>> var3);

    public V applySynergy(V value, float synergy) {
        return value;
    }

    @Deprecated(forRemoval=true)
    public List<Component> getTooltipLines(V value, GearTooltipFlag flag) {
        return List.of(this.formatText(value, flag));
    }

    @Deprecated(forRemoval=true)
    public final List<Component> getTooltipLinesUnchecked(GearPropertyValue<?> value, GearTooltipFlag flag) {
        return this.getTooltipLines(value, flag);
    }

    public final boolean isHiddenUnchecked(GearPropertyValue<?> value, GearTooltipFlag flag) {
        return this.isHidden(value, flag);
    }

    public boolean isHidden(V value, GearTooltipFlag flag) {
        return false;
    }

    public final void buildTooltipUnchecked(TextListBuilder listBuilder, GearPropertyValue<?> value, ItemStack gearItemStack, GearTooltipFlag flag) {
        this.buildTooltip(listBuilder, value, gearItemStack, flag);
    }

    public void buildTooltip(TextListBuilder listBuilder, V value, ItemStack gearItemStack, GearTooltipFlag flag) {
        listBuilder.add(this.formatText(value, flag));
    }

    public final Component formatTextUnchecked(GearPropertyValue<?> value, GearTooltipFlag flag) {
        return this.formatText(value, flag);
    }

    public Component formatText(V value, GearTooltipFlag flag) {
        Component valueText = this.formatValue(value, FormatContext.GEAR);
        return this.formatText(valueText);
    }

    public Component formatText(Component valueText) {
        MutableComponent propertyName = TextUtil.withColor(this.getDisplayName(), this.nameColor);
        return Component.translatable((String)"property.silentgear.displayFormat", (Object[])new Object[]{propertyName, valueText});
    }

    public abstract Component formatValue(V var1, FormatContext var2);

    public abstract MutableComponent formatValueWithColor(V var1, boolean var2, FormatContext var3);

    public Component formatModifiersUnchecked(Collection<? extends GearPropertyValue<?>> mods, boolean addModColors, FormatContext formatContext) {
        return this.formatModifiers(mods, addModColors, formatContext);
    }

    public Component formatModifiers(Collection<V> mods, boolean addModColors, FormatContext formatContext) {
        if (mods.size() == 1) {
            GearPropertyValue inst = (GearPropertyValue)mods.iterator().next();
            int decimalPlaces = this.getPreferredDecimalPlaces(inst);
            return this.formatValueWithColor(inst, addModColors, formatContext);
        }
        MutableComponent result = Component.literal((String)"");
        List<V> toSort = this.sortForDisplay(mods);
        for (GearPropertyValue value : toSort) {
            if (!result.getSiblings().isEmpty()) {
                result.append(", ");
            }
            result.append((Component)this.formatValueWithColor(value, addModColors, formatContext));
        }
        return result;
    }

    public MutableComponent formatModifiersWithColorUnchecked(Collection<GearPropertyValue<?>> mods, boolean addColor, FormatContext formatContext) {
        V value = this.valueOf(this.compute(mods));
        return this.formatValueWithColor(value, addColor, formatContext);
    }

    public int getPreferredDecimalPlaces(V value) {
        return 0;
    }

    public List<V> sortForDisplay(Collection<V> mods) {
        return new ArrayList<V>(mods);
    }

    public MutableComponent getDisplayName() {
        Identifier name = SgRegistries.GEAR_PROPERTY.getKey((Object)this);
        if (name == null) {
            return Component.literal((String)"ERROR");
        }
        return Component.translatable((String)("property." + name.getNamespace() + "." + name.getPath()));
    }

    public void addAttributes(ItemStack stack, T value, ItemAttributeModifiers.Builder builder) {
        if (this.attributeAdder != null) {
            this.attributeAdder.accept((Object)stack, value, (Object)builder);
        }
    }

    public void addDataComponents(ItemStack stack, T value) {
        if (this.dataComponentAdder != null) {
            this.dataComponentAdder.accept(stack, (ItemStack)value);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GearProperty)) {
            return false;
        }
        GearProperty other = (GearProperty)obj;
        Identifier key = SgRegistries.GEAR_PROPERTY.getKey((Object)this);
        assert (key != null);
        return key.equals((Object)SgRegistries.GEAR_PROPERTY.getKey((Object)other));
    }

    public int hashCode() {
        Identifier key = SgRegistries.GEAR_PROPERTY.getKey((Object)this);
        return key != null ? key.hashCode() : super.hashCode();
    }

    public static class Builder<T> {
        private final T baseValue;
        private final T defaultValue;
        private final T minimumValue;
        private final T maximumValue;
        private GearPropertyGroup group;
        private Color nameColor;
        private boolean affectedBySynergy;
        private boolean affectedByGrades;
        public boolean forMaterialsOnly;
        private boolean visible;
        @Nullable
        private TriConsumer<ItemStack, T, ItemAttributeModifiers.Builder> attributeAdder = null;
        @Nullable
        private BiConsumer<ItemStack, T> dataComponentAdder = null;

        public Builder(T defaultValue) {
            this(defaultValue, defaultValue);
        }

        public Builder(T defaultValue, T baseValue) {
            this(defaultValue, baseValue, defaultValue, defaultValue);
        }

        public Builder(T defaultValue, T baseValue, T minimumValue, T maximumValue) {
            this.defaultValue = defaultValue;
            this.baseValue = baseValue;
            this.minimumValue = minimumValue;
            this.maximumValue = maximumValue;
        }

        public void validate() {
            if (this.group == null) {
                throw new IllegalStateException("Gear property group is null");
            }
            if (this.nameColor == null) {
                throw new IllegalStateException("Gear property name color is null");
            }
        }

        public Builder<T> group(GearPropertyGroup category) {
            this.group = category;
            if (this.nameColor == null) {
                this.nameColor = this.group.getColor();
            }
            return this;
        }

        public Builder<T> nameColor(Color color) {
            this.nameColor = color;
            return this;
        }

        public Builder<T> affectedBySynergy(boolean value) {
            this.affectedBySynergy = value;
            return this;
        }

        public Builder<T> affectedByGrades(boolean value) {
            this.affectedByGrades = value;
            return this;
        }

        public Builder<T> forMaterialsOnly(boolean value) {
            this.forMaterialsOnly = value;
            return this;
        }

        public Builder<T> visible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public Builder<T> onGetAttributes(TriConsumer<ItemStack, T, ItemAttributeModifiers.Builder> consumer) {
            this.attributeAdder = consumer;
            return this;
        }

        public Builder<T> onAddDataComponents(BiConsumer<ItemStack, T> consumer) {
            this.dataComponentAdder = consumer;
            return this;
        }
    }

    public static enum FormatContext {
        GEAR,
        PART,
        MATERIAL,
        ANY;

    }
}

