/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.property;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.component.KineticWeapon;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.property.KineticWeaponPropertyValue;
import net.silentchaos512.gear.api.util.GearComponentInstance;
import net.silentchaos512.gear.api.util.PartGearKey;

public class KineticWeaponProperty
extends GearProperty<KineticWeapon, KineticWeaponPropertyValue> {
    public static final KineticWeapon ZERO = new KineticWeapon(0, 0, Optional.empty(), Optional.empty(), Optional.empty(), 0.0f, 0.0f, Optional.empty(), Optional.empty());
    public static final Codec<KineticWeaponPropertyValue> CODEC = GearPropertyValue.createSimpleValueCodec(KineticWeapon.CODEC, KineticWeaponPropertyValue::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, KineticWeaponPropertyValue> STREAM_CODEC = GearPropertyValue.createSimpleStreamCodec(KineticWeapon.STREAM_CODEC, KineticWeaponPropertyValue::new);

    public KineticWeaponProperty(GearProperty.Builder<KineticWeapon> builder) {
        super(builder);
    }

    @Override
    public Codec<KineticWeaponPropertyValue> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, KineticWeaponPropertyValue> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public KineticWeaponPropertyValue valueOf(KineticWeapon value) {
        return new KineticWeaponPropertyValue(value);
    }

    @Override
    public KineticWeapon compute(KineticWeapon baseValue, boolean clampResult, GearType itemType, GearType statType, Collection<KineticWeaponPropertyValue> modifiers) {
        if (modifiers.isEmpty()) {
            return this.getZeroValue();
        }
        int totalContactCooldownTicks = 0;
        int totalDelayTicks = 0;
        Optional dismountConditions = Optional.empty();
        Optional knockbackConditions = Optional.empty();
        Optional damageConditions = Optional.empty();
        float totalForwardMovement = 0.0f;
        float totalDamageMultiplier = 0.0f;
        Optional sound = Optional.empty();
        Optional hitSound = Optional.empty();
        for (KineticWeaponPropertyValue value : modifiers) {
            totalContactCooldownTicks += ((KineticWeapon)value.value).contactCooldownTicks();
            totalDelayTicks += ((KineticWeapon)value.value).delayTicks();
            if (dismountConditions.isEmpty()) {
                dismountConditions = ((KineticWeapon)value.value).dismountConditions();
            }
            if (knockbackConditions.isEmpty()) {
                knockbackConditions = ((KineticWeapon)value.value).knockbackConditions();
            }
            if (damageConditions.isEmpty()) {
                damageConditions = ((KineticWeapon)value.value).damageConditions();
            }
            totalForwardMovement += ((KineticWeapon)value.value).forwardMovement();
            totalDamageMultiplier += ((KineticWeapon)value.value).damageMultiplier();
            if (sound.isEmpty()) {
                sound = ((KineticWeapon)value.value).sound();
            }
            if (!hitSound.isEmpty()) continue;
            hitSound = ((KineticWeapon)value.value).hitSound();
        }
        return new KineticWeapon(totalContactCooldownTicks / modifiers.size(), totalDelayTicks / modifiers.size(), dismountConditions, knockbackConditions, damageConditions, totalForwardMovement / (float)modifiers.size(), totalDamageMultiplier / (float)modifiers.size(), sound, hitSound);
    }

    @Override
    public KineticWeapon getZeroValue() {
        return ZERO;
    }

    @Override
    public boolean isZero(KineticWeapon value) {
        return value.equals((Object)this.getZeroValue());
    }

    @Override
    public List<KineticWeaponPropertyValue> compressModifiers(Collection<KineticWeaponPropertyValue> modifiers, PartGearKey key, List<? extends GearComponentInstance<?>> components) {
        return List.of(new KineticWeaponPropertyValue(this.compute((KineticWeapon)this.getBaseValue(), true, key.gearType(), modifiers)));
    }

    @Override
    public Component formatValue(KineticWeaponPropertyValue value, GearProperty.FormatContext formatContext) {
        return Component.literal((String)String.format("KineticWeapon(cct=%d,dt=%d,p1=%s,p2=%s,p3=%s,fm=%.2f,dmg=%.2f)", ((KineticWeapon)value.value).contactCooldownTicks(), ((KineticWeapon)value.value).delayTicks(), ((KineticWeapon)value.value).dismountConditions().isPresent() ? this.formatKineticWeaponCondition((KineticWeapon.Condition)((KineticWeapon)value.value).dismountConditions().get()) : "None", ((KineticWeapon)value.value).knockbackConditions().isPresent() ? this.formatKineticWeaponCondition((KineticWeapon.Condition)((KineticWeapon)value.value).knockbackConditions().get()) : "None", ((KineticWeapon)value.value).damageConditions().isPresent() ? this.formatKineticWeaponCondition((KineticWeapon.Condition)((KineticWeapon)value.value).damageConditions().get()) : "None", Float.valueOf(((KineticWeapon)value.value).forwardMovement()), Float.valueOf(((KineticWeapon)value.value).damageMultiplier())));
    }

    private String formatKineticWeaponCondition(KineticWeapon.Condition condition) {
        return String.format("(dt=%dt,ms=%.2f,rs=%.2f)", condition.maxDurationTicks(), Float.valueOf(condition.minSpeed()), Float.valueOf(condition.minRelativeSpeed()));
    }

    @Override
    public MutableComponent formatValueWithColor(KineticWeaponPropertyValue value, boolean addColor, GearProperty.FormatContext formatContext) {
        return this.formatValue(value, formatContext).plainCopy();
    }
}

